<?php
/**
 * Downloads
 *
 * Shows downloads on the account page.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/downloads.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.8.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$downloads = WC()->customer->get_downloadable_products();
$has_downloads = (bool) $downloads;

do_action( 'woocommerce_before_account_downloads', $has_downloads ); ?>

<?php if ( $has_downloads ) : ?>

		<?php do_action( 'woocommerce_before_available_downloads' ); ?>

		<?php do_action( 'woocommerce_available_downloads', $downloads ); ?>

		<?php do_action( 'woocommerce_after_available_downloads' ); ?>

<?php else : ?>
    <div class="d-flex align-items-center flex-column justify-content-center" style="height: 440px;">
        <svg width="80" height="72" viewBox="0 0 80 72" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M60.8333 56.8334H60.875M62.5 44.3334H65C68.8828 44.3334 70.8243 44.3334 72.3557 44.9677C74.3976 45.8135 76.0199 47.4358 76.8657 49.4777C77.5 51.0091 77.5 52.9505 77.5 56.8334C77.5 60.7162 77.5 62.6576 76.8657 64.1891C76.0199 66.231 74.3976 67.8532 72.3557 68.699C70.8243 69.3334 68.8828 69.3334 65 69.3334H15C11.1172 69.3334 9.17573 69.3334 7.6443 68.699C5.6024 67.8532 3.98012 66.231 3.13434 64.1891C2.5 62.6576 2.5 60.7162 2.5 56.8334C2.5 52.9505 2.5 51.0091 3.13434 49.4777C3.98012 47.4358 5.6024 45.8135 7.6443 44.9677C9.17573 44.3334 11.1172 44.3334 15 44.3334H17.5M40 48.5V2.66669M40 48.5L27.5 36M40 48.5L52.5 36" stroke="#FF9191" stroke-width="5" stroke-linecap="round" stroke-linejoin="round"/>
		</svg>

        <?php
			$wp_button_class = wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '';
			wc_print_notice( esc_html__( 'No downloads available yet.', 'woocommerce' ) . ' <a class="button wc-forward' . esc_attr( $wp_button_class ) . '" href="' . esc_url( apply_filters( 'woocommerce_return_to_shop_redirect', wc_get_page_permalink( 'shop' ) ) ) . '">' . esc_html__( 'Browse products', 'woocommerce' ) . '</a>', 'notice' ); // phpcs:ignore WooCommerce.Commenting.CommentHooks.MissingHookComment 
			?>
    </div>
<?php endif; ?>

<?php do_action( 'woocommerce_after_account_downloads', $has_downloads ); ?>