<?php
/**
 * Template part for displaying single post Standard hero content - Layout 8
 */
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

$cls = (option_value('single-format-standard-layout-8-radius'))? ' radius' : '';
$cls .= (option_value('single-format-standard-layout-8-shadow'))? ' shadow' : '';

$post_layout_meta = option_value('single-format-standard-layout-8-meta');
$meta_args = array(
    'category' => $post_layout_meta['category'],
    'author-name' => $post_layout_meta['author-name'],
    'author-avatar' => $post_layout_meta['author-avatar'],
    'date' => $post_layout_meta['date'],
    'reading-time' => $post_layout_meta['reading-time'],
    'views' => $post_layout_meta['views'],
    'comments' => $post_layout_meta['comments'],
    'excerpt' => $post_layout_meta['excerpt'],
);

?>
<div class="single-hero-layout-8">
    <div class="image-container<?php echo esc_html($cls); ?>">
        <?php
        if(option_value('single-format-standard-layout-1-full-img'))
            the_post_thumbnail('full', array( 'title' => get_the_title() ));
        else
            the_post_thumbnail('theme-large', array( 'title' => get_the_title() ));
        ?>
    </div>
    <div class="content-container">
        <?php get_template_part('template-parts/post/hero/title-section-1', '', $meta_args); ?>
    </div>
</div>

