<?php
/**
 * Template part for displaying single post Standard hero content - Layout 20
 */
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

$cls = (option_value('single-format-standard-layout-20-title-bg'))? ' title-bg' : '';

$post_layout_meta = option_value('single-format-standard-layout-20-meta');
$meta_args = array(
    'category' => $post_layout_meta['category'],
    'author-name' => $post_layout_meta['author-name'],
    'author-avatar' => $post_layout_meta['author-avatar'],
    'date' => $post_layout_meta['date'],
    'reading-time' => $post_layout_meta['reading-time'],
    'views' => false,
    'comments' => false,
    'excerpt' => $post_layout_meta['excerpt'],
);

?>
<div class="single-hero-layout-20">
    <div class="single-hero-layout-20-container<?php echo esc_html($cls); ?>" style="background-image: url(<?php echo esc_url(get_the_post_thumbnail_url(NULL, 'full')); ?>);">
        <div class="single-hero-layout-20-overlay"></div>
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="content-container">
                        <?php get_template_part('template-parts/post/hero/title-section-1', '', $meta_args); ?>

                        <?php if($post_layout_meta['comments'] || $post_layout_meta['views']): ?>
                            <div class="top-container">
                                <?php if( $post_layout_meta['views'] ): ?>
                                    <div class="views" title="<?php esc_html_e('Views', THEME_NAME); ?>">
                                        <i class="icon isax isax-eye"></i>
                                        <span class="count"><?php echo get_post_view(get_the_ID()); ?></span>
                                    </div>
                                <?php endif; ?>

                                <?php if( $post_layout_meta['comments'] ): ?>
                                    <div class="comments" title="<?php esc_html_e('comments', THEME_NAME); ?>">
                                        <a href="#comments">
                                            <?php $comments_count = get_comments_number(); ?>
                                            <i class="icon isax isax-quote-end-circle"></i>
                                            <span class="count"><?php echo esc_html($comments_count); ?></span>
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

