<?php
get_header( 'shop' );

$template_id = option_value( 'page-single-product-template' );
global $post;
$product_slug = $post->post_name;
$product = get_page_by_path( $product_slug, OBJECT, 'product' );
$product_categories = wp_get_post_terms( $product->ID, 'product_cat', array( 'fields' => 'all' ) );
$first_category = $product_categories[0];
$template_id_category = get_term_meta( $first_category->term_id, 'category-single', true );

if ( ! empty( $template_id_category ) && $template_id_category !== '0' ) {
	$template_id = $template_id_category;
}

if ( $template_id ) {
	$template = show_template( $template_id );
	echo ( $template );
} else {
	// Load the default WooCommerce single-product template
	/**
	 * The Template for displaying all single products
	 *
	 * This template can be overridden by copying it to yourtheme/woocommerce/single-product.php.
	 *
	 * HOWEVER, on occasion WooCommerce will need to update template files and you
	 * (the theme developer) will need to copy the new files to your theme to
	 * maintain compatibility. We try to do this as little as possible, but it does
	 * happen. When this occurs the version of the template file will be bumped and
	 * the readme will list any important changes.
	 *
	 * @see         https://woocommerce.com/document/template-structure/
	 * @package     WooCommerce\Templates
	 * @version     1.6.4
	 */

	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly
	}
	/**
	 * woocommerce_before_main_content hook.
	 *
	 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
	 * @hooked woocommerce_breadcrumb - 20
	 */
	do_action( 'woocommerce_before_main_content' );
	?>

	<?php while ( have_posts() ) : ?>
		<?php the_post(); ?>

		<?php wc_get_template_part( 'content', 'single-product' ); ?>

	<?php endwhile; // end of the loop. ?>

	<?php
	/**
	 * woocommerce_after_main_content hook.
	 *
	 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
	 */
	do_action( 'woocommerce_after_main_content' );
	?>

	<?php
	/**
	 * woocommerce_sidebar hook.
	 *
	 * @hooked woocommerce_get_sidebar - 10
	 */
	do_action( 'woocommerce_sidebar' );

	/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */

}
get_footer( 'shop' );

?>