<?php
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class theme_mega_menu extends Walker_Nav_Menu {

    function __construct() {
        
        add_action('wp_nav_menu_item_custom_fields', array( $this, 'add_meta_admin_menu_item' ), 10, 3 );
        add_action('wp_update_nav_menu_item', array( $this, 'update_meta_admin_menu_item' ), 10, 2 );
        add_action('wp_nav_menu_objects', array( $this, 'remove_default_submenu' ), 10, 2 );
        add_action('walker_nav_menu_start_el', array( $this, 'add_mega_menu_content' ), 10, 4 );
        add_action('nav_menu_css_class', array( $this, 'add_class_mega_menu_li' ), 10, 4 );
		add_filter( 'nav_menu_item_title', [ $this, 'add_data_to_menu_item' ], 10, 4 );
    }

    // Add meta to admin menu item
    function add_meta_admin_menu_item ($item_id, $item, $depth) {
        
        ?>
        <div class="menu-option">
            <?php if ( $depth == 0 ) { 
                $current_template = get_post_meta($item_id, 'theme_mega_menu', true);
                $templates = get_all_header_template();
        
                $templates_default = [0 => $templates[0]]; // 0 => Default
                unset($templates[0]);// remove 0 => Default
        
                $templates = $templates_default + $templates;
                ?>
                <p class="description description-wide">
                    <label for="theme_mega_menu-<?php echo esc_html( $item_id ); ?>" >
                        <?php esc_html_e( 'Mega Menu Template', THEME_NAME ); ?>
                    </label>
                    <select name="theme_mega_menu[<?php echo esc_html( $item_id ); ?>]" id="theme_mega_menu-<?php echo esc_html( $item_id ); ?>" class="widefat">
                        <?php
                        foreach ( $templates as $id => $name ) {
                            echo '<option value="' . $id . '" ' . selected( $id, $current_template, false ) . '>' . esc_html( $name ) . '</option>';
                        }
                        ?>
                    </select>
                </p>

                <!-- mega-menu-width -->
                <div class="description description-thin">
                    <label for="theme_mega_menu_width-<?php echo esc_html( $item_id ); ?>">
                        <?php esc_html_e( 'Mega Menu Width', THEME_NAME ); ?>
                    </label>
                    <input type="number" name="theme_mega_menu_width[<?php echo esc_html( $item_id ); ?>]" id="theme_mega_menu_width-<?php echo esc_html( $item_id ); ?>" value="<?php echo esc_html( get_post_meta( $item_id, 'theme_mega_menu_width', true ) ); ?>">
                </div>

                <!-- mega-menu-margin -->
                <div class="description description-thin">
                    <label for="mega_menu_margin_<?php echo esc_html( $item_id ); ?>">
                        <?php esc_html_e( 'Mega Menu Margin', THEME_NAME ); ?>
                    </label>
                    <div class="margin-sellector">
                        <input name="theme_mega_menu_margin_top[<?php echo esc_html( $item_id ); ?>]" value="<?php echo esc_html( get_post_meta( $item_id, 'theme_mega_menu_margin_top', true ) ); ?>" type="number" placeholder="Top">
                        <input name="theme_mega_menu_margin_right[<?php echo esc_html( $item_id ); ?>]" value="<?php echo esc_html( get_post_meta( $item_id, 'theme_mega_menu_margin_right', true ) ); ?>" type="number" placeholder="Right">
                        <input name="theme_mega_menu_margin_btn[<?php echo esc_html( $item_id ); ?>]" value="<?php echo esc_html( get_post_meta( $item_id, 'theme_mega_menu_margin_btn', true ) ); ?>" type="number" placeholder="Bottom">
                        <input name="theme_mega_menu_margin_left[<?php echo esc_html( $item_id ); ?>]" value="<?php echo esc_html( get_post_meta( $item_id, 'theme_mega_menu_margin_left', true ) ); ?>" type="number" placeholder="Left">
                    </div>
                </div>

                <?php
			}
			$advance_menu_options = get_post_meta( $item_id, 'advance_menu_options', true );
            ?>
            <div class="description description-wide">
                <p class="custom-title">
					<?php esc_html_e( 'advance menu options', THEME_NAME ); ?>
                </p>
                <div class="mega-menu-advance-switcher">
                    <span class="mega-menu-advance-on">فعال</span>
                    <span class="mega-menu-advance-off">غیرفعال</span>
                    <span class="mega-menu-advance-ball"></span>
                    <input type="hidden" name="advance_menu_options[<?php echo esc_html( $item_id ); ?>]" value="<?php echo esc_html( $advance_menu_options ? '1' : '0' ); ?>" data-depend-id="show_advance_menu">
                </div>
            </div>

            <?php
            // Get current values
            $current_first_menu_icon = get_post_meta($item_id, 'first_menu_icon', true);
            $current_sec_menu_icon = get_post_meta($item_id, 'sec_menu_icon', true);

            // Get the icons from the Iconsax_class
            $first_menu_icons = \Skb_Cife\Iconsax_class::get_instance()->get_iconsax_icons();

            // Set default icons
            $first_menu_icon_default = [0 => $first_menu_icons[0]]; // 0 => Default
            unset($first_menu_icons[0]); // remove 0 => Default
            $first_menu_icons = $first_menu_icon_default + $first_menu_icons;
            ?>
            <div class="advance-panel description description-wide">
                <p><?php esc_html_e( 'advance menu options', THEME_NAME ); ?></p>

                <div class="description description-wide">
                    <!-- First Menu Icon Selector -->
                    <label for="first_menu_icon-<?php echo esc_html($item_id); ?>">
                        <?php esc_html_e('First Menu Icon', THEME_NAME); ?>
                    </label>
                    <div class="custom-icon-dropdown" id="first-menu-icon-dropdown">
                        <input type="hidden" name="first_menu_icon[<?php echo esc_html($item_id); ?>]" value="<?php echo esc_html($current_first_menu_icon ? $current_first_menu_icon : '0'); ?>">
                        <div class="icon-chooser-btn">
                            <div class="button button-primary button-large selected-icon-chooser"><?php esc_html_e('Choose Icon', THEME_NAME); ?></div>
                            <input type="text" class="icon-search" placeholder="<?php esc_html_e('Search icons...', THEME_NAME); ?>">
                        </div>
                        <div class="selected-icon">
                            <i class="isax isax-<?php echo esc_html($current_first_menu_icon); ?>"></i>
                            <span><?php echo esc_html($current_first_menu_icon); ?></span>
                        </div>
                        <ul class="icon-list">
                            <?php
                            foreach ($first_menu_icons as $item) {
                                echo '<li data-value="' . esc_html($item) . '"><i class="choose-icon isax isax-' . esc_html($item) . '"></i></li>';
                            }
                            ?>
                        </ul>
                    </div>
                </div>

                <div class="description description-wide">
                    <!-- Second Menu Icon Selector -->
                    <label for="sec_menu_icon-<?php echo esc_html($item_id); ?>">
                        <?php esc_html_e('Second Menu Icon', THEME_NAME); ?>
                    </label>
                    <div class="custom-icon-dropdown" id="sec-menu-icon-dropdown">
                        <input type="hidden" name="sec_menu_icon[<?php echo esc_html($item_id); ?>]" value="<?php echo esc_html($current_sec_menu_icon ? $current_sec_menu_icon : '0'); ?>">
                        <div class="icon-chooser-btn">
                            <div class="button button-primary button-large selected-icon-chooser"><?php esc_html_e('Choose Icon', THEME_NAME); ?></div>
                            <input type="text" class="icon-search" placeholder="<?php esc_html_e('Search icons...', THEME_NAME); ?>">
                        </div>
                        <div class="selected-icon">
                            <i class="isax isax-<?php echo esc_html($current_sec_menu_icon); ?>"></i>
                            <span><?php echo esc_html($current_sec_menu_icon); ?></span>
                        </div>
                        <ul class="icon-list">
                            <?php
                            foreach ($first_menu_icons as $item) {
                                echo '<li data-value="' . esc_html($item) . '"><i class="choose-icon isax isax-' . esc_html($item) . '"></i></li>';
                            }
                            ?>
                        </ul>
                    </div>
                </div>

                <!-- First Media Input -->
                <div class="description description-thin">
                    <label for="first_media_<?php echo esc_html( $item_id ); ?>">
                        <?php esc_html_e( 'First Media Image', THEME_NAME ); ?>
                    </label>
                    <div class="media-input" id="first-media-input">
                        <!-- Hidden text input -->
                        <input type="hidden" name="first_media[<?php echo esc_html( $item_id ); ?>]"
                            id="first_media_<?php echo esc_html( $item_id ); ?>"
                            value="<?php echo esc_url( get_post_meta( $item_id, 'first_media', true ) ); ?>" class="widefat media-url" readonly>
                        <button type="button"
                            class="button button-primary media-select-button"><?php esc_html_e( 'Select Image', THEME_NAME ); ?></button>
                        <div class="media-preview">
                            <?php
                            $image_url = get_post_meta( $item_id, 'first_media', true );
                            if ( $image_url ) {
                                echo '<img src="' . esc_url( $image_url ) . '" alt="" style="max-width: 100%; height: auto;">';
                                echo '<button type="button" class="button button-secondary media-remove-button" title="' . esc_attr__( 'Remove Image', THEME_NAME ) . '">Remove</button>';
                            }
                            ?>
                        </div>
                    </div>
                </div>

                <!-- First Hover Media Input -->
                <div class="description description-thin">
                    <label for="first_hover_media_<?php echo esc_html( $item_id ); ?>">
                        <?php esc_html_e( 'First Hover Media Image', THEME_NAME ); ?>
                    </label>
                    <div class="media-input" id="first-hover-media-input">
                        <!-- Hidden text input -->
                        <input type="hidden" name="first_hover_media[<?php echo esc_html( $item_id ); ?>]"
                            id="first_hover_media_<?php echo esc_html( $item_id ); ?>"
                            value="<?php echo esc_url( get_post_meta( $item_id, 'first_hover_media', true ) ); ?>" class="widefat media-url" readonly>
                        <button type="button"
                            class="button button-primary media-select-button"><?php esc_html_e( 'Select Image', THEME_NAME ); ?></button>
                        <div class="media-preview">
                            <?php
                            $image_url = get_post_meta( $item_id, 'first_hover_media', true );
                            if ( $image_url ) {
                                echo '<img src="' . esc_url( $image_url ) . '" alt="" style="max-width: 100%; height: auto;">';
                                echo '<button type="button" class="button button-secondary media-remove-button" title="' . esc_attr__( 'Remove Image', THEME_NAME ) . '">Remove</button>';
                            }
                            ?>
                        </div>
                    </div>
                </div>

                <!-- Second Media Input -->
                <div class="description description-thin">
                    <label for="second_media_<?php echo esc_html( $item_id ); ?>">
                        <?php esc_html_e( 'Second Media Image', THEME_NAME ); ?>
                    </label>
                    <div class="media-input" id="second-media-input">
                        <!-- Hidden text input -->
                        <input type="hidden" name="second_media[<?php echo esc_html( $item_id ); ?>]"
                            id="second_media_<?php echo esc_html( $item_id ); ?>"
                            value="<?php echo esc_url( get_post_meta( $item_id, 'second_media', true ) ); ?>" class="widefat media-url"
                            readonly>
                        <button type="button"
                            class="button button-primary media-select-button"><?php esc_html_e( 'Select Image', THEME_NAME ); ?></button>
                        <div class="media-preview">
                            <?php
                            $image_url = get_post_meta( $item_id, 'second_media', true );
                            if ( $image_url ) {
                                echo '<img src="' . esc_url( $image_url ) . '" alt="" style="max-width: 100%; height: auto;">';
                                echo '<i class = "isax isax-gallery-remove5 media-remove-button remove-icon"></i>';
                            }
                            ?>
                        </div>
                    </div>
                </div>

                <!-- Second Hover Media Input -->
                <div class="description description-thin">
                    <label for="second_hover_media_<?php echo esc_html( $item_id ); ?>">
						<?php esc_html_e( 'Second Hover Media Image', THEME_NAME ); ?>
					</label>
					<div class="media-input" id="second-hover-media-input">
						<!-- Hidden text input -->
						<input type="hidden" name="second_hover_media[<?php echo esc_html( $item_id ); ?>]"
							id="second_hover_media_<?php echo esc_html( $item_id ); ?>"
							value="<?php echo esc_url( get_post_meta( $item_id, 'second_hover_media', true ) ); ?>"
							class="widefat media-url" readonly>
						<button type="button"
							class="button button-primary media-select-button"><?php esc_html_e( 'Select Image', THEME_NAME ); ?></button>
						<div class="media-preview">
							<?php
							$image_url = get_post_meta( $item_id, 'second_hover_media', true );
							if ( $image_url ) {
								echo '<img src="' . esc_url( $image_url ) . '" alt="" style="max-width: 100%; height: auto;">';
								echo '<button type="button" class="button button-secondary media-remove-button" title="' . esc_attr__( 'Remove Image', THEME_NAME ) . '">Remove</button>';
							}
							?>
                        </div>
                    </div>
                </div>

                <!-- Dropdown Menu Icon Selector -->
                <div class="description description-wide">
                    <label for="dropdown_menu_icon_<?php echo esc_html($item_id); ?>">
                        <?php esc_html_e('Dropdown Menu Icon', THEME_NAME); ?>
                    </label>
                    <div class="custom-icon-dropdown" id="dropdown-menu-icon">
                        <input type="hidden" name="dropdown_menu_icon[<?php echo esc_html($item_id); ?>]" id="dropdown_menu_icon_<?php echo esc_html($item_id); ?>" value="<?php echo esc_html(get_post_meta($item_id, 'dropdown_menu_icon', true)); ?>">
                        <div class="icon-chooser-btn">
                            <div class="button button-primary button-large selected-icon-chooser"><?php esc_html_e('Choose Icon', THEME_NAME); ?></div>
                            <input type="text" class="icon-search" placeholder="<?php esc_html_e('Search icons...', THEME_NAME); ?>">
                        </div>
                        <div class="selected-icon">
                            <i class="isax isax-<?php echo esc_html(get_post_meta($item_id, 'dropdown_menu_icon', true)); ?>"></i>
                            <span><?php echo esc_html(get_post_meta($item_id, 'dropdown_menu_icon', true)); ?></span>
                            <i class="isax isax-gallery-remove5 remove-icon"></i>
                        </div>
                        <ul class="icon-list">
                            <?php foreach ($first_menu_icons as $item) { ?>
                                <li data-value="<?php echo esc_html($item); ?>"><i class="choose-icon isax isax-<?php echo esc_html($item); ?>"></i></li>
                            <?php } ?>
                        </ul>
                    </div>
                </div>

                <!-- Dropdown Icon Position Selector -->
                <div class="description description-thin">
                    <label for="dropdown_icon_position_<?php echo esc_html($item_id); ?>">
                        <?php esc_html_e('Dropdown Icon Position', THEME_NAME); ?>
                    </label>
                    <select name="dropdown_icon_position[<?php echo esc_html($item_id); ?>]" id="dropdown_icon_position_<?php echo esc_html($item_id); ?>" class="widefat">
                        <option value="before" <?php selected(get_post_meta($item_id, 'dropdown_icon_position', true), 'before'); ?>>
                            <?php esc_html_e('Before', THEME_NAME); ?>
                        </option>
                        <option value="after" <?php selected(get_post_meta($item_id, 'dropdown_icon_position', true), 'after'); ?>>
                            <?php esc_html_e('After', THEME_NAME); ?>
                        </option>
                    </select>
                </div>

                <!-- Dropdown Menu Direction Selector -->
                <div class="description description-thin">
                    <label for="menu_item_direction_<?php echo esc_html($item_id); ?>">
                        <?php esc_html_e('Menu item Direction', THEME_NAME); ?>
                    </label>
                    <select name="menu_item_direction[<?php echo esc_html($item_id); ?>]" id="menu_item_direction_<?php echo esc_html($item_id); ?>" class="widefat">
                        <option value="row" <?php selected(get_post_meta($item_id, 'menu_item_direction', true), 'row'); ?>>
                            <?php esc_html_e('Row', THEME_NAME); ?>
                        </option>
                        <option value="column" <?php selected(get_post_meta($item_id, 'menu_item_direction', true), 'column'); ?>>
                            <?php esc_html_e('Column', THEME_NAME); ?>
                        </option>
                    </select>
                </div>
            </div> 
        </div>
        <?php
    }

    // Update meta to admin menu item
    function update_meta_admin_menu_item ($menu_id, $menu_item_db_id) {
		$meta_fields = [ 
			'theme_mega_menu',
			'theme_mega_menu_width',
			'theme_mega_menu_margin_top',
			'theme_mega_menu_margin_right',
			'theme_mega_menu_margin_btn',
			'theme_mega_menu_margin_left',
			'advance_menu_options',
			'first_menu_icon',
            'sec_menu_icon',
            'first_media',
			'first_hover_media',
            'second_media',
            'second_hover_media',
			'dropdown_menu_icon',
            'dropdown_icon_position',
            'menu_item_direction',

		];

		foreach ( $meta_fields as $post_field ) {
			$meta_value = isset( $_POST[ $post_field ][ $menu_item_db_id ] ) ? esc_html( $_POST[ $post_field ][ $menu_item_db_id ] ) : 0;

			if ( $meta_value ) {
				update_post_meta( $menu_item_db_id, $post_field, $meta_value );
			} else {
				delete_post_meta( $menu_item_db_id, $post_field );
			}
		}


	}

    // Remove default sub-menu items from mega menu
    function remove_default_submenu ($sorted_menu_items, $args) {
        if($args->menu_class == 'theme-header-nav') {
            $new_items = array();
            $new_items[0] = 0; // $sorted_menu_items start from 0. So we changed $new_items index start from 0
            for($i=1; $i <= count($sorted_menu_items); $i++) {
                if($sorted_menu_items[$i]->menu_item_parent == 0) {
                    $new_items[] = $sorted_menu_items[$i];
                    $has_mega_menu = get_post_meta($sorted_menu_items[$i]->ID, 'theme_mega_menu', true);
                    if(intval($has_mega_menu)) {
                        while(isset($sorted_menu_items[$i+1]) && $sorted_menu_items[$i+1]-> menu_item_parent) {
                            $i++;
                        }
                    }
                }
                else {
                    $new_items[] = $sorted_menu_items[$i];
                }

            }

            unset($new_items[0]);

            return $new_items;
        }

        return $sorted_menu_items;
    }

    // Add mega Menu Content
    function add_mega_menu_content($item_output, $item, $depth, $args) {
        if($args->menu_class == 'theme-header-nav' && $depth == 0 ) {
            $mega_menu_template = intval(get_post_meta($item->ID, 'theme_mega_menu', true));
            if($mega_menu_template) { // Skip theme-mega-menu-3-col, theme-mega-menu-4-col
                $mega_menu_template_content = show_template($mega_menu_template);
                if($mega_menu_template_content) {
					$mega_menu_width = intval(get_post_meta( $item->ID, 'theme_mega_menu_width', true ));
					$margin_top = intval(get_post_meta( $item->ID, 'theme_mega_menu_margin_top', true ));
					$margin_right = intval(get_post_meta( $item->ID, 'theme_mega_menu_margin_right', true ));
					$margin_bottom = intval(get_post_meta( $item->ID, 'theme_mega_menu_margin_btn', true ));
					$margin_left = intval(get_post_meta( $item->ID, 'theme_mega_menu_margin_left', true ));
					// Build the inline styles
					$inline_styles = '';
					if ( $mega_menu_width ) {
						$inline_styles .= 'width: ' . esc_attr( $mega_menu_width ) . 'px;';
					}
					if ( $margin_top || $margin_right || $margin_bottom || $margin_left ) {
						$inline_styles .= 'margin: ' . esc_attr( $margin_top ) . 'px ' . esc_attr( $margin_right ) . 'px ' . esc_attr( $margin_bottom ) . 'px ' . esc_attr( $margin_left ) . 'px;';
					}
                    $item_output .= '<div class="sub-menu mega-menu-content" style="' . esc_attr( $inline_styles ) . '">';
                    $item_output .= $mega_menu_template_content;
                    $item_output .= '</div>';
                }
            }
        }

        return $item_output;
    }

    // Add class to li
    function add_class_mega_menu_li($classes, $item, $args, $depth) {
        if($args->menu_class == 'theme-header-nav' && $depth == 0 ) {
            $mega_menu_template = get_post_meta($item->ID, 'theme_mega_menu', true);
            if($mega_menu_template) { // theme template
                $classes[] = 'theme-mega-menu-item';
            }
        }
        return $classes;
    }

	public function add_data_to_menu_item($title, $item = null, $depth = null, $args = null) {
        $advance_menu_options = get_post_meta( $item->ID, 'advance_menu_options', true );
        if($advance_menu_options){
            $first_menu_icon = get_post_meta( $item->ID, 'first_menu_icon', true );
            $sec_menu_icon = get_post_meta( $item->ID, 'sec_menu_icon', true );
            $first_media = get_post_meta( $item->ID, 'first_media', true );
            $first_hover_media = get_post_meta( $item->ID, 'first_hover_media', true );
            $second_media = get_post_meta( $item->ID, 'second_media', true );
            $second_hover_media = get_post_meta( $item->ID, 'second_hover_media', true );
            $custom_dropdown_icon = get_post_meta( $item->ID, 'dropdown_menu_icon', true );
            $dropdown_icon_position = get_post_meta( $item->ID, 'dropdown_icon_position', true );
            $menu_item_direction = get_post_meta( $item->ID, 'menu_item_direction', true );
    
            $new_title = '<div class="d-flex align-items-center flex-' . $menu_item_direction . '">';
    
            if( $first_menu_icon){
                $new_title .= '<i class="first-menu-icon isax isax-' . $first_menu_icon . '"></i>';
            }
    
            if ( $first_media) {
                if ( $first_hover_media ) {
                    $class = 'first-media first-media-with-hover';
                }
                else{
                    $class = 'first-media first-media-without-hover';
    
                }
                $new_title .= '<img class="' . $class . '" src="' . $first_media . '"></img>';
            }
    
            if ( $first_hover_media) {
                $new_title .= '<img class="first-hover-media" src="' . $first_hover_media . '"></img>';
            }
    
            $new_title .= '<div class="title-container d-flex align-items-center">';
    
            if ( $dropdown_icon_position === 'before' ) {
                $new_title .= '<i class="dropdown-icon isax isax-' . $custom_dropdown_icon . '"></i>';
            }
    
            $new_title .= '<span>' . $title . '</span>';
    
            if ( $dropdown_icon_position === 'after' ) {
                $new_title .= '<i class="dropdown-icon isax isax-' . $custom_dropdown_icon . '"></i>';
            }
    
            $new_title .= '</div>';
    
            if ( $second_media ) {
                if ( $second_hover_media ) {
                    $class = 'second-media second-media-with-hover';
                } else {
                    $class = 'second-media second-media-without-hover';
    
                }
                $new_title .= '<img class="' . $class . '" src="' . $second_media . '"></img>';
            }
    
            if ( $second_hover_media ) {
                $new_title .= '<img class="second-hover-media" src="' . $second_hover_media . '"></img>';
            }
    
            if ( $sec_menu_icon ) {
                $new_title .= '<i class="second-menu-icon isax isax-' . $sec_menu_icon . '"></i>';
            }
    
            $new_title .= '</div>';
    
            return $new_title;
        }
        else{
			return $title;
        }
	}
}

// Call theme_Mega_menu
new theme_mega_menu();