<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

function theme_post_type() {
	if ( option_value( 'display-name-project' ) ) {
		$title = option_value( 'display-name-project' );
	} else {
		$title = __( 'project', THEME_NAME );
	}
	$data = array(
		array(
			'name' => 'project',
			'title' => $title,
			'arg' => array(
				'public' => true,
				'exclude_from_search' => false,
				'show_in_menu' => true,
				'menu_position' => 20,
				'show_in_nav_menus' => false,
				'show_in_admin_bar' => true,
				'show_ui' => true,
				'show_in_rest' => true,
				'rewrite' => false,
				'menu_icon' => 'dashicons-insert',
				'has_archive' => true,
				'capability_type' => 'post',
				'hierarchical' => true,
			),
		),
	);
	if ( option_value( 'user-post-type' ) ) {
		foreach ( option_value( 'user-post-type' ) as $index => $item ) {
			if ( $item ) {
				if ( option_value( 'display-name-' . $item ) ) {
					$title = option_value( 'display-name-' . $item );
				} else {
					$title = esc_html__( $item, THEME_NAME );
				}
				$data[] = array(
					'name' => $item,
					'title' => $title,
					'arg' => array(
						'public' => true,
						'exclude_from_search' => false,
						'show_in_menu' => true,
						'menu_position' => 20,
						'show_in_nav_menus' => false,
						'show_in_admin_bar' => true,
						'show_ui' => true,
						'show_in_rest' => true,
						'rewrite' => false,
						'menu_icon' => 'dashicons-insert',
						'has_archive' => true,
						'capability_type' => 'post',
						'hierarchical' => true,
					),
				);
			}
		}
	}
	return $data;
}

function theme_defualt_colors() {
	$defualt_colors = [ 
		'theme-primary-color' => [ 
			'name' => __( 'Primary Color', THEME_NAME ),
			'value' => '#232332',
			'id' => 'theme_1',
		],
		'theme-primary-color-alt' => [ 
			'name' => __( 'Primary Color Alt', THEME_NAME ),
			'value' => '#404050',
			'id' => 'theme_2',
		],
		'theme-secondary-color' => [ 
			'name' => __( 'Secondary Color', THEME_NAME ),
			'value' => '#F14647',
			'id' => 'theme_3',

		],
		'theme-secondary-color-alt' => [ 
			'name' => __( 'Secondary Color Alt', THEME_NAME ),
			'value' => '#F46B6C',
			'id' => 'theme_4',
		],
	];

	return $defualt_colors;
}
// theme colors
function theme_colors() {
	$defualt_colors = theme_defualt_colors();
	$theme_colors = [];
	foreach ( $defualt_colors as $color_key => $color_value ) {
		$color = [ 
			'name' => $color_value['name'],
			'id' => $color_value['id'],
			'value' => option_value( $color_key ), // You need to define the option_value function or replace it with the appropriate function
		];

		$theme_colors[ $color_key ] = $color;
	}

	return $theme_colors;
}
// Title Tags
function theme_title_tag() {
	$title_tags = [ 
		'h1' => 'H1',
		'h2' => 'H2',
		'h3' => 'H3',
		'h4' => 'H4',
		'h5' => 'H5',
		'h6' => 'H6',
		'a' => 'a',
		'div' => 'div',
		'span' => 'span',
		'p' => 'p',
		'input' => 'input',
		'button' => 'button',
	];
	return $title_tags;
}

// woocommerce fields
function woocommerce_billing_fields() {
	$fields = [ 
		'billing_first_name' => esc_html__( 'Billing First Name', THEME_NAME ),
		'billing_last_name' => esc_html__( 'Billing Last Name', THEME_NAME ),
		'billing_company' => esc_html__( 'Billing Company', THEME_NAME ),
		'billing_country' => esc_html__( 'Billing Country', THEME_NAME ),
		'billing_address_1' => esc_html__( 'Billing Address 1', THEME_NAME ),
		'billing_address_2' => esc_html__( 'Billing Address 2', THEME_NAME ),
		'billing_city' => esc_html__( 'Billing City', THEME_NAME ),
		'billing_state' => esc_html__( 'Billing State', THEME_NAME ),
		'billing_postcode' => esc_html__( 'Billing Postcode', THEME_NAME ),
		'billing_phone' => esc_html__( 'Billing Phone', THEME_NAME ),
		'billing_email' => esc_html__( 'Billing Email', THEME_NAME ),
	];
	return $fields;
}

function woocommerce_shipping_fields() {
	$fields = [ 
		'shipping_first_name' => esc_html__( 'shipping First Name', THEME_NAME ),
		'shipping_last_name' => esc_html__( 'shipping Last Name', THEME_NAME ),
		'shipping_company' => esc_html__( 'shipping Company', THEME_NAME ),
		'shipping_country' => esc_html__( 'shipping Country', THEME_NAME ),
		'shipping_address_1' => esc_html__( 'shipping Address 1', THEME_NAME ),
		'shipping_address_2' => esc_html__( 'shipping Address 2', THEME_NAME ),
		'shipping_city' => esc_html__( 'shipping City', THEME_NAME ),
		'shipping_state' => esc_html__( 'shipping State', THEME_NAME ),
		'shipping_postcode' => esc_html__( 'shipping Postcode', THEME_NAME ),
	];
	return $fields;
}

function all_woocommerce_profile_fields() {
	$fields = [ 
		'dashboard' => esc_html__( 'dashboard', THEME_NAME ),
		'orders' => esc_html__( 'orders', THEME_NAME ),
		'downloads' => esc_html__( 'downloads', THEME_NAME ),
		'edit-address' => esc_html__( 'edit address', THEME_NAME ),
		'payment-methods' => esc_html__( 'payment methods', THEME_NAME ),
		'edit-account' => esc_html__( 'edit account', THEME_NAME ),
		'customer-logout' => esc_html__( 'logout', THEME_NAME ),
	];
	if ( option_value( 'woocommerce_profile_fields-custom-feild' ) ) {

		foreach ( option_value( 'woocommerce_profile_fields-custom-feild' ) as $index => $item ) {
			$fields[] = array(
				'name' => $item,
				'slug' => $item,
			);
		}
	}
	return $fields;
}

// Get Options
function option_value( $opt1, $opt2 = NULL ) {
	global $theme_settings;
	$theme_settings = $theme_settings ?: get_option( 'theme_settings' );

	if ( $opt2 ) {
		return isset( $theme_settings[ $opt1 ][ $opt2 ] ) ? $theme_settings[ $opt1 ][ $opt2 ] : '';
	}

	return isset( $theme_settings[ $opt1 ] ) ? $theme_settings[ $opt1 ] : '';
}

// Get Elementor Content to Display
function show_template( $id ) {
	if ( class_exists( 'Elementor\Plugin' ) ) {
		$elementor = \Elementor\Plugin::instance();
		return $elementor->frontend->get_builder_content_for_display( $id );
	}

}

// Get template id of layout
function get_layout( $layout ) {
	$this_template = 0;
	$post_types = get_post_types( array( 'public' => true ), 'objects' );
	$post_kind = get_post_type();
	switch ( $layout ) {
		case 'header':
			if ( is_archive() ) {
				$this_template = intval( option_value( $post_kind . '-archive-header' ) );
				break;
			} else {
				if ( get_post_meta( get_the_ID(), $post_kind . '-header', true ) != '0' ) {
					$this_template = intval( get_post_meta( get_the_ID(), $post_kind . '-header', true ) );
				} else {
					$this_template = intval( option_value( $post_kind . '-header' ) );
				}
				break;
			}
			if ( $this_template == 0 ) {
				$this_template = intval( option_value( 'site-header' ) );
			}
			break;

		case 'sticky-header':
			if ( is_archive() ) {
				if ( option_value( $post_kind . '-sticky-header-status' ) ) {
					$this_template = intval( option_value( $post_kind . '-sticky-header-status' ) );
				}
			} else {
				if ( get_post_meta( get_the_ID(), $post_kind . '-sticky-header', true ) != '0' ) {
					$this_template = intval( get_post_meta( get_the_ID(), $post_kind . '-sticky-header', true ) );

				} else {
					$this_template = intval( option_value( $post_kind . '-sticky-header' ) );
				}
				break;
			}
			break;


		case 'sidebar':
			if ( function_exists( 'is_woocommerce' ) && is_woocommerce() ) {
				$this_template = intval( option_value( 'woocommerce-sidebar-template' ) );
				break;
			} else {
				if ( is_archive() ) {
					if ( option_value( $post_kind . '-archive-sidebar' ) ) {
						$this_template = intval( option_value( $post_kind . '-archive-sidebar' ) );
					}
				} else {
					if ( get_post_meta( get_the_ID(), $post_kind . '-sidebar-template', true ) != '0' ) {
						$this_template = intval( get_post_meta( get_the_ID(), $post_kind . '-sidebar-template', true ) );
					} else {
						$this_template = intval( option_value( $post_kind . '-sidebar' ) );

					}
					break;
				}
			}
			break;

		case 'single-top-content':
			if ( is_singular() ) {
				$this_template = intval( get_post_meta( get_the_ID(), 'post_top_content', true ) );
				if ( ! $this_template ) {
					$this_template = option_value( 'single-post-top-content-template' );
				}
			}
			break;

		case 'single-bottom-content':
			if ( is_singular() ) {
				$this_template = intval( get_post_meta( get_the_ID(), 'post_bottom_content', true ) );
				if ( ! $this_template ) {
					$this_template = option_value( 'single-post-bottom-content-template' );
				}
			}
			break;

		case '404':
			if ( is_404() ) {
				$this_template = intval( option_value( 'page-404-template' ) );
			}
			break;

		case 'archive':
			if ( is_archive() || is_home() ) {
				$this_template = intval( option_value( 'archive-' . $post_kind ) );
			}
			break;

		case 'search':
			$this_template = intval( option_value( 'search-template' ) );
			break;

		case 'single':
			$this_template = intval( get_post_meta( get_the_ID(), 'theme_single_post_layout', true ) );
			if ( $this_template == 0 ) {
				$this_template = intval( option_value( 'single-' . $post_kind ) );
			}
			break;

		case 'footer':
			if ( is_archive() ) {
				if ( option_value( $post_kind . '-archive-footer' ) ) {
					$this_template = intval( option_value( $post_kind . '-archive-footer' ) );
				}
			} else {
				if ( get_post_meta( get_the_ID(), $post_kind . '-footer', true ) != '0' ) {
					$this_template = intval( get_post_meta( get_the_ID(), $post_kind . '-footer', true ) );
				} else {
					$this_template = intval( option_value( $post_kind . '-footer' ) );
				}
			}

			if ( $this_template == 0 ) {
				$this_template = intval( option_value( 'site-footer' ) );
			}
			break;

		case 'maintenance':
			if ( option_value( 'enable-maitanance-mode' ) ) {
				$this_template = intval( option_value( 'page-maitanance-template' ) );
			}
			break;
	}

	return intval( $this_template );
}

// Get theme Templates headers
if ( ! function_exists( 'get_all_header_template' ) ) {
	function get_all_header_template() {
		$templates_list = array( '0' => esc_html__( 'Default', THEME_NAME ) );

		$args = array(
			'numberposts' => -1,
			'post_type' => 'theme-header',
			'post_status' => 'publish'
		);
		$templates_posts = get_posts( $args );

		$templates_list += wp_list_pluck( $templates_posts, 'post_title', 'ID' );

		return $templates_list;
	}
}

// Get theme Templates footer
if ( ! function_exists( 'get_all_footer_template' ) ) {
	function get_all_footer_template() {
		$templates_list = array( '0' => esc_html__( 'Default', THEME_NAME ) );

		$args = array(
			'numberposts' => -1,
			'post_type' => 'theme-footer',
			'post_status' => 'publish'
		);
		$templates_posts = get_posts( $args );

		$templates_list += wp_list_pluck( $templates_posts, 'post_title', 'ID' );

		return $templates_list;
	}
}

// Get theme Templates side bar
if ( ! function_exists( 'get_all_side_bar_template' ) ) {
	function get_all_side_bar_template() {
		$templates_list = array( '0' => esc_html__( 'Default', THEME_NAME ) );

		$args = array(
			'numberposts' => -1,
			'post_type' => 'theme-side-bar',
			'post_status' => 'publish'
		);
		$templates_posts = get_posts( $args );

		$templates_list += wp_list_pluck( $templates_posts, 'post_title', 'ID' );

		return $templates_list;
	}
}

// Get theme Templates blogs
if ( ! function_exists( 'get_all_blog_template' ) ) {
	function get_all_blog_template() {
		$templates_list = array( '0' => esc_html__( 'Default', THEME_NAME ) );

		$args = array(
			'numberposts' => -1,
			'post_type' => 'theme-blog',
			'post_status' => 'publish'
		);
		$templates_posts = get_posts( $args );

		$templates_list += wp_list_pluck( $templates_posts, 'post_title', 'ID' );

		return $templates_list;
	}
}

// Get theme Templates other
if ( ! function_exists( 'get_all_other_template' ) ) {
	function get_all_other_template() {
		$templates_list = array( '0' => esc_html__( 'Default', THEME_NAME ) );

		$args = array(
			'numberposts' => -1,
			'post_type' => 'theme-other',
			'post_status' => 'publish'
		);
		$templates_posts = get_posts( $args );

		$templates_list += wp_list_pluck( $templates_posts, 'post_title', 'ID' );

		return $templates_list;
	}
}

// Get product
if ( ! function_exists( 'get_all_product' ) ) {
	function get_all_product() {
		$templates_list = array( '0' => esc_html__( 'Default', THEME_NAME ) );

		$args = array(
			'numberposts' => -1,
			'post_type' => 'product',
			'post_status' => 'publish'
		);
		$templates_posts = get_posts( $args );

		$templates_list += wp_list_pluck( $templates_posts, 'post_title', 'ID' );

		return $templates_list;
	}
}

function get_custom_fonts_options() {
	$custom_fonts_dir = WP_CONTENT_DIR . '/uploads/redux/custom-fonts/custom/';
	$font_dirs = glob( $custom_fonts_dir . '*', GLOB_ONLYDIR );
	$options = array();

	foreach ( $font_dirs as $font_dir ) {
		$font_name = basename( $font_dir );
		$font_files = glob( $font_dir . '/*.{ttf,otf,woff,woff2}', GLOB_BRACE );

		foreach ( $font_files as $font_file ) {
			$font_base = pathinfo( $font_file, PATHINFO_FILENAME );
			$options[ $font_name . '|' . $font_base ] = $font_base;
		}
	}

	return $options;
}

// Get pages
if ( ! function_exists( 'get_all_pages' ) ) {
	function get_all_pages() {
		$templates_list = array( '0' => esc_html__( 'Default', THEME_NAME ) );

		$args = array(
			'numberposts' => -1,
			'post_type' => 'page',
			'post_status' => 'publish'
		);
		$templates_posts = get_posts( $args );

		$templates_list += wp_list_pluck( $templates_posts, 'post_title', 'ID' );

		return $templates_list;
	}
}

function count_words( $text ) {
	// Remove non-alphanumeric characters except spaces
	$clean_text = preg_replace( '/[^\p{L}\p{N}\s]/u', '', $text );

	// Split the text into words
	$words = preg_split( '/\s+/', $clean_text, -1, PREG_SPLIT_NO_EMPTY );

	// Count the words
	$word_count = count( $words );

	return $word_count;
}

// Calculate Post Reading Time
function calc_read_time( $post = null ) {
	$post = get_post( $post );

	if ( ! $post ) {
		return false;
	}

	$content = get_post_field( 'post_content', $post );
	$word_count = count_words( strip_tags( $content ) );
	$words_per_minute = absint( option_value( 'reading-time-words-per-minute' ) ) ?: 250;

	$number_of_images = substr_count( strtolower( $content ), '<img ' );
	$word_count += $number_of_images * 30;

	$reading_time = ceil( $word_count / $words_per_minute );

	return $reading_time;
}

// HexColor
function convert_hex( $string, $steps = -10 ) {
	// Generate the hex output using the first 6 characters of the MD5 hash
	$hex_output = substr( md5( $string ), 0, 6 );

	// Ensure steps are within the range of -255 to 255
	$steps = max( -255, min( 255, $steps ) );

	// Split the hex color into three parts: R, G, and B
	$color_parts = str_split( $hex_output, 2 );

	// Apply the steps to each color component
	foreach ( $color_parts as &$color ) {
		$color = max( 0, min( 255, hexdec( $color ) + $steps ) );
		$color = str_pad( dechex( $color ), 2, '0', STR_PAD_LEFT ); // Ensure two-digit hex representation
	}

	// Format the output as a hexadecimal color code
	$output = '#' . implode( '', $color_parts );

	// Convert the output to uppercase
	return strtoupper( $output );
}

// Set post views
add_action( 'wp_head', 'set_post_views' );
function set_post_views() {
	if ( is_single() && get_the_ID() ) {
		$count_key = 'post_views';
		$count = intval( get_post_meta( get_the_ID(), $count_key, true ) );
		$count++;
		update_post_meta( get_the_ID(), $count_key, $count );
	}
}

// Get post views
function get_post_view( $post_ID ) {
	$count_key = 'post_views';
	$count = intval( get_post_meta( $post_ID, $count_key, true ) );
	if ( $count > 999 ) {
		$count = substr( $count, 0, -2 ) / 10 . 'K';
	}
	return $count;
}

function convert_date( $date, $format ) {
	$current_locale = get_locale();

	if ( $current_locale === 'fa_IR' ) {
		if ( option_value( 'jdatetime' ) ) {
			require_once THEME_DIR . '/inc/jdatatime.php';
			$date_format = ! empty( $format ) ? $format : 'F j, Y';

			$jdatetime = new JDateTime( true, true, 'Asia/Tehran' );
			$formatted_date = $jdatetime->date( $date_format, strtotime( $date ) ); // Format the provided date
		} else {
			// Use current_time() if jdatetime is not enabled
			$formatted_date = current_time( $format, strtotime( $date ) ); // Format the provided date
		}
	} else {
		// Use current_time() for non-fa_IR locale
		$formatted_date = current_time( $format, strtotime( $date ) ); // Format the provided date
	}

	return $formatted_date;
}

function log_to_console( $variable ) {
	// Convert the variable to a JSON string
	$json_output = json_encode( $variable, JSON_HEX_TAG | JSON_HEX_AMP | JSON_HEX_APOS | JSON_HEX_QUOT );

	// Ensure the JSON output is safely encoded for inclusion in HTML
	$json_output = addslashes( $json_output );

	// Print the JavaScript code to log the output to the console
	echo "<script>console.log('debug ' + JSON.stringify(JSON.parse('$json_output'), null, 2));</script>";
}