<?php

use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_thanks extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_woo_thanks';
    }

    public function get_title() {
        return esc_html__('thanks page', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_thanks';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }
    
    protected function register_style_section_1() {
        $this->start_controls_section(
            'order_detail_body',
		    [
			    'label' => esc_html__('order detail body', THEME_NAME),
			    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
		    ]
	    );

		$this->add_control(
			'title',
			[ 
				'label' => esc_html__( 'title', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->register_text_style( 'woocommerce-thankyou-order-received', '.woocommerce-thankyou-order-received' );

        $this->register_container_style('order-body', '.woocommerce-order');

		$this->add_control(
			'order_detail_body_sep_0',
			[ 
				'label' => esc_html__( 'order body', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_container_style('order-detail-body', '.woocommerce-order-overview.woocommerce-thankyou-order-details.order_details');

        $this->add_control(
            'order_detail_body_sep_1',
            [
                'label' => esc_html__( 'order number', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        ); 
        $this->register_text_style('order_detail_body_order', '.woocommerce-order-overview__order.order');

		$this->add_control(
			'order_detail_body_sep_1-1',
			[ 
				'label' => esc_html__( 'order number number', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->register_text_style( 'order_detail_body_order_number', '.woocommerce-order-overview__order.order strong' );

        $this->add_control(
            'order_detail_body_sep_2',
            [
                'label' => esc_html__( 'order date', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        ); 
        $this->register_text_style('order_detail_body_date', '.woocommerce-order-overview__date.date');

		$this->add_control(
			'order_detail_body_sep_2-1',
			[ 
				'label' => esc_html__( 'order date number', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->register_text_style( 'order_detail_body_date_number', '.woocommerce-order-overview__date.date strong' );

        $this->add_control(
            'order_detail_body_sep_3',
            [
                'label' => esc_html__( 'order email', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        ); 
        $this->register_text_style('order_detail_body_email', '.woocommerce-order-overview__email.email');

		$this->add_control(
			'order_detail_body_sep_3_1',
			[ 
				'label' => esc_html__( 'order email number', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->register_text_style( 'order_detail_body_email_number', '.woocommerce-order-overview__email.email strong' );

        $this->add_control(
            'order_detail_body_sep_4',
            [
                'label' => esc_html__( 'order total', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        ); 
        $this->register_text_style('order_detail_body_total', '.woocommerce-order-overview__total.total');

		$this->add_control(
			'order_detail_body_sep_4-1',
			[ 
				'label' => esc_html__( 'order total number', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->register_text_style( 'order_detail_body_total_number', '.woocommerce-order-overview__total.total strong' );

        $this->add_control(
            'order_detail_body_sep_5',
            [
                'label' => esc_html__( 'order method', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        ); 
        $this->register_text_style('order_detail_body_mothod', '.woocommerce-order-overview__payment-method.method');

		$this->add_control(
			'order_detail_body_sep_5_1',
			[ 
				'label' => esc_html__( 'order method method', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->register_text_style( 'order_detail_body_mothod_method', '.woocommerce-order-overview__payment-method.method strong' );

        $this->add_control(
            'order_detail_body_sep_6',
            [
                'label' => esc_html__( 'order total', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->register_container_style('order-detail-body-table', '.order-details');

		$this->add_control(
			'order_detail_body_sep_6_title',
			[ 
				'label' => esc_html__( 'order pay method', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->register_text_style( 'order_detail_body_mothod_method_title', '.pay-title p' );

		$this->add_control(
			'order_detail_body_sep_6_table',
			[ 
				'label' => esc_html__( 'order total table', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_table_style('order_table', '.shop_table.order_details');

        $this->add_control(
            'order_detail_body_sep_8',
            [
                'label' => esc_html__( 'order billing', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->register_container_style('woocommerce_customer_details_billing', '.customer-details .billing');

		$this->add_control(
			'order_detail_body_sep_8-0',
			[ 
				'label' => esc_html__( 'order billing title', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'woocommerce_customer_details_billing-title', '.customer-details .billing .address-title' );

		$this->add_control(
			'order_detail_body_sep_8_1',
			[ 
				'label' => esc_html__( 'order billing icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_text_style('woocommerce_customer_details_billing_icon', '.customer-details .billing i');

		$this->add_control(
			'order_detail_body_sep_8_2',
			[ 
				'label' => esc_html__( 'order billing text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'woocommerce_customer_details_billing_text', '.customer-details .billing .address' );


		$this->add_control(
			'order_detail_body_sep_9',
			[ 
				'label' => esc_html__( 'order shipping', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_container_style( 'woocommerce_customer_details_shipping', '.customer-details .shipping ' );

		$this->add_control(
			'order_detail_body_sep_9-0',
			[ 
				'label' => esc_html__( 'order shipping title', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'woocommerce_customer_details_shipping-title', '.customer-details .shipping .address-title' );

		$this->add_control(
			'order_detail_body_sep_9_1',
			[ 
				'label' => esc_html__( 'order shipping icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'woocommerce_customer_details_shipping_icon', '.customer-details .shipping i' );

		$this->add_control(
			'order_detail_body_sep_9_2',
			[ 
				'label' => esc_html__( 'order shipping text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'woocommerce_customer_details_shipping_text', '.customer-details .shipping .address' );

        $this->end_controls_section();
    } 

    protected function register_controls() {

        $this->register_style_section_1();

    }

    protected function render(){
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
        if ( $this->theme_is_edit_mode()) {
            ?>
            <div class="woocommerce-order">
                <p class="woocommerce-notice woocommerce-notice--success woocommerce-thankyou-order-received">
                    متشکریم، سفارش شما دریافت شد.
                </p>

                <div class="woocommerce-order-overview woocommerce-thankyou-order-details order_details">
                    <div class="woocommerce-order-overview__order order">
                        شماره سفارش: <br />
                        <strong>4224</strong>
                    </div>

                    <div class="woocommerce-order-overview__date date">
                        تاریخ: <br />
                        <strong>2024-04-26</strong>
                    </div>

                    <div class="woocommerce-order-overview__email email">
                        ایمیل: <br />
                        <strong>test@gmail.com</strong>
                    </div>

                    <div class="woocommerce-order-overview__total total">
                        قیمت نهایی: <br />
                        <strong>
                            <span class="woocommerce-Price-amount amount">
                                <bdi>1،250،000&nbsp;<span class="woocommerce-Price-currencySymbol">تومان</span></bdi>
                            </span>
                        </strong>
                    </div>

                    <div class="woocommerce-order-overview__payment-method method">
                        روش پرداخت: <br />
                        <strong>پرداخت هنگام دریافت</strong>
                    </div>
                </div>

                <div class="order-details">
                    <div class="pay-title">
                        <p>پرداخت نقدی پس از تحویل</p>
                    </div>
                    <section class="woocommerce-order-details">
                        <h2 class="woocommerce-order-details__title">مشخصات سفارش</h2>

                        <table class="woocommerce-table woocommerce-table--order-details shop_table order_details">
                            <thead>
                                <tr>
                                    <th class="woocommerce-table__product-name product-name">محصول</th>
                                    <th class="woocommerce-table__product-table product-total">مجموع</th>
                                </tr>
                            </thead>

                            <tbody>
                                <tr class="woocommerce-table__line-item order_item">
                                    <td class="woocommerce-table__product-name product-name"><a href="../product/%d8%a8%d8%b1%d9%86%d8%af-%d8%b3%d8%a7%d8%b2%db%8c/">برند سازی</a> <strong class="product-quantity">×&nbsp;1</strong></td>

                                    <td class="woocommerce-table__product-total product-total">
                                        <span class="woocommerce-Price-amount amount">
                                            <bdi>1،200،000&nbsp;<span class="woocommerce-Price-currencySymbol">تومان</span></bdi>
                                        </span>
                                    </td>
                                </tr>
                            </tbody>

                            <tfoot>
                                <tr>
                                    <th scope="row">جمع جزء:</th>
                                    <td>
                                        <span class="woocommerce-Price-amount amount">1،200،000&nbsp;<span class="woocommerce-Price-currencySymbol">تومان</span></span>
                                    </td>
                                </tr>
                                <tr>
                                    <th scope="row">حمل و نقل:</th>
                                    <td>
                                        <span class="woocommerce-Price-amount amount">50،000&nbsp;<span class="woocommerce-Price-currencySymbol">تومان</span></span>&nbsp;<small class="shipped_via">توسط نرخ ثابت</small>
                                    </td>
                                </tr>
                                <tr>
                                    <th scope="row">روش پرداخت:</th>
                                    <td>پرداخت هنگام دریافت</td>
                                </tr>
                                <tr>
                                    <th scope="row">قیمت نهایی:</th>
                                    <td>
                                        <span class="woocommerce-Price-amount amount">1،250،000&nbsp;<span class="woocommerce-Price-currencySymbol">تومان</span></span>
                                    </td>
                                </tr>
                            </tfoot>
                        </table>
                    </section>
                </div>
                <div class="customer-details">
                    <div class="customer-details">
                        <div class="billing d-flex align-items-center flex-wrap">
                            <div class="w-100">
                                <p class="address-title">
                                    ادرس صورت حساب:
                                </p>
                            </div>
                            <div class="d-flex">
                                <i aria-hidden="true" class="isax isax-location4"></i>
                                <p class="address">
                                    اصفهان میدان انقلاب پاساژ مرکز شهر
                                </p>
                            </div>
                        </div>
                        <div class="shipping d-flex align-items-center flex-wrap">
                            <div class="w-100">
                                <p class="address-title">
                                    ادرس حمل و نقل:
                                </p>
                            </div>
                            <div class="d-flex">
                                <i aria-hidden="true" class="isax isax-location4"></i>
                                <p class="address">
                                    اصفهان میدان انقلاب پاساژ مرکز شهر
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php
        }
        else{
            if ( isset( $_GET['key'] ) ) {
                $order_id = wc_get_order_id_by_order_key( $_GET['key'] );
                $order = wc_get_order( $order_id );
				?>
				<div class="woocommerce-order">

					<?php
					if ( $order ) :

						do_action( 'woocommerce_before_thankyou', $order->get_id() );
						?>

							<?php if ( $order->has_status( 'failed' ) ) : ?>

									<p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed"><?php esc_html_e( 'Unfortunately your order cannot be processed as the originating bank/merchant has declined your transaction. Please attempt your purchase again.', 'woocommerce' ); ?></p>

									<p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed-actions">
										<a href="<?php echo esc_url( $order->get_checkout_payment_url() ); ?>" class="button pay"><?php esc_html_e( 'Pay', 'woocommerce' ); ?></a>
										<?php if ( is_user_logged_in() ) : ?>
												<a href="<?php echo esc_url( wc_get_page_permalink( 'myaccount' ) ); ?>" class="button pay"><?php esc_html_e( 'My account', 'woocommerce' ); ?></a>
										<?php endif; ?>
									</p>

							<?php else : ?>

									<?php wc_get_template( 'checkout/order-received.php', array( 'order' => $order ) ); ?>

									<div class="woocommerce-order-overview woocommerce-thankyou-order-details order_details">

										<div class="woocommerce-order-overview__order order">
											<?php esc_html_e( 'Order number:', 'woocommerce' ); ?>
											<br><strong><?php echo $order->get_order_number(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></strong>
										</div>

										<div class="woocommerce-order-overview__date date">
											<?php esc_html_e( 'Date:', 'woocommerce' ); ?>
											<br><strong><?php echo wc_format_datetime( $order->get_date_created() ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></strong>
										</div>

										<?php if ( is_user_logged_in() && $order->get_user_id() === get_current_user_id() && $order->get_billing_email() ) : ?>
												<div class="woocommerce-order-overview__email email">
													<?php esc_html_e( 'Email:', 'woocommerce' ); ?>
													<br><strong><?php echo $order->get_billing_email(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></strong>
												</div>
										<?php endif; ?>

										<div class="woocommerce-order-overview__total total">
											<?php esc_html_e( 'Total:', 'woocommerce' ); ?>
											<br><strong><?php echo $order->get_formatted_order_total(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></strong>
										</div>

										<?php if ( $order->get_payment_method_title() ) : ?>
												<div class="woocommerce-order-overview__payment-method method">
													<?php esc_html_e( 'Payment method:', 'woocommerce' ); ?>
													<br><strong><?php echo wp_kses_post( $order->get_payment_method_title() ); ?></strong>
												</div>
										<?php endif; ?>

									</div>

							<?php endif; ?>
							<div class="order-details">
                                <div class="pay-title"><?php do_action( 'woocommerce_thankyou_' . $order->get_payment_method(), $order->get_id() );?></div>
							    <?php                             
                                    $order_items           = $order->get_items( apply_filters( 'woocommerce_purchase_order_item_types', 'line_item' ) );
                                    $show_purchase_note    = $order->has_status( apply_filters( 'woocommerce_purchase_note_order_statuses', array( 'completed', 'processing' ) ) );
                                    $show_customer_details = is_user_logged_in() && $order->get_user_id() === get_current_user_id();
                                    ?>
                                    <section class="woocommerce-order-details">
                                        <?php do_action( 'woocommerce_order_details_before_order_table', $order ); ?>

                                        <h2 class="woocommerce-order-details__title"><?php esc_html_e( 'Order details', 'woocommerce' ); ?></h2>

                                        <table class="woocommerce-table woocommerce-table--order-details shop_table order_details">

                                            <thead>
                                                <tr>
                                                    <th class="woocommerce-table__product-name product-name"><?php esc_html_e( 'Product', 'woocommerce' ); ?></th>
                                                    <th class="woocommerce-table__product-table product-total"><?php esc_html_e( 'Total', 'woocommerce' ); ?></th>
                                                </tr>
                                            </thead>

                                            <tbody>
                                                <?php
                                                do_action( 'woocommerce_order_details_before_order_table_items', $order );

                                                foreach ( $order_items as $item_id => $item ) {
                                                    $product = $item->get_product();

                                                    wc_get_template(
                                                        'order/order-details-item.php',
                                                        array(
                                                            'order'              => $order,
                                                            'item_id'            => $item_id,
                                                            'item'               => $item,
                                                            'show_purchase_note' => $show_purchase_note,
                                                            'purchase_note'      => $product ? $product->get_purchase_note() : '',
                                                            'product'            => $product,
                                                        )
                                                    );
                                                }

                                                do_action( 'woocommerce_order_details_after_order_table_items', $order );
                                                ?>
                                            </tbody>

                                            <tfoot>
                                                <?php
                                                foreach ( $order->get_order_item_totals() as $key => $total ) {
                                                    ?>
                                                        <tr>
                                                            <th scope="row"><?php echo esc_html( $total['label'] ); ?></th>
                                                            <td><?php echo wp_kses_post( $total['value'] ); ?></td>
                                                        </tr>
                                                        <?php
                                                }
                                                ?>
                                                <?php if ( $order->get_customer_note() ) : ?>
                                                    <tr>
                                                        <th><?php esc_html_e( 'Note:', 'woocommerce' ); ?></th>
                                                        <td><?php echo wp_kses_post( nl2br( wptexturize( $order->get_customer_note() ) ) ); ?></td>
                                                    </tr>
                                                <?php endif; ?>
                                            </tfoot>
                                        </table>

                                        <?php do_action( 'woocommerce_order_details_after_order_table', $order ); ?>
                                    </section>

                                    <?php
                                    /**
                                    * Action hook fired after the order details.
                                    *
                                    * @since 4.4.0
                                    * @param WC_Order $order Order data.
                                    */
                                    do_action( 'woocommerce_after_order_details', $order );

                                    ?>
                                </div>
                                <div class="customer-details">
                                    <div class="billing d-flex align-items-center flex-wrap">
                                        <div class="w-100">
                                            <p class="address-title">
                                                <?php
                                                    echo __( 'billing address:', THEME_NAME );
                                                ?>
                                            </p>
                                        </div>
                                        <div class="d-flex">
                                            <i aria-hidden="true" class="isax isax-location4"></i>
                                            <p class="address">
                                                <?php
                                                    echo $order->get_data()['billing']['address_1'];
                                                ?>
                                            </p>
                                        </div>

                                    </div>
                                    <div class="shipping d-flex align-items-center flex-wrap">
                                        <div class="w-100">
                                            <p class="address-title">
                                                <?php
                                                    echo __( 'shipping address:', THEME_NAME );
                                                ?>
                                            </p>
                                        </div>
                                        <div class="d-flex">
                                            <i aria-hidden="true" class="isax isax-location4"></i>
                                            <p class="address">
                                                <?php
                                                    echo $order->get_data()['shipping']['address_1'];
                                                ?>
                                            </p>
                                        </div>
                                    </div>
                                </div>
							</div>
					<?php else : ?>

							<?php wc_get_template( 'checkout/order-received.php', array( 'order' => false ) ); ?>

					<?php endif; ?>

				</div>
				<?php
            }
        }
	}
}