<?php

use handler\product_Query;
use handler\Post_skin_base;
use handler\swiper;
use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

class ar_woo_testimonials extends \Elementor\Widget_Base {

    use product_Query;
    use Post_skin_base;
    use swiper;
    use basic_element;

    public function get_name() {
        return 'ar_woo_testimonials';
    }

    public function get_title() {
        return esc_html__('user testimonials', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_testimonials';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_content_section_1() {

        $this->start_controls_section(
            'section_body',
            [
                'label' => esc_html__( 'body', THEME_NAME ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

		$repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'image',
            [
                'label' => esc_html__( 'Image', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );

		$repeater->add_control(
			'name',
			[ 
				'label' => __( 'name', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);

		$repeater->add_control(
			'desc',
			[ 
				'label' => __( 'desc', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);

        $repeater->add_control(
			'star',
			[ 
				'label' => __( 'star', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);

		$repeater->add_control(
			'star-icon',
			[ 
				'label' => __( 'star icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::ICONS,
			]
		);


		$repeater->add_control(
			'body',
			[ 
				'label' => __( 'body', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
			]
		);

		$this->add_control(
			'items',
			[ 
				'label' => esc_html__( 'testimonials', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ name }}}',
			]
		);
        $this->end_controls_section();

    }

	protected function register_content_section_2() {

		$this->start_controls_section(
			'section_layout',
			[ 
				'label' => esc_html__( 'Layout', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout',
			[ 
				'label' => esc_html__( 'Layout', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [ 
					'grid' => esc_html__( 'Grid', THEME_NAME ),
					'carousel' => esc_html__( 'Carousel', THEME_NAME ),
				],
				'default' => 'grid',
			]
		);

		$this->add_responsive_control(
			'columns',
			[ 
				'label' => esc_html__( 'Columns', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '3',
				'tablet_default' => '2',
				'mobile_default' => '1',
				'options' => [ 
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'6' => '6',
				],
				'render_type' => 'template',
				'selectors' => [ 
					'{{WRAPPER}} .theme-posts-wrapper.layout-grid' => 'grid-template-columns: repeat({{SIZE}}, 1fr);',
					'{{WRAPPER}} .theme-posts-wrapper.layout-masonry .post-item' => 'width: calc(100% / {{SIZE}});',
					'{{WRAPPER}} .theme-posts-wrapper.layout-carousel .post-item' => 'width: calc(100% / {{SIZE}});',
				],
			]
		);

		$this->add_responsive_control(
			'column_gap',
			[ 
				'label' => esc_html__( 'Column Gap', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'default' => [ 
					'size' => '20',
				],
				'range' => [ 
					'px' => [ 
						'min' => 0,
						'max' => 100,
					],
				],
				'render_type' => 'template',
				'selectors' => [ 
					'{{WRAPPER}} .theme-posts-wrapper.layout-grid' => 'column-gap: {{SIZE}}{{UNIT}};',
					'body:not(.rtl) {{WRAPPER}} .theme-posts-wrapper.layout-carousel .post-item' => 'margin-right: {{SIZE}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .theme-posts-wrapper.layout-carousel .post-item' => 'margin-left: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .theme-posts-wrapper.layout-masonry' => 'margin-left: calc({{SIZE}}{{UNIT}} * -.5); margin-right: calc({{SIZE}}{{UNIT}} * -.5);',
					'{{WRAPPER}} .theme-posts-wrapper.layout-masonry .post-item' => 'padding-left: calc({{SIZE}}{{UNIT}} * .5); padding-right: calc({{SIZE}}{{UNIT}} * .5);',
				],
			]
		);

		$this->add_responsive_control(
			'row_gap',
			[ 
				'label' => esc_html__( 'Row Gap', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'default' => [ 
					'size' => '20',
				],
				'range' => [ 
					'px' => [ 
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [ 
					'{{WRAPPER}} .theme-posts-wrapper.layout-grid' => 'row-gap: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .theme-posts-wrapper.layout-masonry .post-item' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
				'condition' => [ 
					'layout!' => 'carousel',
				],
			]
		);

		$this->end_controls_section();

	}

    protected function register_style_section_1() {

        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('style', THEME_NAME),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control(
			'container',
			[ 
				'label' => esc_html__( 'container', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_container_style( 'container', '.row-one' );

		$this->add_control(
			'avatar',
			[ 
				'label' => esc_html__( 'avatar', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_image_style( 'img', 'img' );

		$this->add_control(
			'name',
			[ 
				'label' => esc_html__( 'name', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'title', '.title', $align=false );

		$this->add_control(
			'desc',
			[ 
				'label' => esc_html__( 'desc', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'desc', '.description', $align = false );

		$this->add_control(
			'icon',
			[ 
				'label' => esc_html__( 'icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'icon', 'i', $align = false );

		$this->add_control(
			'star',
			[ 
				'label' => esc_html__( 'star', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'star', '.star', $align = false );

        $this->end_controls_section();

    }

	protected function register_style_section_2() {

		$this->start_controls_section(
			'section_body_style',
			[ 
				'label' => esc_html__( 'body', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'testimonial-body',
			[ 
				'label' => esc_html__( 'container', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_container_style( 'testimonial-body', '.testimonial-body div' );

		$this->add_control(
			'body',
			[ 
				'label' => esc_html__( 'text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'body', 'p.body' );

		$this->add_control(
			'underline',
			[ 
				'label' => esc_html__( 'underline', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_container_style( 'underline', '.testimonial-body::after' );

		$this->end_controls_section();

	}


    protected function register_controls() {

        $this->register_content_section_1();
		$this->register_content_section_2();

        $this->register_carousel_controls();

        $this->register_style_section_1();
		$this->register_style_section_2();

        $this->register_style_carousel_controls();

    }
    
    protected function render(){
        if ( !class_exists( 'woocommerce' ) ) {
			return false;
		}
        $settings = $this->get_settings_for_display();
		$widget_id = $this->get_id();
		$element_id = $settings['_element_id'];
        ?>
        <div class="theme-posts-container theme-post-widget">
            <?php
            $post_wrapper_cls = '';
                if( $settings['layout'] == 'grid' ) {
                    $post_wrapper_cls = 'theme-posts-wrapper';
                }
            ?>
            <div class="<?php echo $post_wrapper_cls ?> layout-<?php echo $settings['layout'] ?>" >
                <?php $this->render_carousel_header(); ?>
                <?php
                foreach ($settings['items'] as $item) :

                    $post_item_cls = 'post-item';
                    if( $settings['layout'] == 'carousel' ) {
                        $post_item_cls = ' swiper-slide';
                    }

                    ?>

					<style>
						.testimonial-container-hover{
							transition: all 0.5s ease-in-out;
						}
						.testimonial-container-hover:hover{
							width:306px !important;
						}
					</style>
                    <div class="testimonial-container-hover <?php echo esc_html($post_item_cls); ?>">
                        <div class="row row-one align-items-center testimonial-container">
                            <div class="col-12 d-flex flex-column justify-content-center align-items-center">
								<div class="img-container">
									<img src="<?php echo esc_url( $item['image']['url'] ); ?>">
								</div>
								<div class="name-containe">
									<p class="title">
										<?php echo esc_html( $item['name'] ); ?>
									</p>
									<p class="description">
										<?php echo esc_html( $item['desc'] ); ?>
									</p>
								</div>
								<div class="icon d-flex align-items-center justify-content-center">
									<p class="star">
										<?php echo esc_html( $item['star'] ); ?>
									</p>
									<?php \Elementor\Icons_Manager::render_icon( $item['star-icon'], [ 'aria-hidden' => 'true' ] ); ?>
								</div>
                            </div>
                            <div class="col-12 testimonial-body d-flex flex-column justify-content-center align-content-center m-auto">
								<div>
									<svg width="23" height="23" viewBox="0 0 23 23" fill="none" xmlns="http://www.w3.org/2000/svg">
										<path d="M15.2471 11.8551H19.7417C19.665 16.3305 18.7834 17.0685 16.033 18.6976C15.7167 18.8893 15.6113 19.2918 15.803 19.6176C15.9946 19.9339 16.3971 20.0393 16.723 19.8476C19.9621 17.931 21.093 16.7618 21.093 11.1843V6.01887C21.093 4.38012 19.7609 3.05762 18.1317 3.05762H15.2567C13.57 3.05762 12.2955 4.3322 12.2955 6.01887V8.89387C12.2859 10.5805 13.5605 11.8551 15.2471 11.8551Z" fill="#FF4748"/>
										<path d="M4.87788 11.8551H9.37246C9.29579 16.3305 8.41413 17.0685 5.66371 18.6976C5.34746 18.8893 5.24204 19.2918 5.43371 19.6176C5.62538 19.9339 6.02788 20.0393 6.35371 19.8476C9.59288 17.931 10.7237 16.7618 10.7237 11.1843V6.01887C10.7237 4.38012 9.39163 3.05762 7.76246 3.05762H4.88746C3.19121 3.05762 1.91663 4.3322 1.91663 6.01887V8.89387C1.91663 10.5805 3.19121 11.8551 4.87788 11.8551Z" fill="#FFB5B6"/>
									</svg>
	
									<p class="body">
										<?php echo esc_html( $item['body'] ); ?>
									</p>
									<svg width="23" height="23" viewBox="0 0 23 23" fill="none" style="float:left;" xmlns="http://www.w3.org/2000/svg">
										<path d="M7.75293 11.1449H3.25835C3.33501 6.66947 4.21668 5.93155 6.9671 4.30238C7.28335 4.11072 7.38876 3.70822 7.1971 3.38238C7.00543 3.06613 6.60293 2.96072 6.2771 3.15238C3.03793 5.06905 1.9071 6.23822 1.9071 11.8157V16.9811C1.9071 18.6199 3.23918 19.9424 4.86835 19.9424H7.74335C9.43001 19.9424 10.7046 18.6678 10.7046 16.9811V14.1061C10.7142 12.4195 9.4396 11.1449 7.75293 11.1449Z" fill="#FF4748"/>
										<path d="M18.1221 11.1449H13.6275C13.7042 6.66947 14.5859 5.93155 17.3363 4.30238C17.6525 4.11072 17.758 3.70822 17.5663 3.38238C17.3746 3.06613 16.9721 2.96072 16.6463 3.15238C13.4071 5.06905 12.2763 6.23822 12.2763 11.8157V16.9811C12.2763 18.6199 13.6084 19.9424 15.2375 19.9424H18.1125C19.8088 19.9424 21.0834 18.6678 21.0834 16.9811V14.1061C21.0834 12.4195 19.8088 11.1449 18.1221 11.1449Z" fill="#FFB5B6"/>
									</svg>
								</div>
                            </div>
                        </div>
                    </div>
                <?php
				endforeach; ?>
                <?php $this->render_carousel_footer(); ?>
            </div>
        </div>
		<script>
			jQuery( document ).ready( function ( $ )
			{
				var carouselPosts = $( '#theme-carousel-<?php echo $this->get_id() ?>' );

				// Get all elements with the class '.theme-posts-carousel-wrapper'
				var carouselSettings = $( carouselPosts ).data( 'settings' );

				// Find the swiper container within the current carousel
				var carouselContainer = $( carouselPosts ).find( '.swiper-container' )[ 0 ];

				// Initialize Swiper for the current carousel
				var swiper<?php echo $element_id;
				echo $widget_id; ?> = new Swiper( carouselContainer, carouselSettings );
				$( '.swiper-prev-btn<?php echo $element_id ?>' ).on( 'click', function ()
				{
					if ( swiper<?php echo $element_id;
					echo $widget_id; ?>.activeIndex > 0 )
					{
						swiper<?php echo $element_id;
						echo $widget_id; ?>.slidePrev();
					}
				} );

				$( '.swiper-next-btn<?php echo $element_id ?>' ).on( 'click', function ()
				{
					if ( swiper<?php echo $element_id;
					echo $widget_id; ?>.activeIndex < swiper<?php echo $element_id;
					  echo $widget_id; ?>.slides.length - 1 )
					{
						swiper<?php echo $element_id;
						echo $widget_id; ?>.slideNext();
					}
				} );

			} );
		</script>
        <?php
    }

}