<?php

use handler\product_Query;
use handler\Post_skin_base;
use handler\swiper;
use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

class ar_woo_shop extends \Elementor\Widget_Base {

    use product_Query;
    use Post_skin_base;
    use swiper;
    use basic_element;

    public function get_name() {
        return 'ar_woo_shop';
    }

    public function get_title() {
        return esc_html__('shop archive', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_shop';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_content_section_1() {

        $this->start_controls_section(
            'section_layout',
            [
                'label' => esc_html__( 'Layout', THEME_NAME ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout',
            [
                'label'     => esc_html__( 'Layout', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'options'   => [
                    'grid'     => esc_html__( 'Grid', THEME_NAME ),
                    'carousel' => esc_html__( 'Carousel', THEME_NAME ),
                ],
                'default'   => 'grid',
            ]
        );

        $this->add_responsive_control(
            'columns',
            [
                'label'              => esc_html__( 'Columns', THEME_NAME ),
                'type'               => \Elementor\Controls_Manager::SELECT,
                'default'            => '3',
                'tablet_default'     => '2',
                'mobile_default'     => '1',
                'options'            => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
                'render_type'    => 'template',
                'selectors' => [
                    '{{WRAPPER}} .theme-posts-wrapper.layout-grid' => 'grid-template-columns: repeat({{SIZE}}, 1fr);',
                    '{{WRAPPER}} .theme-posts-wrapper.layout-masonry .post-item' => 'width: calc(100% / {{SIZE}});',
                    '{{WRAPPER}} .theme-posts-wrapper.layout-carousel .post-item' => 'width: calc(100% / {{SIZE}});',
                ],
            ]
        );

		$this->add_control(
			'hover',
			[ 
				'label' => esc_html__( 'hover', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '0',
				'options' => [ 
					'0' => esc_html__( '', THEME_NAME ),
					'1' => esc_html__( 'style 1', THEME_NAME ),
					'2' => esc_html__( 'style 2', THEME_NAME ),
					'3' => esc_html__( 'style 3', THEME_NAME ),
					'4' => esc_html__( 'style 4', THEME_NAME ),
					'5' => esc_html__( 'style 5', THEME_NAME ),
					'6' => esc_html__( 'style 6', THEME_NAME ),
					'7' => esc_html__( 'style 7', THEME_NAME ),
					'8' => esc_html__( 'style 8', THEME_NAME ),
					'9' => esc_html__( 'style 9', THEME_NAME ),
					'10' => esc_html__( 'style 10', THEME_NAME ),
					'11' => esc_html__( 'style 11', THEME_NAME ),
					'12' => esc_html__( 'style 12', THEME_NAME ),
					'13' => esc_html__( 'style 13', THEME_NAME ),
					'14' => esc_html__( 'style 14', THEME_NAME ),
					'15' => esc_html__( 'style 15', THEME_NAME ),
					'16' => esc_html__( 'style 16', THEME_NAME ),
					'17' => esc_html__( 'style 17', THEME_NAME ),
					'18' => esc_html__( 'style 18', THEME_NAME ),
					'19' => esc_html__( 'style 19', THEME_NAME ),
					'20' => esc_html__( 'style 20', THEME_NAME ),
					'21' => esc_html__( 'style 21', THEME_NAME ),
					'22' => esc_html__( 'style 22', THEME_NAME ),
					'23' => esc_html__( 'style 23', THEME_NAME ),
					'24' => esc_html__( 'style 24', THEME_NAME ),
					'25' => esc_html__( 'style 25', THEME_NAME ),
					'26' => esc_html__( 'style 26', THEME_NAME ),
					'27' => esc_html__( 'style 27', THEME_NAME ),
					'28' => esc_html__( 'style 28', THEME_NAME ),
					'29' => esc_html__( 'style 29', THEME_NAME ),
					'30' => esc_html__( 'style 30', THEME_NAME ),
				],
			]
		);

        $this->add_responsive_control(
            'column_gap',
            [
                'label'     => esc_html__( 'Column Gap', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SLIDER,
                'default'   => [
                    'size' => '20',
                ],
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'render_type'    => 'template',
                'selectors' => [
                    '{{WRAPPER}} .theme-posts-wrapper.layout-grid' => 'column-gap: {{SIZE}}{{UNIT}};',
                    'body:not(.rtl) {{WRAPPER}} .theme-posts-wrapper.layout-carousel .post-item' => 'margin-right: {{SIZE}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .theme-posts-wrapper.layout-carousel .post-item' => 'margin-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .theme-posts-wrapper.layout-masonry' => 'margin-left: calc({{SIZE}}{{UNIT}} * -.5); margin-right: calc({{SIZE}}{{UNIT}} * -.5);',
                    '{{WRAPPER}} .theme-posts-wrapper.layout-masonry .post-item' => 'padding-left: calc({{SIZE}}{{UNIT}} * .5); padding-right: calc({{SIZE}}{{UNIT}} * .5);',
                ],
            ]
        );

        $this->add_responsive_control(
            'row_gap',
            [
                'label'     => esc_html__( 'Row Gap', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SLIDER,
                'default'   => [
                    'size' => '20',
                ],
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .theme-posts-wrapper.layout-grid' => 'row-gap: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .theme-posts-wrapper.layout-masonry .post-item' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'layout!' => 'carousel',
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function register_content_section_2() {

        $this->start_controls_section(
            'section_post_settings',
            [
                'label' => esc_html__( 'Post Settings', THEME_NAME ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'align_content',
            [
                'label'     => esc_html__( 'Content Alignment', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::CHOOSE,
                'options'   => [
                    'left'   => [
                        'title' => esc_html__( 'Left', THEME_NAME ),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', THEME_NAME ),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'right'  => [
                        'title' => esc_html__( 'Right', THEME_NAME ),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'default'   => 'left',
                'selectors' => [
                    '{{WRAPPER}} .content-wrapper' => 'text-align: {{VALUE}};',
                    '{{WRAPPER}} .meta-wrapper' => 'justify-content: {{VALUE}};',
                ],
            ]
        );
		
		
		$this->add_control(
            'hide_last_item_on_tablet',
            [
                'label'     => esc_html__( 'Hide Last Item On Tablet', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SWITCHER,
                'selectors' => [
                    'body[data-elementor-device-mode="tablet"] {{WRAPPER}} .post-item:last-of-type' => 'display: none;',
                ],
				'condition' => [
                    'layout' => 'grid',
                ],
				'separator' => 'before',
            ]
        );	

		$this->add_control(
            'disable_image_hover_effect',
            [
                'label'     => esc_html__( 'Disable Image Hover Effect', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SWITCHER,
                'selectors' => [
                    '{{WRAPPER}} .image-wrapper:hover img' => 'transform: none;',
                ],
				'separator' => 'before',
            ]
        );		

        $this->add_responsive_control(
            'image_height',
            [
                'label'     => esc_html__( 'Image Height', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SLIDER,
				'size_units'=> [ 'px', '%', 'vw', 'vh' ],
                'range'     => [
                    'px' => [
                        'min' => 200,
                        'max' => 800,
                    ],
                    '%' => [
                        'min' => 30,
                        'max' => 100,
                    ],
					'vw' => [
                        'min' => 20,
                        'max' => 100,
                    ],
					'vh' => [
                        'min' => 20,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .image-wrapper' => 'height: {{SIZE}}{{UNIT}};',
                ],
				'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Image_Size::get_type(),
            [
            'name' => 'thumbnail',
            'exclude' => ['custom'],
            'default' => 'medium',
        ]);

        $this->add_control('image_link', [
            'label' => esc_html__('Image Link', THEME_NAME),
            'description' => esc_html__('Add link to image.', THEME_NAME),
            'type' => \Elementor\Controls_Manager::SWITCHER,
        ]);

        $this->add_control(
            'title_tag',
            [
                'label'     => esc_html__( 'Title HTML Tag', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => 'h3',
                'options'   => theme_title_tag(),
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'title_position',
            [
                'label'     => esc_html__( 'Title Position', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'options'   => [
                    'inside'     => esc_html__( 'Inside', THEME_NAME ),
                    'outside'  => esc_html__( 'Outside', THEME_NAME ),
                ],
                'default'   => 'outside',
            ]
        );

        $this->add_control(
            'inside_content_align',
            [
                'label'     => esc_html__( 'Inside Alignment', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::CHOOSE,
                'options'   => [
                    'left'   => [
                        'title' => esc_html__( 'Left', THEME_NAME ),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', THEME_NAME ),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'right'  => [
                        'title' => esc_html__( 'Right', THEME_NAME ),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'default'   => 'left',
                'selectors' => [
                    '{{WRAPPER}} .theme-position-bottom' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'show_terms',
            [
                'label'     => esc_html__( 'Terms', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SWITCHER,
                'separator' => 'before'
            ]
        );
		
		$terms = wp_list_pluck(get_taxonomies( ['public'=>true, 'show_ui'=>true], 'objects' ), "label", "name");

        $this->add_control(
            'terms_taxonomy',
            [
                'label'         => esc_html__( 'Term Taxonomy', THEME_NAME ),
                'description'   => esc_html__( 'Select taxonomy related to your post type.', THEME_NAME ),
                'type'          => \Elementor\Controls_Manager::SELECT,
                'options'       => $terms,
                'condition' => [
                    'show_terms' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'term_limit',
            [
                'label'         => esc_html__( 'Max Terms', THEME_NAME ),
                'type'          => \Elementor\Controls_Manager::NUMBER,
                'default'       => 1,
                'min'           => 1,
                'condition' => [
                    'show_terms' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'terms_position',
            [
                'label'     => esc_html__( 'Terms Position', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'options'   => [
                    'inside'     => esc_html__( 'Inside', THEME_NAME ),
                    'outside'  => esc_html__( 'Outside', THEME_NAME ),
                ],
                'default'   => 'outside',
                'condition' => [
                    'show_terms' => 'yes',
                ],
            ]
        );

        $this->add_control('show_author', [
            'label' => esc_html__('Author', THEME_NAME),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'default' => 'yes',
            'separator' => 'before',
        ]);

        $this->add_control('show_author_image', [
            'label' => esc_html__('Author Image', THEME_NAME),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'condition' => [
                'show_author' => 'yes',
            ],
        ]);

        $this->add_control('show_author_prefix_by', [
            'label' => esc_html__('Author By', THEME_NAME),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'condition' => [
                'show_author' => 'yes',
            ],
        ]);

        $this->add_control(
            'show_date',
            [
                'label'     => esc_html__( 'Date', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SWITCHER,
                'default'   => 'yes',
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'human_diff_time',
            [
                'label'     => esc_html__( 'Human Different Time', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SWITCHER,
                'condition' => [
                    'show_date' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'show_time',
            [
                'label'     => esc_html__( 'Show Time', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SWITCHER,
                'condition' => [
                    'human_diff_time' => '',
                    'show_date'       => 'yes'
                ]
            ]
        );

        $this->add_control('show_comments', [
            'label' => esc_html__('Comments', THEME_NAME),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'separator' => 'before',
        ]);

        $this->add_control(
            'show_excerpt',
            [
            'label'     => esc_html__( 'Excerpt', THEME_NAME ),
            'type'      => \Elementor\Controls_Manager::SWITCHER,
            'separator' => 'before',
            ]
        );

        $this->add_control(
            'excerpt_length',
            [
            'label'       => esc_html__( 'Excerpt Limit Characters', THEME_NAME ),
            'type'        => \Elementor\Controls_Manager::NUMBER,
            'default'     => 100,
            'min'         => 30,
            'step'        => 5,
            'condition'   => [
                'show_excerpt' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'show_post_format_icon',
            [
                'label'     => esc_html__( 'Post Format Icon', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SWITCHER,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'show_read_more',
            [
                'label'     => esc_html__( 'Read More Button', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SWITCHER,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'read_more_text',
            [
                'label'       => esc_html__( 'Read More Text', THEME_NAME ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__( 'Read More', THEME_NAME ),
                'placeholder' => esc_html__( 'Read More', THEME_NAME ),
                'condition'   => [
                    'show_read_more' => 'yes',
                ],
            ]
        );


        $this->add_control(
            'show_top_content', [
            'label' => esc_html__('Top Content', THEME_NAME),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'separator' => 'before',
        ]);

        $this->add_control('top_content_comments', [
            'label' => esc_html__('Comments', THEME_NAME),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'condition' => [
                'show_top_content' => 'yes',
            ],
        ]);

        $this->add_control('top_content_views', [
            'label' => esc_html__('Views', THEME_NAME),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'condition' => [
                'show_top_content' => 'yes',
            ],
        ]);

        $this->add_control('top_content_reading_time', [
            'label' => esc_html__('Reading Time', THEME_NAME),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'condition' => [
                'show_top_content' => 'yes',
            ],
        ]);

        $this->end_controls_section();

    }

    protected function register_style_section_1() {

        $this->start_controls_section('section_style_post',
            [
                'label' => esc_html__('Items', THEME_NAME),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control('item_padding',
            [
                'label' => esc_html__('Padding', THEME_NAME),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .post-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->start_controls_tabs('tabs_item_style');

        $this->start_controls_tab('tab_item_normal',
            [
                'label' => esc_html__('Normal', THEME_NAME),
            ]);

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'item_background',
                'label' => esc_html__('Background', THEME_NAME),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .post-wrapper',
            ]
        );


        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .post-wrapper',
            ]);

        $this->add_responsive_control('item_border_radius',
            [
                'label' => esc_html__('Border Radius', THEME_NAME),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .post-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_group_control(\Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_box_shadow',
                'selector' => '{{WRAPPER}} .post-wrapper',
            ]);

        $this->end_controls_tab();

        $this->start_controls_tab('tab_item_hover',
            [
                'label' => esc_html__('Hover', THEME_NAME),
            ]);

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'item_hover_background',
                'label' => esc_html__('Background', THEME_NAME),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .post-wrapper:hover',
            ]
        );

        $this->add_control('item_hover_border_color',
            [
                'label' => esc_html__('Border Color', THEME_NAME),
                'type' => \Elementor\Controls_Manager::COLOR,
                'condition' => [
                    'item_border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-wrapper:hover' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_responsive_control('item_hover_border_radius',
            [
                'label' => esc_html__('Border Radius', THEME_NAME),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .post-wrapper:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_hover_box_shadow',
                'selector' => '{{WRAPPER}} .post-wrapper:hover',
            ]);

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();


        $this->start_controls_section('section_style_image',
            [
            'label' => esc_html__('Image', THEME_NAME),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'image_width',
            [
                'label'     => esc_html__( 'image width', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', '%'],
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                        'step' => 10,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 10,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .image-wrapper img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_responsive_control(
            'image_border_radius',
            [
            'label' => esc_html__('image Border Radius', THEME_NAME),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors' => [
                '{{WRAPPER}} .image-wrapper img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        $this->add_responsive_control(
            'image_margin',
            [
                'label' => esc_html__('Margin', THEME_NAME),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .image-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->start_controls_tabs('tabs_image_style');

        $this->start_controls_tab('tab_image_normal',
            [
            'label' => esc_html__('Normal', THEME_NAME),
        ]);

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'image_overlay_color',
                'label' => esc_html__('Overlay Color', THEME_NAME),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .image-wrapper',
            ]
        );

        

        $this->add_group_control(
             \Elementor\Group_Control_Border::get_type(),
            [
            'name' => 'image_border',
            'selector' => '{{WRAPPER}} .image-wrapper',
        ]);

        $this->add_responsive_control('image_container_border_radius',
            [
            'label' => esc_html__('Border Radius', THEME_NAME),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors' => [
                '{{WRAPPER}} .image-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        $this->add_group_control(\Elementor\Group_Control_Box_Shadow::get_type(),
            [
            'name' => 'image_box_shadow',
            'selector' => '{{WRAPPER}} .image-wrapper',
        ]);

        $this->end_controls_tab();

        $this->start_controls_tab('tab_image_hover',
            [
            'label' => esc_html__('Hover', THEME_NAME),
        ]);

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'image_overlay_hover_color',
                'label' => esc_html__('Overlay Color', THEME_NAME),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .image-wrapper:hover::before',
            ]
        );

        $this->add_control(
            'image_overlay_hover_opacity',
            [
                'label'     => esc_html__( 'Overlay Opacity', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 1,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .image-wrapper:hover::before' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->add_control('image_hover_border_color',
            [
            'label' => esc_html__('Border Color', THEME_NAME),
            'type' => \Elementor\Controls_Manager::COLOR,
            'condition' => [
                'image_border_border!' => '',
            ],
            'selectors' => [
                '{{WRAPPER}} .image-wrapper:hover' => 'border-color: {{VALUE}};',
            ],
        ]);

        $this->add_responsive_control('image_hover_border_radius',
            [
                'label' => esc_html__('Border Radius', THEME_NAME),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .image-wrapper:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_group_control(
             \Elementor\Group_Control_Box_Shadow::get_type(),
             [
            'name' => 'image_hover_box_shadow',
            'selector' => '{{WRAPPER}} .image-wrapper:hover',
        ]);

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section('section_style_content',
            [
                'label' => esc_html__('Content', THEME_NAME),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control('content_margin',
            [
                'label' => esc_html__('Margin', THEME_NAME),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .content-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_responsive_control('content_padding',
            [
                'label' => esc_html__('Padding', THEME_NAME),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .content-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->start_controls_tabs('tabs_content_style');

        $this->start_controls_tab('tab_content_normal',
            [
                'label' => esc_html__('Normal', THEME_NAME),
            ]);

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'content_background',
                'label' => esc_html__('Background', THEME_NAME),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .content-wrapper',
            ]
        );


        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'content_border',
                'selector' => '{{WRAPPER}} .content-wrapper',
            ]);

        $this->add_responsive_control('content_border_radius',
            [
                'label' => esc_html__('Border Radius', THEME_NAME),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .content-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_group_control(\Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'content_box_shadow',
                'selector' => '{{WRAPPER}} .content-wrapper',
            ]);

        $this->end_controls_tab();

        $this->start_controls_tab('tab_content_hover',
            [
                'label' => esc_html__('Hover', THEME_NAME),
            ]);

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'content_hover_background',
                'label' => esc_html__('Background', THEME_NAME),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .post-wrapper:hover .content-wrapper',
            ]
        );

        $this->add_control('content_hover_border_color',
            [
                'label' => esc_html__('Border Color', THEME_NAME),
                'type' => \Elementor\Controls_Manager::COLOR,
                'condition' => [
                    'content_border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-wrapper:hover .content-wrapper' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_responsive_control('content_hover_border_radius',
            [
                'label' => esc_html__('Border Radius', THEME_NAME),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .post-wrapper:hover .content-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'content_hover_box_shadow',
                'selector' => '{{WRAPPER}} .post-wrapper:hover .content-wrapper',
            ]);

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();


        $this->start_controls_section('section_style_meta',
            [
            'label' => esc_html__('Meta', THEME_NAME),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]);

        $this->add_control('meta_color',
            [
            'label' => esc_html__('Color', THEME_NAME),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .meta-wrapper' => 'color: {{VALUE}};',
            ],
        ]);

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
            'name' => 'meta_typography',
            'label' => esc_html__('Typography', THEME_NAME),
            'selector' => '{{WRAPPER}} .meta-wrapper',
        ]);

        $this->end_controls_section();

        $this->start_controls_section('section_style_top_content',
            [
                'label' => esc_html__('Top Content', THEME_NAME),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_top_content' => 'yes',
                ],
            ]);

        $this->add_responsive_control('top_content_margin',
            [
                'label' => esc_html__('Margin', THEME_NAME),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .top-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_responsive_control('top_content_padding',
            [
                'label' => esc_html__('Padding', THEME_NAME),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .top-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_control(
            'top_content_items_gap',
            [
                'label'     => esc_html__( 'Items Gap', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 1,
                        'max' => 20,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .top-content' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'top_content_background',
                'label' => esc_html__('Background', THEME_NAME),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .top-content',
            ]
        );

        $this->add_control('top_content_color',
            [
                'label' => esc_html__('Color', THEME_NAME),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .top-content, .top-content a' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'top_content_border',
                'selector' => '{{WRAPPER}} .top-content',
            ]);

        $this->add_responsive_control('top_content_border_radius',
            [
                'label' => esc_html__('Border Radius', THEME_NAME),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .top-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_group_control(\Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'top_content_shadow',
                'selector' => '{{WRAPPER}} .top-content',
            ]);

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'top_content_typography',
                'label' => esc_html__('Typography', THEME_NAME),
                'selector' => '{{WRAPPER}} .top-content',
            ]);

        $this->end_controls_section();

    }

    protected function register_style_section_2() {
        $this->start_controls_section('section_style_title',
            [
                'label' => esc_html__('Title', THEME_NAME),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]);

        $this->add_control(
            'title_hover_style',
            [
                'label'   => esc_html__( 'Hover Style', THEME_NAME ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'default' => 'default',
                'options' => [
                    'default'          => esc_html__( 'Default', THEME_NAME ),
                    'underline-fix'    => esc_html__( 'Underline Fix', THEME_NAME ),
                    'overline-fix'     => esc_html__( 'Overline Fix', THEME_NAME ),
                    'middle-fix'       => esc_html__( 'Middle Fix', THEME_NAME ),
                    'underline'        => esc_html__( 'Underline', THEME_NAME ),
                    'middle-underline' => esc_html__( 'Middle Underline', THEME_NAME ),
                    'overline'         => esc_html__( 'Overline', THEME_NAME ),
                    'middle-overline'  => esc_html__( 'Middle Overline', THEME_NAME ),
                    'underline-in-out' => esc_html__( 'Underline In Out', THEME_NAME ),
                    'middle-in-out'    => esc_html__( 'Middle In Out', THEME_NAME ),
                    'overline-in-out'  => esc_html__( 'Overline In Out', THEME_NAME ),
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'title_shape_hover_background',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .post-wrapper .title a, {{WRAPPER}} .post-wrapper .title a::after',
                'condition' => [
                    'title_hover_style!' => ['default', 'underline-fix', 'overline-fix', 'middle-fix']
                ]
            ]
        );

        $this->add_responsive_control('title_margin',
            [
                'label' => esc_html__('Margin', THEME_NAME),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .post-wrapper .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_responsive_control('title_padding',
            [
                'label' => esc_html__('Padding', THEME_NAME),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .post-wrapper .title a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => esc_html__('Typography', THEME_NAME),
                'selector' => '{{WRAPPER}} .post-wrapper .title a',
            ]);

        $this->add_control(
            'title_grid_tiles_sm_font_size',
            [
                'label'     => esc_html__( 'Small Titles Font Size', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'rem', 'em' ],
                'range'     => [
                    'px' => [
                        'min'  => 13,
                        'max'  => 50,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min'  => 1,
                        'max'  => 4,
                        'step' => 0.1,
                    ],
                    'em' => [
                        'min'  => 1,
                        'max'  => 4,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-wrapper .title' => '--sm-tiles-font-size: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'layout'             => 'grid',
                    'grid_tiles_layout!' => '0',
                ],
            ]
        );

        $this->add_control(
            'title_grid_tiles_sm_line_height',
            [
                'label'     => esc_html__( 'Small Titles Line Height', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'em' ],
                'range'     => [
                    'px' => [
                        'min'  => 13,
                        'max'  => 50,
                        'step' => 1,
                    ],
                    'em' => [
                        'min'  => 0.8,
                        'max'  => 4,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-wrapper .title' => '--sm-tiles-line-height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'layout'             => 'grid',
                    'grid_tiles_layout!' => '0',
                ],
            ]
        );

        $this->start_controls_tabs(
            'title_style_tabs'
        );

        $this->start_controls_tab(
            'title_style_normal_tab',
            [
                'label' => esc_html__( 'Normal', THEME_NAME ),
            ]
        );

        $this->add_control('title_color',
            [
                'label' => esc_html__('Color', THEME_NAME),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-wrapper .title a' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control('title_section_background',
            [
                'label' => esc_html__('Section Background', THEME_NAME),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-wrapper .title' => 'background-color: {{VALUE}};',
                ],
            ]);

        $this->add_control('title_background',
            [
                'label' => esc_html__('Background', THEME_NAME),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-wrapper .title a' => 'background-color: {{VALUE}};',
                ],
            ]);

        $this->add_group_control(
            \Elementor\Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'title_text_shadow',
                'label' => esc_html__( 'Text Shadow', THEME_NAME ),
                'selector' => '{{WRAPPER}} .post-wrapper .title a',
            ]
        );


        $this->end_controls_tab();

        $this->start_controls_tab(
            'title_style_hover_tab',
            [
                'label' => esc_html__( 'Hover', THEME_NAME ),
            ]
        );

        $this->add_control('title_hover_color',
            [
                'label' => esc_html__('Color', THEME_NAME),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-wrapper .title a:hover' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control('title_section_hover_background',
            [
                'label' => esc_html__('Section Background', THEME_NAME),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-wrapper .title:hover' => 'background-color: {{VALUE}};',
                ],
            ]);

        $this->add_control('title_hover_background',
            [
                'label' => esc_html__('Background', THEME_NAME),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-wrapper .title a:hover' => 'background-color: {{VALUE}};',
                ],
            ]);

        $this->add_group_control(
            \Elementor\Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'title_hover_text_shadow',
                'label' => esc_html__( 'Text Shadow', THEME_NAME ),
                'selector' => '{{WRAPPER}} .post-wrapper .title a:hover',
            ]
        );


        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

    }

    protected function register_style_section_3() {
        $this->start_controls_section('section_style_term',
            [
                'label' => esc_html__('Term', THEME_NAME),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_terms' => 'yes',
                ],
            ]);

        $this->add_responsive_control('term_wrapper_margin',
            [
                'label' => esc_html__('Section Margin', THEME_NAME),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .terms-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_responsive_control('term_margin',
            [
                'label' => esc_html__('Item Margin', THEME_NAME),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .term-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_responsive_control('term_padding',
            [
                'label' => esc_html__('Item Padding', THEME_NAME),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .term-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->start_controls_tabs('tabs_term_style');
        $this->start_controls_tab('tab_term_normal',
            [
                'label' => esc_html__('Normal', THEME_NAME),
            ]);

        $this->add_control('term_color',
            [
                'label' => esc_html__('Color', THEME_NAME),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .term-item' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'term_background',
                'selector' => '{{WRAPPER}} .term-item',
            ]);

        $this->add_control('term_multi_background',
            [
                'label'         => esc_html__( 'Multi Background', THEME_NAME ),
                'description'   => esc_html__( 'Edit terms and set color for them.', THEME_NAME ),
                'type'          => \Elementor\Controls_Manager::SWITCHER,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'term_border',
                'selector' => '{{WRAPPER}} .term-item',
            ]);

        $this->add_responsive_control('term_border_radius',
            [
                'label' => esc_html__('Border Radius', THEME_NAME),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .term-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'term_shadow',
                'selector' => '{{WRAPPER}} .term-item',
            ]);

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'term_typography',
                'label' => esc_html__('Typography', THEME_NAME),
                'selector' => '{{WRAPPER}} .term-item',
            ]);

        $this->end_controls_tab();

        $this->start_controls_tab('tab_term_hover',
            [
                'label' => esc_html__('Hover', THEME_NAME),
            ]);

        $this->add_control('term_hover_color',
            [
                'label' => esc_html__('Color', THEME_NAME),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .term-item:hover' => 'color: {{VALUE}};',
                ],
            ]);


        $this->add_control('term_hover_background',
            [
                'label' => esc_html__('Background', THEME_NAME),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .term-item:hover' => 'background: {{VALUE}} !important;',
                ],
            ]);

        $this->add_control('term_hover_border_color',
            [
                'label' => esc_html__('Border Color', THEME_NAME),
                'type' => \Elementor\Controls_Manager::COLOR,
                'condition' => [
                    'term_border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .term-item:hover' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_responsive_control('term_hover_border_radius',
            [
                'label' => esc_html__('Border Radius', THEME_NAME),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .term-item:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'term_hover_shadow',
                'selector' => '{{WRAPPER}} .term-item:hover',
            ]);

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'term_hover_typography',
                'label' => esc_html__('Typography', THEME_NAME),
                'selector' => '{{WRAPPER}} .term-item:hover',
            ]);

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function register_style_section_4() {
        $this->start_controls_section('section_style_excerpt',
            [
                'label' => esc_html__('Excerpt', THEME_NAME),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_excerpt' => 'yes',
                ],
            ]);

        $this->add_control('excerpt_color',
            [
                'label' => esc_html__('Color', THEME_NAME),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .excerpt' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'excerpt_typography',
                'label' => esc_html__('Typography', THEME_NAME),
                'selector' => '{{WRAPPER}} .excerpt',
            ]);

        $this->add_responsive_control(
            'excerpt_margin',
            [
                'label'      => esc_html__( 'Margin', THEME_NAME ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors'  => [
                    '{{WRAPPER}} .excerpt' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function register_style_section_5() {

        $this->start_controls_section(
            'section_post_format_icon_style',
            [
                'label' => esc_html__( 'Post Format Icon', THEME_NAME ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                'condition'   => [
                    'show_post_format_icon' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'post_format_icon_position',
            [
                'label'     => esc_html__( 'Icon Position', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => 'top-left',
                'options'   => [
                    'top-left'          => esc_html__( 'Top Left', THEME_NAME ),
                    'top-center'        => esc_html__( 'Top Center', THEME_NAME ),
                    'top-right'         => esc_html__( 'Top Right', THEME_NAME ),
                    'center-center'     => esc_html__( 'Center Center', THEME_NAME ),
                ],
            ]
        );

        $this->add_responsive_control(
            'post_format_icon_margin',
            [
                'label'      => esc_html__( 'Margin', THEME_NAME ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'selectors'  => [
                    '{{WRAPPER}} .post-format-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'post_format_icon_padding',
            [
                'label'     => esc_html__( 'Padding', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 2,
                        'max' => 20,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-format-icon' => 'padding: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'post_format_icon_font_size',
            [
                'label'     => esc_html__( 'Icon Size', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 8,
                        'max' => 20,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-format-icon' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'post_format_icon_background',
            [
                'label'     => esc_html__( 'Background', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-format-icon' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'post_format_icon_color',
            [
                'label'     => esc_html__( 'Color', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-format-icon' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'post_format_icon_border',
                'selector' => '{{WRAPPER}} .post-format-icon',
            ]
        );

        $this->add_responsive_control(
            'post_format_icon_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', THEME_NAME ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .post-format-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'post_format_icon_box_shadow',
                'selector' => '{{WRAPPER}} .post-format-icon',
            ]);

        $this->end_controls_section();
    }
    
    protected function register_style_section_6() {
        $this->start_controls_section(
            'section_read_more_style',
            [
                'label' => esc_html__( 'Read More', THEME_NAME ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                'condition'   => [
                    'show_read_more' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'read_more_style',
            [
                'label'   => esc_html__( 'Button Style', THEME_NAME ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'default' => 'default',
                'options' => [
                    'default'      => esc_html__( 'Style default', THEME_NAME ),
                    '1'            => esc_html__( 'Style 1', THEME_NAME ),
                    '2'            => esc_html__( 'Style 2', THEME_NAME ),
                    '3'            => esc_html__( 'Style 3', THEME_NAME ),
                ],
            ]
        );

        $this->add_control(
            'read_more_icon',
            [
                'label'     => esc_html__( 'Button Icon', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => 'none',
                'options'   => [
                    'none'                              => esc_html__( 'No Icon', THEME_NAME ),
                    'ri-angle-right-solid'              => esc_html__( 'Style 1', THEME_NAME ),
                    'ri-angle-double-right-solid'       => esc_html__( 'Style 2', THEME_NAME ),
                    'ri-arrow-alt-circle-right'         => esc_html__( 'Style 3', THEME_NAME ),
                    'ri-arrow-circle-right-solid'       => esc_html__( 'Style 4', THEME_NAME ),
                    'ri-arrow-right-solid'              => esc_html__( 'Style 5', THEME_NAME ),
                    'ri-caret-right-solid'              => esc_html__( 'Style 6', THEME_NAME ),
                    'ri-caret-square-right'             => esc_html__( 'Style 7', THEME_NAME ),
                    'ri-chevron-right-solid'            => esc_html__( 'Style 8', THEME_NAME ),
                    'ri-long-arrow-alt-right-solid'     => esc_html__( 'Style 9', THEME_NAME ),
                    'ri-arrow-right-b'                  => esc_html__( 'Style 10', THEME_NAME ),
                    'ri-arrow-right-c'                  => esc_html__( 'Style 11', THEME_NAME ),
                    'ri-android-arrow-dropright-circle' => esc_html__( 'Style 12', THEME_NAME ),
                    'ri-chevron-right'                  => esc_html__( 'Style 13', THEME_NAME ),
                    'ri-arrow-right-a'                  => esc_html__( 'Style 14', THEME_NAME ),
                    'ri-ios-arrow-thin-right'           => esc_html__( 'Style 15', THEME_NAME ),
                    'ri-chevron-circle-right-solid'     => esc_html__( 'Style 16', THEME_NAME ),
                    'ri-ios-redo-outline'               => esc_html__( 'Style 17', THEME_NAME ),
                    'ri-android-share'                  => esc_html__( 'Style 18', THEME_NAME ),
                    'ri-arrow-right-line'               => esc_html__( 'Style 19', THEME_NAME ),
                    'ri-arrow-right-circle-line'        => esc_html__( 'Style 20', THEME_NAME ),
                    'ri-arrow-right-fill'               => esc_html__( 'Style 21', THEME_NAME ),
                    'ri-arrow-right-circle-fill'        => esc_html__( 'Style 22', THEME_NAME ),
                    'ri-arrow-right-s-line'             => esc_html__( 'Style 23', THEME_NAME ),
                ],
            ]
        );

        $this->add_responsive_control(
            'read_more_icon_position',
            [
                'label' => esc_html__( 'Icon position', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'toggle' => false,
                'options' => [
                    'before' => [
                        'title' => esc_html__( 'before', THEME_NAME ),
                        'icon' => 'eicon-h-align-right',
                    ],
                    'after' => [
                        'title' => esc_html__( 'after', THEME_NAME ),
                        'icon' => 'eicon-h-align-left',
                    ]
                ],
                'default' => 'after',
                'condition' => [
                    'read_more_icon!' => 'none',
                ],
            ]
        );

        $this->add_responsive_control(
            'read_more_align',
            [
                'label' => esc_html__( 'Alignment', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', THEME_NAME ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', THEME_NAME ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', THEME_NAME ),
                        'icon' => 'eicon-text-align-right',
                    ]
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}} .theme-read-more-wrapper' => 'text-align: {{VALUE}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'read_more_padding',
            [
                'label'      => esc_html__( 'Padding', THEME_NAME ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors'  => [
                    '{{WRAPPER}} .theme-read-more' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'read_more_margin',
            [
                'label'      => esc_html__( 'Margin', THEME_NAME ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .theme-read-more' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );


        $this->start_controls_tabs(
            'read_more_style_tabs'
        );

        $this->start_controls_tab(
            'read_more_style_normal_tab',
            [
                'label' => esc_html__( 'Normal', THEME_NAME ),
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'read_more_typography',
                'label'    => esc_html__( 'Typography', THEME_NAME ),
                'selector' => '{{WRAPPER}} .theme-read-more .read-more-title',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'read_more_background',
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .theme-read-more',
            ]
        );

        $this->add_control(
            'read_more_color',
            [
                'label'     => esc_html__( 'Color', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .theme-read-more' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'read_more_border',
                'selector' => '{{WRAPPER}} .theme-read-more',
            ]
        );

        $this->add_responsive_control(
            'read_more_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', THEME_NAME ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .theme-read-more' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(\Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'read_more_box_shadow',
                'selector' => '{{WRAPPER}} .theme-read-more',
            ]);

        $this->add_control(
            'read_more_icon_color',
            [
                'label'     => esc_html__( 'Icon Color', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .theme-read-more i' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'read_more_icon!' => 'none',
                ],
            ]
        );


        $this->end_controls_tab();

        $this->start_controls_tab(
            'read_more_style_hover_tab',
            [
                'label' => esc_html__( 'Hover', THEME_NAME ),
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'read_more_hover_typography',
                'label'    => esc_html__( 'Typography', THEME_NAME ),
                'selector' => '{{WRAPPER}} .theme-read-more:hover .read-more-title',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'read_more_hover_background',
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .theme-read-more:hover',
            ]
        );

        $this->add_control('read_more_hover_border_color',
            [
                'label' => esc_html__('Border Color', THEME_NAME),
                'type' => \Elementor\Controls_Manager::COLOR,
                'condition' => [
                    'read_more_border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .theme-read-more:hover' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'read_more_hover_box_shadow',
                'selector' => '{{WRAPPER}} .theme-read-more:hover',
            ]);

        $this->add_control(
            'read_more_hover_color',
            [
                'label'     => esc_html__( 'Color', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .theme-read-more:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'read_more_icon_hover_color',
            [
                'label'     => esc_html__( 'Icon Color', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .theme-read-more:hover i' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'read_more_icon!' => 'none',
                ],
            ]
        );


        $this->end_controls_tab();

        $this->end_controls_tabs();


        $this->add_responsive_control(
            'read_more_icon_size',
            [
                'label'     => esc_html__( 'Icon Size', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 10,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .theme-read-more i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'read_more_icon!' => 'none',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'read_more_icon_spacing',
            [
                'label'      => esc_html__( 'Icon Spacing', THEME_NAME ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors'  => [
                    '{{WRAPPER}} .theme-read-more i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'read_more_icon!' => 'none',
                ],
            ]
        );
        

        // Style 1 Shape
        $this->add_control(
            'read_more_shape',
            [
                'label'     => esc_html__( 'Shape', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'read_more_style' => '1',
                ],
            ]
        );

        $this->add_control(
            'read_more_shape_position',
            [
                'label'     => esc_html__( 'shape position', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => 'left',
                'options'   => [
                    'left'         => esc_html__( 'Left', THEME_NAME ),
                    'center'       => esc_html__( 'Center', THEME_NAME ),
                    'right'        => esc_html__( 'Right', THEME_NAME ),
                ],
                'condition' => [
                    'read_more_style' => '1',
                ],
            ]
        );

        $this->add_responsive_control(
            'read_more_shape_width',
            [
                'label'     => esc_html__( 'Shape Width', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .theme-read-more.style-1::before' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'read_more_style' => '1',
                ],
            ]
        );


        $this->add_responsive_control(
            'read_more_shape_height',
            [
                'label'     => esc_html__( 'Shape Height', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .theme-read-more.style-1::before' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'read_more_style' => '1',
                ],
            ]
        );

        $this->add_control(
            'read_more_shape_color',
            [
                'label'     => esc_html__( 'Color', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .theme-read-more.style-1::before' => 'background: {{VALUE}};',
                ],
                'condition' => [
                    'read_more_style' => '1',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'read_more_shape_border',
                'selector' => '{{WRAPPER}} .theme-read-more.style-1::before',
                'condition' => [
                    'read_more_style' => '1',
                ],
            ]
        );

        $this->add_responsive_control(
            'read_more_shape_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', THEME_NAME ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .theme-read-more.style-1::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'read_more_style' => '1',
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function register_controls() {

        $this->register_query_builder_controls();
        $this->register_content_section_1();
        $this->register_content_section_2();

        $this->register_carousel_controls();

        $this->register_style_section_1();
        $this->register_style_section_2();
        $this->register_style_section_3();
        $this->register_style_section_4();
        $this->register_style_section_5();
        $this->register_style_section_6();
        $this->register_style_carousel_controls();

    }

    protected function render_author() {
        if ( !$this->get_settings( 'show_author' ) ) {
            return;
        }

        $settings = $this->get_settings_for_display();
        ?>
        <div class="author-wrapper">
            <?php
            if($settings['show_author_image']) {
                echo get_avatar( get_the_author_meta( 'user_email' ), 60 );
            }

            if($settings['show_author_prefix_by']) {
                ?>
                <span class="by"><?php echo esc_html__( 'by', THEME_NAME ) ; ?></span>
                <?php
            }
            ?>
            <a href="<?php echo  get_author_posts_url( get_the_author_meta( 'ID' ) ) ; ?>">
                <?php echo get_the_author() ; ?>
            </a>
        </div>
        <?php
    }


    protected function render_comments() {
        if ( !$this->get_settings( 'show_comments' ) ) {
            return;
        }
        $comments_count = get_comments_number();
        ?>
        <div class="comments-wrapper">
            <span>
                <?php
                if( $comments_count == 0 ) {
                    esc_html_e('No Comment', THEME_NAME);
                }
                elseif ( $comments_count == 1 ) {
                    esc_html_e('One Comment', THEME_NAME);
                }
                else {
                    printf( esc_html__('%d Comments', THEME_NAME), $comments_count );
                }
                ?>
            </span>
        </div>
        <?php
    }

    protected function render(){
        if ( !class_exists( 'woocommerce' ) ) {
			return false;
		}
        $settings = $this->get_settings_for_display();
		$element_id = $settings['_element_id'];
        $query = $this->get_query_result();
        if ( ! $query->found_posts ) {

            ?>
            <div class="nothing-show">
                <h2><?php esc_html_e('Nothing found!', THEME_NAME); ?></h2>
                <p><?php esc_html_e('It looks like nothing was found here!', THEME_NAME); ?></p>
            </div>
            <?php

            return;
        }

        ?>
        <div class="theme-posts-container theme-post-widget">
            <?php
            $post_wrapper_cls = '';
                if( $settings['layout'] == 'grid' ) {
                    $post_wrapper_cls = 'theme-posts-wrapper';
                }
            ?>
            <div class="<?php echo $post_wrapper_cls ?> layout-<?php echo $settings['layout'] ?>" >
                <?php $this->render_carousel_header(); ?>
                <?php
                if ( $query->have_posts() ) :
                    while ( $query->have_posts() ) :
                        $query->the_post();
                        $product_id = get_the_ID();
                        $product_price = get_post_meta( $product_id, '_regular_price', true );

                        // Get add to cart URL
                        $add_to_cart_url = esc_url( get_permalink( $product_id ) . '?add-to-cart=' . $product_id );

                        $post_item_cls = 'post-item';
                        if( $settings['layout'] == 'carousel' ) {
                            $post_item_cls = ' swiper-slide';
                        }

                        ?>
                        <div class="<?php echo esc_html($post_item_cls); ?>">
                            <article <?php post_class( array( 'post-wrapper', 'cart-hover-' . $settings['hover'] ) ); ?>>
                                <?php if(has_post_thumbnail()): ?>
                                <div class="image-wrapper">
                                    <?php the_post_thumbnail($settings['thumbnail_size'], array( 'title' => get_the_title() )); ?>
                                    <?php
                                    if($settings['image_link']) {
                                        echo '<a class="image-link " href="' . get_permalink() . '"></a>';
                                    }
                                    ?>
                                    <div class="theme-position-bottom">
                                        <?php if($settings['terms_position'] == 'inside') { $this->render_terms(); } ?>
                                        <?php if($settings['title_position'] == 'inside') { $this->render_title(); } ?>
                                    </div>
                                    <?php if($settings['show_top_content']){ ?>
                                        <div class="top-content">
                                            <?php if( $settings['top_content_comments'] ): ?>
                                                <span class="top-comments" title="<?php esc_html_e('Comments', THEME_NAME) ?>">
                                                <i class="isax isax-note"></i>
                                                <?php echo get_comments_number(); ?></span>
                                            <?php endif; ?>

                                            <?php if( $settings['top_content_views'] ): ?>
                                                <span class="top-views" title="<?php esc_html_e('Views', THEME_NAME) ?>">
                                                <i class="isax isax-eye"></i>
                                                <?php echo get_post_view(get_the_ID()); ?></span>
                                            <?php endif; ?>

                                            <?php if( $settings['top_content_reading_time'] ): ?>
                                                <span class="top-reading-time" title="<?php esc_html_e('Reading Time', THEME_NAME) ?>">
                                                <i class="isax isax-clock"></i>
                                                <?php echo calc_read_time(); ?></span>
                                            <?php endif; ?>
                                        </div>
                                    <?php } ?>

                                    <?php $this->render_post_format_icon(); ?>
                                </div>
                                <?php endif; ?>
                                <div class="content-wrapper">
                                    <?php if($settings['terms_position'] == 'outside') { $this->render_terms(); } ?>
                                    <?php if($settings['title_position'] == 'outside') { $this->render_title(); } ?>
                                    <div class="meta-wrapper">
                                        <?php $this->render_author(); ?>
                                        <?php $this->render_date(); ?>
                                        <?php $this->render_comments(); ?>
                                    </div>
                                    <?php
                                    $this->render_excerpt();
                                    echo '<div class="product-price">' . wc_price( $product_price ) . '</div>';

                                    // Display add to cart button
                                    echo '<div class="product-add-to-cart">';
                                    echo '<a href="' . $add_to_cart_url . '" class="button">' . esc_html__( 'Add to Cart', THEME_NAME ) . '</a>';
                                    echo '</div>';
                                    $this->render_read_more(); ?>
                                </div>
                            </article>
                        </div>
                    <?php
                    endwhile;
                endif;
                wp_reset_postdata();
                ?>
                <?php $this->render_carousel_footer(); ?>
            </div>
        </div>
        <?php $this->render_pagination(); 
    }
}