<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_product_tags extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_woo_product_tags';
    }

    public function get_title() {
        return esc_html__('product tags', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_product_tags';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }


    protected function register_style_section_1() {
        $this->start_controls_section(
            'product_price_style_section',
            [
                'label' => esc_html__( 'tags', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('product_categories',  '.product-product_tag li');

        $this->end_controls_section();

    } 

    protected function register_controls() {

        $this->register_style_section_1();
    }

    protected function render() {
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
        $settings = $this->get_settings_for_display();

        if ($this->theme_is_edit_mode()) {
            $first_product_id = get_posts(array(
                'post_type'      => 'product',
                'posts_per_page' => 1,
                'orderby'        => 'ID',
                'order'          => 'ASC',
                'fields'         => 'ids',
            ));
            $first_product = wc_get_product($first_product_id[0]);
            
            $product_categories = wp_get_post_terms($first_product_id[0], 'product_tag', array('fields' => 'all'));

            if (!empty($product_categories)) {
                echo '<div class="product-product_tag">';
                echo '<ul style="margin:0px;">';
                foreach ($product_categories as $category) {
                    $category_url = get_term_link($category);
                    echo '<li><a href="' . esc_url($category_url) . '">' . esc_html($category->name) . '</a></li>';
                }
                echo '</ul>';
                echo '</div>';
            }
        } else {
			global $post;
			$product_id = get_the_ID();
			$product = wc_get_product( $product_id );
            if ($product) {
                $product_categories = wp_get_post_terms($product_id, 'product_cat', array('fields' => 'all'));

                if (!empty($product_categories)) {
                    echo '<div class="product-product_tag">';
                    echo '<ul style="margin:0px;">';
                    foreach ($product_categories as $category) {
                        $category_url = get_term_link($category);
                        echo '<li><a href="' . esc_url($category_url) . '">' . esc_html($category->name) . '</a></li>';
                    }
                    echo '</ul>';
                    echo '</div>';
                }
            }
        }
    }

}