<?php

use handler\product_Query;
use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_product_tabs extends \Elementor\Widget_Base {

    use product_Query;
    use basic_element;

    public function get_name() {
        return 'ar_woo_product_tabs';
    }

    public function get_title() {
        return esc_html__('product tabs', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_product_tabs';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function get_layout_source() {
        global $post;

        $current_page_id = $post->ID;

        $posts = get_posts(array(
            'post_type'      => 'theme-blog',
            'posts_per_page' => -1, 
            'exclude'        => $current_page_id,
        ));

        $options = array();
        foreach ($posts as $post) {
            $options[$post->ID] = $post->post_title;
        }

        return $options;
    }

    protected function register_content_section_1() {

        $this->start_controls_section(
            'section_layout',
            [
                'label' => esc_html__( 'Layout', THEME_NAME ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'posts_layout',
			[
				'label'   => esc_html__( 'Posts layout', THEME_NAME ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'options' => $this->get_layout_source(),
				'default' => 'post',
			]
		);

        $this->end_controls_section();

    }

	protected function register_style_section_1() {
		$this->start_controls_section(
			'panels_style_section',
			[ 
				'label' => esc_html__( 'panels', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'container',
			[ 
				'label' => esc_html__( 'container', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_container_style( 'product-tabs', '.product-tabs' );

		$this->add_control(
			'items',
			[ 
				'label' => esc_html__( 'items', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_container_style( 'side-right', '.tab-btn-container' );

		$this->add_control(
			'side-left',
			[ 
				'label' => esc_html__( 'content', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_container_style( 'side-left', '.side-left' );

		$this->end_controls_section();
	}

	protected function register_style_section_2() {
		$this->start_controls_section(
			'items_style_section',
			[ 
				'label' => esc_html__( 'items', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->start_controls_tabs(
			'title_style_tabs'
		);

		$this->start_controls_tab(
			'title_style_normal_tab',
			[ 
				'label' => esc_html__( 'Normal', THEME_NAME ),
			]
		);

		$this->register_text_style( 'title_wrapper', '.tab-btn', $align = false );

		$this->end_controls_tab();

		$this->start_controls_tab(
			'title_style_hover_tab',
			[ 
				'label' => esc_html__( 'Hover', THEME_NAME ),
			]
		);

		$this->register_text_style( 'title_wrapper_hover', '.tab-btn:hover', $align = false );

		$this->end_controls_tab();

		$this->start_controls_tab(
			'title_style_active_tab',
			[ 
				'label' => esc_html__( 'active', THEME_NAME ),
			]
		);

		$this->register_text_style( 'title_wrapper_active', '.tab-btn.active', $align = false );

		$this->end_controls_tab();

		$this->end_controls_tabs();



		$this->end_controls_section();
	}

	protected function register_controls() {

        $this->register_query_builder_controls();
        $this->register_content_section_1();
		$this->register_style_section_1();
		$this->register_style_section_2();
	}

    protected function render(){
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
        $settings = $this->get_settings_for_display();
        $query = $this->get_query_result();
        if ( ! $query->found_posts ) {

            ?>
            <div class="nothing-show">
                <h2><?php esc_html_e('Nothing found!', THEME_NAME); ?></h2>
                <p><?php esc_html_e('It looks like nothing was found here!', THEME_NAME); ?></p>
            </div>
            <?php

            return;
        }
        if ( $query->have_posts() ) :
            echo '<div class="product-tabs">';
            echo '<div class="side-right">';
            echo '<div class="tab-btn-container tabs">';
			$index = 0;
            while ( $query->have_posts() ) :
				$query->the_post();
                $product_id = get_the_ID();
				$product = wc_get_product( $product_id );
				$product_title = get_the_title( $product->ID );
                $tab_id = 'tab' . ( $index + 1 );
                // Output tab button
                echo '<p class="tab-btn';
                echo ( $index === 0 ) ? ' active' : '';
                echo '" data-category="' . $tab_id . '" onclick="show_widgets.call(this, \'' . $tab_id . '\')">';
				echo  esc_html( $product_title ) ;
                echo '</p>';
                $index += 1;
            endwhile;

            echo '</div>'; // Close tabs
            echo '</div>';
            echo '<div class="side-left">';

			$index = 0;
			while ( $query->have_posts() ) :
				$query->the_post();
				$tab_id = 'tab' . ( $index + 1 );
                echo '<div class="content"';
                echo ( $index === 0 ) ? ' style="display: block;"' : '';
                echo ' id="' . $tab_id . '">';
				$template_id = $settings['posts_layout'];
				$template = show_template( $template_id );
				if ( $template_id ) {
					echo $template;
				}
                echo '</div>'; // Closing .content
				$index += 1;
            endwhile;
			echo '</div>'; // Close side-left
			echo '</div>'; // Close testimonials
        endif;
        wp_reset_postdata();
    }

}