<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_product_sale_price extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_woo_product_sale_price';
    }

    public function get_title() {
        return esc_html__('product sale price', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_product_sale_price';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_style_section_1() {
        $this->start_controls_section(
            'simple_price_style_section',
            [
                'label' => esc_html__( 'simple price', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control(
			'simpe-regular-price-align',
			[ 
				'label' => esc_html__( 'align', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'justify-content-end',
				'options' => [ 
					'justify-content-end' => esc_html__( 'left', THEME_NAME ),
					'justify-content-center' => esc_html__( 'center', THEME_NAME ),
					'justify-content-start' => esc_html__( 'right', THEME_NAME ),
				],
			]
		);

		$this->add_control(
			'simbol',
			[ 
				'label' => esc_html__( 'simbol', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);

		$this->add_control(
			'simpe-regular-price-sep',
			[ 
				'label' => esc_html__( 'simpe regular price', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_text_style('simpe-regular-price',  '.simpe-regular-price', $algin = false);
        
        $this->add_control(
		    'simple-regular-symbol',
		    [
			    'label'     => esc_html__( 'unit', THEME_NAME ),
			    'type'      => \Elementor\Controls_Manager::HEADING,
			    'separator' => 'before',
		    ]
	    );

        $this->register_text_style('simple-regular-symbol',  '.simple-regular-symbol', $algin = false);

		$this->add_control(
			'simpe-sale-price-sep',
			[ 
				'label' => esc_html__( 'simple sale price', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'simpe-sale-price', '.simpe-sale-price', $algin = false );

		$this->add_control(
			'simple-sale-symbol',
			[ 
				'label' => esc_html__( 'unit', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'simple-sale-symbol', '.simple-sale-symbol', $algin = false );

		$this->add_control(
			'simple-one-symbol',
			[ 
				'label' => esc_html__( 'one unit', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'simple-one-symbol', '.simple-one-symbol', $algin = false );

		$this->add_control(
			'simple-one-symbol-rotate',
			[ 
				'label' => esc_html__( 'rotate', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'default' => [ 
					'unit' => '%',
					'size' => -90,
				],
				'selectors' => [ 
					'{{WRAPPER}} .simple-one-symbol' => 'rotate: {{SIZE}}deg;',
				],
			]
		);

        $this->end_controls_section();

    }

	protected function register_style_section_2() {
		$this->start_controls_section(
			'variable_price_style_section',
			[ 
				'label' => esc_html__( 'variable price', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'variable-regular-price-align',
			[ 
				'label' => esc_html__( 'align', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'justify-content-end',
				'options' => [ 
					'justify-content-end' => esc_html__( 'left', THEME_NAME ),
					'justify-content-center' => esc_html__( 'center', THEME_NAME ),
					'justify-content-start' => esc_html__( 'right', THEME_NAME ),
				],
			]
		);

		$this->add_control(
			'variable-min-regular-price-sep',
			[ 
				'label' => esc_html__( 'variable min regular price', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'variable-min-regular-price', '.variable-min-regular-price', $algin = false );

		$this->add_control(
			'variable-min-regular-symbol',
			[ 
				'label' => esc_html__( 'unit', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'variable-min-regular-symbol', '.variable-min-regular-symbol', $algin = false );


		$this->add_control(
			'variable-max-regular-price-sep',
			[ 
				'label' => esc_html__( 'variable max regular price', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'variable-max-regular-price', '.variable-max-regular-price', $algin = false );

		$this->add_control(
			'variable-max-regular-symbol',
			[ 
				'label' => esc_html__( 'unit', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'variable-max-regular-symbol', '.variable-max-regular-symbol', $algin = false );

		$this->add_control(
			'variable-min-sale-price-sep',
			[ 
				'label' => esc_html__( 'variable min sale price', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'variable-min-sale-price', '.variable-min-sale-price', $algin = false );

		$this->add_control(
			'variable-min-sale-symbol',
			[ 
				'label' => esc_html__( 'unit', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'variable-min-sale-symbol', '.variable-min-sale-symbol', $algin = false );


		$this->add_control(
			'variable-max-sale-price-sep',
			[ 
				'label' => esc_html__( 'variable max sale price', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'variable-max-sale-price', '.variable-max-sale-price', $algin = false );

		$this->add_control(
			'variable-max-sale-symbol',
			[ 
				'label' => esc_html__( 'unit', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'variable-max-sale-symbol', '.variable-max-sale-symbol', $algin = false );


		$this->add_control(
			'variable-regular-sep',
			[ 
				'label' => esc_html__( 'regular separetor', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'variable-regular-sep', '.variable-regular-sep', $algin = false );

		$this->add_control(
			'variable-sale-sep',
			[ 
				'label' => esc_html__( 'sale separetor', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'variable-sale-sep', '.variable-sale-sep', $algin = false );
		$this->add_control(
			'variable-one-symbol',
			[ 
				'label' => esc_html__( 'one unit', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'variable-one-symbol', '.variable-one-symbol', $algin = false );

		$this->add_control(
			'variable-one-symbol-rotate',
			[ 
				'label' => esc_html__( 'rotate', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'default' => [ 
					'unit' => '%',
					'size' => -90,
				],
				'selectors' => [ 
					'{{WRAPPER}} .variable-one-symbol' => 'rotate: {{SIZE}}deg;',
				],
			]
		);

		$this->end_controls_section();

	}

	protected function register_style_section_3() {
		$this->start_controls_section(
			'grouped_price_style_section',
			[ 
				'label' => esc_html__( 'grouped price', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'grouped-regular-price-align',
			[ 
				'label' => esc_html__( 'align', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'justify-content-end',
				'options' => [ 
					'justify-content-end' => esc_html__( 'left', THEME_NAME ),
					'justify-content-center' => esc_html__( 'center', THEME_NAME ),
					'justify-content-start' => esc_html__( 'right', THEME_NAME ),
				],
			]
		);

		$this->add_control(
			'grouped-min-regular-price-sep',
			[ 
				'label' => esc_html__( 'grouped min regular price', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'grouped-min-regular-price', '.grouped-min-regular-price', $algin = false );

		$this->add_control(
			'grouped-min-regular-symbol',
			[ 
				'label' => esc_html__( 'unit', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'grouped-min-regular-symbol', '.grouped-min-regular-symbol', $algin = false );


		$this->add_control(
			'grouped-max-regular-price-sep',
			[ 
				'label' => esc_html__( 'grouped max regular price', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'grouped-max-regular-price', '.grouped-max-regular-price', $algin = false );

		$this->add_control(
			'grouped-max-regular-symbol',
			[ 
				'label' => esc_html__( 'unit', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'grouped-max-regular-symbol', '.grouped-max-regular-symbol', $algin = false );

		$this->add_control(
			'grouped-min-sale-price-sep',
			[ 
				'label' => esc_html__( 'grouped min sale price', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'grouped-min-sale-price', '.grouped-min-sale-price', $algin = false );

		$this->add_control(
			'grouped-min-sale-symbol',
			[ 
				'label' => esc_html__( 'unit', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'grouped-min-sale-symbol', '.grouped-min-sale-symbol', $algin = false );


		$this->add_control(
			'grouped-max-sale-price-sep',
			[ 
				'label' => esc_html__( 'grouped max sale price', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'grouped-max-sale-price', '.grouped-max-sale-price', $algin = false );

		$this->add_control(
			'grouped-max-sale-symbol',
			[ 
				'label' => esc_html__( 'unit', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'grouped-max-sale-symbol', '.grouped-max-sale-symbol', $algin = false );


		$this->add_control(
			'grouped-regular-sep',
			[ 
				'label' => esc_html__( 'regular separetor', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'grouped-regular-sep', '.grouped-regular-sep', $algin = false );

		$this->add_control(
			'grouped-sale-sep',
			[ 
				'label' => esc_html__( 'sale separetor', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'grouped-sale-sep', '.grouped-sale-sep', $algin = false );

		$this->add_control(
			'grouped-one-symbol',
			[ 
				'label' => esc_html__( 'one unit', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'grouped-one-symbol', '.grouped-one-symbol', $algin = false );

		$this->add_control(
			'grouped-one-symbol-rotate',
			[ 
				'label' => esc_html__( 'rotate', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'default' => [ 
					'unit' => '%',
					'size' => -90,
				],
				'selectors' => [ 
					'{{WRAPPER}} .grouped-one-symbol' => 'rotate: {{SIZE}}deg;',
				],
			]
		);

		$this->end_controls_section();

	}

	protected function register_style_section_4() {
		$this->start_controls_section(
			'free_price_style_section',
			[ 
				'label' => esc_html__( 'free', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_text_style( 'product-free', '.product-free' );

		$this->end_controls_section();

	}

	protected function register_controls() {

        $this->register_style_section_1();
        $this->register_style_section_2();
		$this->register_style_section_3();
		$this->register_style_section_4();
    }

	protected function render() {
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
		$settings = $this->get_settings_for_display();
		if ( $settings['simbol'] != '' ) {
			$simbol = $settings['simbol'];
		} else {
			$simbol = get_woocommerce_currency_symbol( '' );
		}
		if ( $this->theme_is_edit_mode() ) {
			?>
			<p>قیمت ساده</p>
			<div class="d-flex flex-row align-items-center">
				<div>
					<div class="d-flex flex-row <?php echo $settings['simpe-regular-price-align']; ?>">
						<div class="simpe-regular-price">
							<span class="woocommerce-Price-amount amount">
								<bdi>5،000،000&nbsp;<span class="woocommerce-Price-currencySymbol"><?php echo($simbol);?></span></bdi>
							</span>
						</div>
						<div class="simple-regular-symbol"><?php echo($simbol);?></div>
					</div>
					<div class="d-flex flex-row <?php echo $settings['simpe-regular-price-align']; ?>">
						<div class="simpe-sale-price">
							<span class="woocommerce-Price-amount amount">
								<bdi>3،000،000&nbsp;<span class="woocommerce-Price-currencySymbol"><?php echo($simbol);?></span></bdi>
							</span>
						</div>
						<div class="simple-sale-symbol"><?php echo($simbol);?></div>
					</div>
				</div>
				<div><div class="simple-one-symbol"><?php echo($simbol);?></div></div>
			</div>

			<p>قیمت متغیر</p>
			<div class="d-flex flex-row align-items-center">
				<div>
					<div class="d-flex flex-row <?php echo $settings['variable-regular-price-align']; ?>">
						<div class="d-flex flex-row">
							<div class="variable-min-regular-price">
								<span class="woocommerce-Price-amount amount">
									<bdi>100،000&nbsp;<span class="woocommerce-Price-currencySymbol"><?php echo($simbol);?></span></bdi>
								</span>
							</div>
							<div class="variable-min-regular-symbol"><?php echo($simbol);?></div>
						</div>
						<span class="variable-regular-sep"> - </span>
						<div class="d-flex flex-row">
							<div class="variable-max-regular-price">
								<span class="woocommerce-Price-amount amount">
									<bdi>200،000&nbsp;<span class="woocommerce-Price-currencySymbol"><?php echo($simbol);?></span></bdi>
								</span>
							</div>
							<div class="variable-max-regular-symbol"><?php echo($simbol);?></div>
						</div>
					</div>
					<div class="d-flex flex-row <?php echo $settings['variable-regular-price-align']; ?>">
						<div class="d-flex flex-row">
							<div class="variable-min-sale-price">
								<span class="woocommerce-Price-amount amount">
									<bdi>100،000&nbsp;<span class="woocommerce-Price-currencySymbol"><?php echo($simbol);?></span></bdi>
								</span>
							</div>
							<div class="variable-min-sale-symbol"><?php echo($simbol);?></div>
						</div>
						<span class="variable-sale-sep"> - </span>
						<div class="d-flex flex-row">
							<div class="variable-max-sale-price">
								<span class="woocommerce-Price-amount amount">
									<bdi>180،000&nbsp;<span class="woocommerce-Price-currencySymbol"><?php echo($simbol);?></span></bdi>
								</span>
							</div>
							<div class="variable-max-sale-symbol"><?php echo($simbol);?></div>
						</div>
					</div>
				</div>
				<div><div class="variable-one-symbol"><?php echo($simbol);?></div></div>
			</div>
			<p>قیمت گروهی</p>
			<div class="d-flex flex-row align-items-center">
				<div>
					<div class="d-flex flex-row <?php echo $settings['grouped-regular-price-align']; ?>">
						<div class="d-flex flex-row">
							<div class="grouped-min-regular-price">
								<span class="woocommerce-Price-amount amount">
									<bdi>100،000&nbsp;<span class="woocommerce-Price-currencySymbol"><?php echo($simbol);?></span></bdi>
								</span>
							</div>
							<div class="grouped-min-regular-symbol"><?php echo($simbol);?></div>
						</div>
						<span class="grouped-regular-sep"> - </span>
						<div class="d-flex flex-row">
							<div class="grouped-max-regular-price">
								<span class="woocommerce-Price-amount amount">
									<bdi>200،000&nbsp;<span class="woocommerce-Price-currencySymbol"><?php echo($simbol);?></span></bdi>
								</span>
							</div>
							<div class="grouped-max-regular-symbol"><?php echo($simbol);?></div>
						</div>
					</div>
					<div class="d-flex flex-row <?php echo $settings['grouped-regular-price-align']; ?>">
						<div class="d-flex flex-row">
							<div class="grouped-min-sale-price">
								<span class="woocommerce-Price-amount amount">
									<bdi>100،000&nbsp;<span class="woocommerce-Price-currencySymbol"><?php echo($simbol);?></span></bdi>
								</span>
							</div>
							<div class="grouped-min-sale-symbol"><?php echo($simbol);?></div>
						</div>
						<span class="grouped-sale-sep"> - </span>
						<div class="d-flex flex-row">
							<div class="grouped-max-sale-price">
								<span class="woocommerce-Price-amount amount">
									<bdi>180،000&nbsp;<span class="woocommerce-Price-currencySymbol"><?php echo($simbol);?></span></bdi>
								</span>
							</div>
							<div class="grouped-max-sale-symbol"><?php echo($simbol);?></div>
						</div>
					</div>
				</div>
				<div><div class="grouped-one-symbol"><?php echo($simbol);?></div></div>
			</div>
			
			<?php
			echo '<p class="product-free">' . __( 'Free', THEME_NAME ) . '</p>';

		} else {
			global $post;
			$product_id = get_the_ID();
			$product = wc_get_product( $product_id );
			
			if ( $product ) {

				if ( $product->is_type( 'simple' ) ) {
					$regular_price = $product->get_regular_price(); // Regular price
					$sale_price = $product->get_sale_price(); // Sale price (if applicable)
					if ($regular_price == '0' ) {
						echo '<p class="product-free">' . __( 'Free', THEME_NAME ) . '</p>';
					}
					elseif($sale_price == '' and $regular_price == ''){
						echo '<p class="product-free">' . __( 'Free', THEME_NAME ) . '</p>';
					}
					else{
						echo '<div class="d-flex flex-row align-items-center">';
							echo '<div>';
								if ( $regular_price != $sale_price and $sale_price != '') {
									echo '<div class="d-flex flex-row ' . $settings['simpe-regular-price-align'] . '">';
										echo '<div class="simpe-regular-price">' . wc_price( $regular_price ) . '</div>';
										echo '<div class="simple-regular-symbol">' . $simbol . '</div>';
									echo '</div>';
								}
								if($sale_price != ''){
									echo '<div class="d-flex flex-row ' . $settings['simpe-regular-price-align'] . '">';
										echo '<div class="simpe-sale-price">' . wc_price( $sale_price ) . '</div>';
										echo '<div class="simple-sale-symbol">' . $simbol . '</div>';
									echo '</div>';
								}
								else{
									echo '<div class="d-flex flex-row ' . $settings['simpe-regular-price-align'] . '">';
										echo '<div class="simpe-sale-price">' . wc_price( $regular_price ) . '</div>';
										echo '<div class="simple-sale-symbol">' . $simbol . '</div>';
									echo '</div>';
								}
							echo '</div>';
							echo '<div>';
								echo '<div class="simple-one-symbol">' . $simbol . '</div>';
							echo '</div>';

						echo '</div>';

					}
				}
				if ( $product->is_type( 'variable' ) ) {
					$regular_price = $product->get_regular_price(); // Regular price for the range
					$sale_price = $product->get_sale_price(); // Sale price for the range
					$price = $product->get_price(); // Active price (either the minimum regular or sale price)

					// If you need more details about each variation:
					if ( $product->is_type( 'variable' ) ) {
						$min_regular_price = $product->get_variation_regular_price( 'min', true );
						$max_regular_price = $product->get_variation_regular_price( 'max', true );

						// Get min and max sale prices.
						$min_sale_price = $product->get_variation_sale_price( 'min', true );
						$max_sale_price = $product->get_variation_sale_price( 'max', true );
					}
					if ($min_sale_price != '0' and $max_sale_price != '0' ) {
						echo '<div class="d-flex flex-row align-items-center">';
							echo '<div>';
								echo '<div class="d-flex flex-row ' . $settings['variable-regular-price-align'] . '">';
									echo '<div class="d-flex flex-row">';
										echo '<div class="variable-min-regular-price">' . wc_price( $min_regular_price ) . '</div>';
										echo '<div class="variable-min-regular-symbol">' . $simbol . '</div>';
									echo '</div>';
									echo '<span class="variable-regular-sep"> - </span>';
									echo '<div class="d-flex flex-row">';
										echo '<div class="variable-max-regular-price">' . wc_price( $max_regular_price ) . '</div>';
										echo '<div class="variable-max-regular-symbol">' . $simbol . '</div>';
									echo '</div>';
								echo '</div>';

								echo '<div class="d-flex flex-row ' . $settings['variable-regular-price-align'] . '">';
									echo '<div class="d-flex flex-row">';
										echo '<div class="variable-min-sale-price">' . wc_price( $min_sale_price ) . '</div>';
										echo '<div class="variable-min-sale-symbol">' . $simbol . '</div>';
									echo '</div>';
									echo '<span class="variable-sale-sep"> - </span>';
									echo '<div class="d-flex flex-row">';
										echo '<div class="variable-max-sale-price">' . wc_price( $max_sale_price ) . '</div>';
										echo '<div class="variable-max-sale-symbol">' . $simbol . '</div>';
									echo '</div>';
								echo '</div>';
							echo '</div>';
							echo '<div>';
								echo '<div class="variable-one-symbol">' . $simbol . '</div>';
							echo '</div>';

						echo '</div>';
					}
					else{
						echo '<p class="product-free">' . __( 'Free', THEME_NAME ) . '</p>';
					}

				}
				if ( $product->is_type( 'grouped' ) ) {
					$children = $product->get_children();
					$min_regular_price = PHP_INT_MAX;
					$max_regular_price = 0;
					$min_sale_price = PHP_INT_MAX;
					$max_sale_price = 0;

					foreach ( $children as $child_id ) {
						$child_product = wc_get_product( $child_id );

						// Get regular and sale prices for each child product.
						$regular_price = $child_product->get_regular_price();
						$sale_price = $child_product->get_sale_price();

						// Find the minimum regular price.
						if ( $regular_price < $min_regular_price ) {
							$min_regular_price = $regular_price;
						}

						// Find the maximum regular price.
						if ( $regular_price > $max_regular_price ) {
							$max_regular_price = $regular_price;
						}

						// Find the minimum sale price.
						if ( $sale_price < $min_sale_price && $sale_price !== '' ) {
							$min_sale_price = $sale_price;
						}

						// Find the maximum sale price.
						if ( $sale_price > $max_sale_price ) {
							$max_sale_price = $sale_price;
						}
					}
					if ($min_sale_price != '0' and $max_sale_price != '0' ) {
						echo '<div class="d-flex flex-row align-items-center">';
							echo '<div>';
								echo '<div class="d-flex flex-row ' . $settings['grouped-regular-price-align'] . '">';
									echo '<div class="d-flex flex-row">';
										echo '<div class="grouped-min-regular-price">' . wc_price( $min_regular_price ) . '</div>';
										echo '<div class="grouped-min-regular-symbol">' . $simbol . '</div>';
									echo '</div>';
									echo '<span class="grouped-regular-sep"> - </span>';
									echo '<div class="d-flex flex-row">';
										echo '<div class="grouped-max-regular-price">' . wc_price( $max_regular_price ) . '</div>';
										echo '<div class="grouped-max-regular-symbol">' . $simbol . '</div>';
									echo '</div>';
								echo '</div>';

								echo '<div class="d-flex flex-row ' . $settings['grouped-regular-price-align'] . '">';
									echo '<div class="d-flex flex-row">';
										echo '<div class="grouped-min-sale-price">' . wc_price( $min_sale_price ) . '</div>';
										echo '<div class="grouped-min-sale-symbol">' . $simbol . '</div>';
									echo '</div>';
									echo '<span class="grouped-sale-sep"> - </span>';
									echo '<div class="d-flex flex-row">';
										echo '<div class="grouped-max-sale-price">' . wc_price( $max_sale_price ) . '</div>';
										echo '<div class="grouped-max-sale-symbol">' . $simbol . '</div>';
									echo '</div>';
								echo '</div>';
							echo '</div>';
							echo '<div>';
								echo '<div class="grouped-one-symbol">' . $simbol . '</div>';
							echo '</div>';

						echo '</div>';
					}
					else{
						echo '<p class="product-free">' . __( 'Free', THEME_NAME ) . '</p>';
					}
				}
			}
		}
	}


}