<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_product_rating_star extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_woo_product_rating_star';
    }

    public function get_title() {
        return esc_html__('product star rating', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_product_rating_star';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_style_section_1() {
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__( 'star rating percentage', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->register_text_style('body-score',  '.body-score', $align = false);

		$this->add_control(
			'score',
			[ 
				'label' => esc_html__( 'score', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'score', '.score', $align = false );

        $this->end_controls_section();

    } 

    protected function register_controls() {

        $this->register_style_section_1();
    }

    protected function render() {
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
        $settings = $this->get_settings_for_display();

        if ($this->theme_is_edit_mode()) {
            $first_product_id = get_posts(array(
                'post_type'      => 'product',
                'posts_per_page' => 1,
                'orderby'        => 'ID',
                'order'          => 'ASC',
                'fields'         => 'ids',
            ));
            $first_product = wc_get_product($first_product_id[0]);
            $average_rating = $first_product->get_average_rating();
            $star_html = $this->generate_star_rating($average_rating);
            echo '<div class="star-rating">' . $star_html . '</div>';
        } else {
			global $post;
			$product_id = get_the_ID();
            $product = wc_get_product( $product_id );
            if ($product) {
                $average_rating = wc_get_product($product)->get_average_rating();
                $star_html = $this->generate_star_rating($average_rating);
                echo '<div class="star-rating">' . $star_html . '</div>';
            }
        }
    }

    protected function generate_star_rating($rating) {
        $star_html = '';
        $rounded_rating = round($rating, 1);
        for ($i = 1; $i <= $rounded_rating; $i++) {
            $star_html .= '<i class="isax isax-star1-path1 score"></i>';
        }

        for ($i = $rounded_rating + 1; $i <= 5; $i++) {
            $star_html .= '<i class="isax isax-star1-path1 body-score"></i>';
        }

        return $star_html;
    }

}