<?php


use handler\basic_element;
use handler\video;


if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_product_attr extends \Elementor\Widget_Base {

    use basic_element;
	use video;


	public function get_name() {
        return 'ar_woo_product_attr';
    }

    public function get_title() {
        return esc_html__('product attributes', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_product_attr';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function get_attributes() {
        $attributes = array();
        if (option_value('page-single-product-attribute')) {
            foreach (option_value('page-single-product-attribute') as $index => $item) {
                $attributes['product_' . $index] = esc_html($item);
            }
        }
        return $attributes;
    }

    protected function register_content_section_1() {
        $this->start_controls_section(
            'section_layout',
            [
                'label' => esc_html__( 'Layout', THEME_NAME ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'attr',
			[
				'label'   => esc_html__( 'Posts attribute', THEME_NAME ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'options' => $this->get_attributes(),
				'default' => 'post',
			]
		);

        $this->end_controls_section();

    }
    protected function register_style_section_1() {
        $this->start_controls_section(
            'product_style_section',
            [
                'label' => esc_html__( 'category', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('product_categories',  '.product-attribute');

        $this->end_controls_section();

    }

	protected function register_style_section_2() {
		$this->start_controls_section(
			'product_style_image_section',
			[ 
				'label' => esc_html__( 'image', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_text_style( 'product_image', '.product-attribute img' );

		$this->end_controls_section();

	}

	protected function register_controls() {

        $this->register_content_section_1();
        $this->register_style_section_1();
		$this->register_style_section_2();

		$this->register_style_video_controls();

		$this->register_video_controls();
    }

    protected function render() {
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
        $settings = $this->get_settings_for_display();
        $selected_attribute_key = $settings['attr'];
		foreach ( option_value( 'page-single-product-attribute' ) as $index => $item ) {
			if ( $selected_attribute_key == 'product_' . $index ) {
                $kind = option_value( 'product-attribute-kind-' . esc_html( $item ));
				break;
            }
        }
        $selected_attribute_value = '';

        if ($this->theme_is_edit_mode()) {
            $first_product_id = get_posts(array(
                'post_type'      => 'product',
                'posts_per_page' => 1,
                'orderby'        => 'ID',
                'order'          => 'ASC',
                'fields'         => 'ids',
            ));
            if (!empty($first_product_id)) {
                $selected_attribute_value = get_post_meta($first_product_id[0], $selected_attribute_key, true);
            }
        } else {
            if (!empty($selected_attribute_key)) {
                $selected_attribute_value = get_post_meta(get_the_ID(), $selected_attribute_key, true);
            }
        }

        echo '<div class="product-attribute">';
		if ( $kind == 'text' ) {
			echo esc_html( $selected_attribute_value );
		}
		if ( $kind == 'image' ) {
            echo '<img src="'.$selected_attribute_value .'">';
		}
        if ( $kind == 'video' ) {
			$plyr_id = $this->get_id();
			$video = $selected_attribute_value;
			if ( has_post_thumbnail() ) {
				$post_thumbnail_id = get_post_thumbnail_id();
				$poster = wp_get_attachment_image_url( $post_thumbnail_id, 'full' );
			}else{
                $poster = NULL;
                
            }
			$this->render_video( $plyr_id, $video, $poster );
            // echo '<video src="'.$selected_attribute_value.'">';
        }
        if ( $kind == 'audio' ) {
            ?>
            <audio class="plyr" controls>
                <source src="<?php echo esc_url( $selected_attribute_value ); ?>" type="audio/mpeg">
                Your browser does not support the audio element.
            </audio>
            <?php
        }
        if ( $kind == 'file' ) {
            echo '<a href="'.$selected_attribute_value.'">' . __('download', THEME_NAME) . '</a>';
        }
        echo '</div>';
    }

}