<?php

use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_messages extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_woo_messages';
    }

    public function get_title() {
        return esc_html__('messages', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_messages';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_style_section_1() {
        $this->start_controls_section('section_style_image',
		    [
			    'label' => esc_html__('style', THEME_NAME),
			    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
		    ]
	    );
		$this->add_control(
			'sep-body',
			[ 
				'label' => esc_html__( 'body', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_container_style( 'body', '.woocommerce-message' );

		$this->add_control(
			'sep-text',
			[ 
				'label' => esc_html__( 'text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'text', '.woocommerce-message' );

		$this->add_control(
			'sep-btn',
			[ 
				'label' => esc_html__( 'button', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'button', '.wc-forward', $align = false );

		$this->add_control(
			'sep-icon',
			[ 
				'label' => esc_html__( 'icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'icon', '.woocommerce-message::before ', $align = false );

        $this->end_controls_section();
    } 


    protected function register_controls() {

        $this->register_style_section_1();
    }

    protected function render(){
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
        $settings = $this->get_settings_for_display();
		if ( $this->theme_is_edit_mode() ) {
            ?>
            <div class="woocommerce-message" role="alert">
                <a href="#" tabindex="1" class="button wc-forward">مشاهده سبد خرید</a>
                محصول به سبد خرید شما اضافه شد.
                </div>

            <?php
        }
        else{
            echo \WC_Shortcodes::shop_messages();
        }
    }
}