<?php

use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_checkout_billing extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_woo_checkout_billing';
    }

    public function get_title() {
        return esc_html__('cart checkout billing', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_checkout_billing';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }
    
    protected function register_style_section_1() {
        $this->start_controls_section(
            'woocommerce-title',
            [
                'label' => __( 'title', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('title',  'h3');
        
        $this->end_controls_section();
    }
    protected function register_style_section_2() {
        $this->start_controls_section(
            'woocommerce-coupon-form-input',
            [
                'label' => __( 'form input', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('woocommerce-checkout-form-input',  'input');

        $this->add_control(
			'woocommerce-coupon-form-label',
			[
				'label' => esc_html__( 'labels', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_text_style('woocommerce-checkout-form-label',  'label', $align=false);
        
        $this->end_controls_section();
    } 
    
    protected function register_style_section_3() {
        $this->start_controls_section(
            'button',
		    [
			    'label' => esc_html__('button ', THEME_NAME),
			    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
		    ]
	    );

        $this->register_text_style('button',  '.checkout-button', $align=false);
        $this->end_controls_section();
    }


    protected function register_controls() {

        $this->register_style_section_1();
        $this->register_style_section_2();
        $this->register_style_section_3();
    }

    protected function render(){
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
        \WC_Checkout::instance()->checkout_form_billing();      
	}
}