<?php

use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_cart extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_woo_cart';
    }

    public function get_title() {
        return esc_html__('cart', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_cart';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_style_section_1() {
        $this->start_controls_section(
            'cart_table',
		    [
			    'label' => esc_html__('table', THEME_NAME),
			    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
		    ]
	    );

        $this->register_table_style('cart_table', '.cart');
        $this->end_controls_section();
    } 

    protected function register_style_section_2() {
        $this->start_controls_section(
            'cart_image',
		    [
			    'label' => esc_html__('image', THEME_NAME),
			    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
		    ]
	    );
        $this->register_container_style('product_image_back',  '.product-image');

        $this->add_control(
		    'image',
		    [
			    'label' => esc_html__( 'image', THEME_NAME ),
			    'type' => \Elementor\Controls_Manager::HEADING,
			    'separator' => 'before',
		    ]
	    );

        $this->register_image_style('product_img', '.product-image img');
        $this->end_controls_section();
    }
    
    protected function register_style_section_3() {
        $this->start_controls_section(
            'cart_name',
		    [
			    'label' => esc_html__('product name', THEME_NAME),
			    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
		    ]
	    );
		$this->register_container_style( 'product_name_back', '.product-name' );

		$this->add_control(
			'image',
			[ 
				'label' => esc_html__( 'image', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_text_style('theme_product_title',  '.product-name a', $align=false);
        $this->end_controls_section();
    }

    protected function register_style_section_4() {
        $this->start_controls_section(
            'cart_price',
		    [
			    'label' => esc_html__('product price', THEME_NAME),
			    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
		    ]
	    );
        $this->register_container_style('product_price_back',  '.product-price');

        $this->add_control(
		    'amount',
		    [
			    'label' => esc_html__( 'amount', THEME_NAME ),
			    'type' => \Elementor\Controls_Manager::HEADING,
			    'separator' => 'before',
		    ]
	    );

        $this->register_text_style('theme_product_price',  '.product-price .woocommerce-Price-amount', $align=false);

        $this->add_control(
		    'label',
		    [
			    'label' => esc_html__( 'label', THEME_NAME ),
			    'type' => \Elementor\Controls_Manager::HEADING,
			    'separator' => 'before',
		    ]
	    );

        $this->register_text_style('theme_product_price_lable',  '.price-label', $align=false);

        $this->add_control(
		    'currencySymbol',
		    [
			    'label' => esc_html__( 'currency Symbol', THEME_NAME ),
			    'type' => \Elementor\Controls_Manager::HEADING,
			    'separator' => 'before',
		    ]
	    );

        $this->register_text_style('theme_product_price_currencySymbol',  '.product-price .woocommerce-Price-currencySymbol', $align=false);

        $this->end_controls_section();
    }

    protected function register_style_section_5() {
        $this->start_controls_section(
            'cart_quantity',
            [
                'label' => esc_html__( 'quantity', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_container_style('product_quantity_back',  '.product-quantity');
        $this->register_container_style('theme_product_quantity',  '.qty');

        $this->end_controls_section();

    } 

    protected function register_style_section_6() {
        $this->start_controls_section(
            'cart_sub_price',
            [
                'label' => esc_html__( 'sub price', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->register_container_style('product_subtotal_back',  '.product-subtotal');

        $this->add_control(
		    'amount_price',
		    [
			    'label' => esc_html__( 'amount', THEME_NAME ),
			    'type' => \Elementor\Controls_Manager::HEADING,
			    'separator' => 'before',
		    ]
	    );


        $this->register_text_style('theme_product_sub_price',  '.product-subtotal .woocommerce-Price-amount', $align=false);

        $this->add_control(
		    'total_label_price',
		    [
			    'label' => esc_html__( 'label', THEME_NAME ),
			    'type' => \Elementor\Controls_Manager::HEADING,
			    'separator' => 'before',
		    ]
	    );


        $this->register_text_style('theme_product_sub_price_lable',  '.total-label', $align=false);

        $this->add_control(
		    'currencySymbol_total',
		    [
			    'label' => esc_html__( 'currency Symbol', THEME_NAME ),
			    'type' => \Elementor\Controls_Manager::HEADING,
			    'separator' => 'before',
		    ]
	    );

        $this->register_text_style('theme_product_price_currencySymbol_total',  '.product-subtotal .woocommerce-Price-currencySymbol', $align=false);
        $this->end_controls_section();

    }
    
    protected function register_style_section_7() {
        $this->start_controls_section(
            'cart_button',
            [
                'label' => esc_html__( 'button', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('button',  '.cart-btn' , $align=false);
        $this->end_controls_section();

    }

    protected function register_style_section_8() {
        $this->start_controls_section(
            'remove_icon',
            [
                'label' => esc_html__( 'remove icon', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->register_container_style('product_remove_back',  '.product-remove');
        $this->register_text_style('remove_icon_text',  '.remove' , $align=false);
        $this->end_controls_section();

    }

    
    protected function register_style_section_9() {
        $this->start_controls_section(
            'cart_empty',
            [
                'label' => esc_html__( 'cart empty', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->register_text_style('empty',  '.empty');
        $this->end_controls_section();

    }

	protected function register_style_section_10() {
		$this->start_controls_section( 
            'section_style_message',
			[ 
				'label' => esc_html__( 'message', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'message-sep-body',
			[ 
				'label' => esc_html__( 'body', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_container_style( 'woocommerce-message-body', '.woocommerce-notices-wrapper .woocommerce-message' );

		$this->add_control(
			'message-sep-text',
			[ 
				'label' => esc_html__( 'text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'woocommerce-message-text', '.woocommerce-notices-wrapper .woocommerce-message' );

		$this->add_control(
			'message-sep-icon',
			[ 
				'label' => esc_html__( 'icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'woocommerce-message-icon', '.woocommerce-notices-wrapper .woocommerce-message::before ', $align = false );

		$this->end_controls_section();
	}

	protected function register_controls() {

        $this->register_style_section_1();
        $this->register_style_section_2();
        $this->register_style_section_3();
        $this->register_style_section_4();
        $this->register_style_section_5();
        $this->register_style_section_6();
        $this->register_style_section_7();
        $this->register_style_section_8();
        $this->register_style_section_9();
		$this->register_style_section_10();
    }

    protected function render(){
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
        if ( $this->theme_is_edit_mode()) {
            
            $first_product_id = get_posts( array(
                'post_type'      => 'product',
                'posts_per_page' => 1,
                'orderby'        => 'ID',
                'order'          => 'ASC',
                'fields'         => 'ids',
            ) );
            $first_product = wc_get_product( $first_product_id[0] );
            $product_image_id = $first_product->get_image_id();
            ?>
            <div class="woocommerce-notices-wrapper">
                <div class="woocommerce-message" role="alert">
                    “برند سازی” حذف شد.
                    <a class="restore-item">بازگشت؟</a>
                </div>
            </div>

            <form class="woocommerce-cart-form" action="<?php echo esc_url( wc_get_cart_url() ); ?>" method="post">
                <table class="shop_table shop_table_responsive cart woocommerce-cart-form__contents" cellspacing="0">
                    <thead>
                        <tr>
                            <th class="product-image"><?php esc_html_e( 'Product', THEME_NAME ); ?></th>
                            <th class="product-name"></th>
                            <th class="product-price"><?php esc_html_e( 'Price', THEME_NAME ); ?></th>
                            <th class="product-quantity"><?php esc_html_e( 'Quantity', THEME_NAME ); ?></th>
                            <th class="product-subtotal"><?php esc_html_e( 'Subtotal', THEME_NAME ); ?></th>
                            <th class="product-remove"><span class="screen-reader-text"><?php esc_html_e( 'Remove item', THEME_NAME ); ?></span></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr class="woocommerce-cart-form__cart-item">
                            <td class="product-remove">
                                <a class="remove">×</a>
                            </td>

                            <td class="product-image">
                                <?php
                                    $product_image_url = wp_get_attachment_image_src( $product_image_id, 'full' );
                                    $product_title = $first_product->get_name();
                                    echo '<img  src="' . esc_url( $product_image_url[0] ) . '" alt="' . esc_attr( $first_product->get_name() ) . '" class="theme-product-image" />';
                                ?>
                            </td>
                            <td class="product-name">
                                <?php
									echo '<a>' . esc_html( $product_title ) . '</a>';
									?>
                            </td>
                            <td class="product-price">
                                <p class="price-label"><?php esc_html_e( 'price:', THEME_NAME ); ?><br></p>
                                <div class="woocommerce-Price-amount">
                                    10000
                                    <span class="woocommerce-Price-currencySymbol">تومان</span>
                                </div>
                            </td>

                            <td class="product-quantity">
                                <div class="quantity">
                                    <label class="screen-reader-text" for="quantity_662ac668762ac">دوره تارگتینگ عدد</label>
                                    <button type="button" class="plus">+</button>
                                    <input type="number" class="input-text qty text" name="cart[64a08e5f1e6c39faeb90108c430eb120][qty]" value="2" aria-label="تعداد محصول" size="4" min="0" max="" step="1" placeholder="" inputmode="numeric" autocomplete="off">
                                    <button type="button" class="minus">-</button>
                                </div>
                            </td>

                            <td class="product-subtotal">
                                <p class="total-label"><?php esc_html_e( 'total:', THEME_NAME ); ?><br></p>
                                <div class="woocommerce-Price-amount">
                                    30000
                                    <span class="woocommerce-Price-currencySymbol">تومان</span>
                                </div>
                            </td>

                        </tr>

                        <tr class="woocommerce-cart-form__cart-item">
                            <td class="product-remove">
                                <a class="remove">×</a>
                            </td>
                           <td class="product-image">
                            <?php
								$product_image_url = wp_get_attachment_image_src( $product_image_id, 'full' );
								$product_title = $first_product->get_name();
								echo '<img  src="' . esc_url( $product_image_url[0] ) . '" alt="' . esc_attr( $first_product->get_name() ) . '" class="theme-product-image" />';
								?>
                            </td>
                            <td class="product-name">
                                <?php
                                echo '<a>' . esc_html( $product_title ) . '</a>';
                                ?>
                            </td>
                            <td class="product-price">
                                <p class="price-label"><?php esc_html_e( 'price:', THEME_NAME ); ?><br></p>
                                <div class="woocommerce-Price-amount">
                                    10000
                                    <span class="woocommerce-Price-currencySymbol">تومان</span>
                                </div>
                            </td>

                            <td class="product-quantity">
                                <div class="quantity">
                                    <label class="screen-reader-text" for="quantity_662ac668762ac">دوره تارگتینگ عدد</label>
                                    <button type="button" class="plus">+</button>
                                    <input type="number" class="input-text qty text" name="cart[64a08e5f1e6c39faeb90108c430eb120][qty]" value="2" aria-label="تعداد محصول" size="4" min="0" max="" step="1" placeholder="" inputmode="numeric" autocomplete="off">
                                    <button type="button" class="minus">-</button>
                                </div>
                            </td>

                            <td class="product-subtotal">
                                <p class="total-label"><?php esc_html_e( 'total:', THEME_NAME ); ?><br></p>
                                <div class="woocommerce-Price-amount">
                                    30000
                                    <span class="woocommerce-Price-currencySymbol">تومان</span>
                                </div>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <button type="submit" class="cart-btn button" name="update_cart" ><?php esc_html_e( 'Update cart', THEME_NAME ); ?></button>
            </form>
            <?php
        }
        else{
            if ( WC()->cart->is_empty() ) {
                echo '<p class="empty">' . esc_html__( 'cart is empty', THEME_NAME ) . '</p>';
            }
            else{
                do_action( 'woocommerce_before_cart' ); ?>
                <form class="woocommerce-cart-form" action="<?php echo esc_url( wc_get_cart_url() ); ?>" method="post">
                    <?php do_action( 'woocommerce_before_cart_table' ); ?>

                            <table class="shop_table shop_table_responsive cart woocommerce-cart-form__contents" cellspacing="0">
                                <thead>
                                    <tr>
                                        <th class="product-remove"><span class="screen-reader-text"><?php esc_html_e( 'Remove item', THEME_NAME ); ?></span></th>
                                        <th class="product-image"><?php esc_html_e( 'Product', THEME_NAME ); ?></th>
                                        <th class="product-name"><?php esc_html_e( '', THEME_NAME ); ?></th>
                                        <th class="product-price"><?php esc_html_e( 'Price', THEME_NAME ); ?></th>
                                        <th class="product-quantity"><?php esc_html_e( 'Quantity', THEME_NAME ); ?></th>
                                        <th class="product-subtotal"><?php esc_html_e( 'Subtotal', THEME_NAME ); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php do_action( 'woocommerce_before_cart_contents' ); ?>

                                    <?php
                                    foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
                                        $_product   = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
                                        $product_id = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );
                                        $product_name = apply_filters( 'woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key );

                                        if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
                                            $product_permalink = apply_filters( 'woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink( $cart_item ) : '', $cart_item, $cart_item_key );
                                            ?>
                                            <tr class="woocommerce-cart-form__cart-item <?php echo esc_attr( apply_filters( 'woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key ) ); ?>">
                                            
                                            <td class="product-remove">
                                                <?php
													echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
														'woocommerce_cart_item_remove_link',
														sprintf(
															'<a href="%s" class="remove" aria-label="%s" data-product_id="%s" data-product_sku="%s">&times;</a>',
															esc_url( wc_get_cart_remove_url( $cart_item_key ) ),
															/* translators: %s is the product name */
															esc_attr( sprintf( __( 'Remove %s from cart', THEME_NAME ), wp_strip_all_tags( $product_name ) ) ),
															esc_attr( $product_id ),
															esc_attr( $_product->get_sku() )
														),
														$cart_item_key
													);
													?>
                                            </td>

                                            <td class="product-image" data-title="<?php esc_attr_e( 'Product', THEME_NAME ); ?>">
                                                <?php
                                                $thumbnail = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );

                                                if ( ! $product_permalink ) {
                                                    echo $thumbnail; // PHPCS: XSS ok.
                                                } else {
                                                    printf( '<a href="%s">%s</a>', esc_url( $product_permalink ), $thumbnail ); // PHPCS: XSS ok.
                                                }
                                                ?>
                                                </td>
                                                <td class="product-name" data-title="<?php esc_attr_e( 'Product', THEME_NAME ); ?>">
                                                <?php
                                                if ( ! $product_permalink ) {
                                                    echo wp_kses_post( $product_name . '&nbsp;' );
                                                } else {
                                                    /**
                                                     * This filter is documented above.
                                                     *
                                                     * @since 2.1.0
                                                     */
                                                    echo wp_kses_post( apply_filters( 'woocommerce_cart_item_name', sprintf( '<a href="%s">%s</a>', esc_url( $product_permalink ), $_product->get_name() ), $cart_item, $cart_item_key ) );
                                                }

                                                do_action( 'woocommerce_after_cart_item_name', $cart_item, $cart_item_key );

                                                // Meta data.
                                                echo wc_get_formatted_cart_item_data( $cart_item ); // PHPCS: XSS ok.

                                                // Backorder notification.
                                                if ( $_product->backorders_require_notification() && $_product->is_on_backorder( $cart_item['quantity'] ) ) {
                                                    echo wp_kses_post( apply_filters( 'woocommerce_cart_item_backorder_notification', '<p class="backorder_notification">' . esc_html__( 'Available on backorder', THEME_NAME ) . '</p>', $product_id ) );
                                                }
                                                ?>
                                                </td>

                                                <td class="product-price" data-title="<?php esc_attr_e( 'Price', THEME_NAME ); ?>">
                                                    <p class="price-label"><?php esc_html_e( 'price:', THEME_NAME ); ?><br></p>
                                                    <?php
                                                        echo apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key ); // PHPCS: XSS ok.
                                                    ?>
                                                </td>

                                                <td class="product-quantity" data-title="<?php esc_attr_e( 'Quantity', THEME_NAME ); ?>">

                                                <?php
                                                if ( $_product->is_sold_individually() ) {
                                                    $min_quantity = 1;
                                                    $max_quantity = 1;
                                                } else {
                                                    $min_quantity = 0;
                                                    $max_quantity = $_product->get_max_purchase_quantity();
                                                }

                                                $product_quantity = woocommerce_quantity_input(
                                                    array(
                                                        'input_name'   => "cart[{$cart_item_key}][qty]",
                                                        'input_value'  => $cart_item['quantity'],
                                                        'max_value'    => $max_quantity,
                                                        'min_value'    => $min_quantity,
                                                        'product_name' => $product_name,
                                                    ),
                                                    $_product,
                                                    false
                                                );

                                                echo apply_filters( 'woocommerce_cart_item_quantity', $product_quantity, $cart_item_key, $cart_item ); // PHPCS: XSS ok.
                                                ?>
                                                </td>

                                                <td class="product-subtotal" data-title="<?php esc_attr_e( 'Subtotal', THEME_NAME ); ?>">
                                                    <p class="total-label"><?php esc_html_e( 'total:', THEME_NAME ); ?><br></p>
                                                    <?php
                                                        echo apply_filters( 'woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal( $_product, $cart_item['quantity'] ), $cart_item, $cart_item_key ); // PHPCS: XSS ok.
                                                    ?>
                                                </td>

                                            </tr>
                                            <?php
                                        }
                                    }
                                    ?>

                                    <?php do_action( 'woocommerce_cart_contents' ); ?>

                                    <tr>
                                        <td colspan="6" class="actions">
                                            <button type="submit" class="cart-btn button<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>" name="update_cart" value="<?php esc_attr_e( 'Update cart', THEME_NAME ); ?>"><?php esc_html_e( 'Update cart', THEME_NAME ); ?></button>

                                            <?php do_action( 'woocommerce_cart_actions' ); ?>

                                            <?php wp_nonce_field( 'woocommerce-cart', 'woocommerce-cart-nonce' ); ?>
                                        </td>
                                    </tr>
                        </tbody>
                    </table>
                </form>
                <script>
                    jQuery(document).ready(function($) {
                        $(document).on('click', '.product-remove a.remove', function(e) {
                            e.preventDefault();
                            var cartRemoveLink = $(this).attr('href');

                            // Perform AJAX request
                            $.get(cartRemoveLink, function() {
                                // Reload the page after the item is removed
                                location.reload();
                            });
                        });
                    });
                </script>
            <?php
            }
        }        
	}
}