<?php

use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_services extends \Elementor\Widget_Base {

    use basic_element;

    public function get_name() {
        return 'ar_services';
    }

    public function get_title() {
        return esc_html__('services', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_services';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_content_section_1() {

        $this->start_controls_section(
            'section_layout',
            [
                'label' => esc_html__( 'content', THEME_NAME ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

		$this->add_control(
			'top-icon',
			[ 
				'label' => __( 'top icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::ICONS,
			]
		);

		$this->add_control(
			'top-title',
			[ 
				'label' => __( 'top title', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'title',
			[ 
				'label' => __( 'title', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);

		$repeater->add_control(
			'title-icon',
			[ 
				'label' => __( 'title icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::ICONS,
			]
		);

		$repeater->add_control(
			'content-title',
			[ 
				'label' => __( 'content title', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);

		$repeater->add_control(
			'content-icon',
			[ 
				'label' => __( 'content icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::ICONS,
			]
		);

		$repeater->add_control(
			'content-body',
			[ 
				'label' => __( 'body', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
			]
		);

		$repeater->add_control(
			'first-btn-title',
			[ 
				'label' => __( 'first btn title', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);

		$repeater->add_control(
			'first-btn-icon',
			[ 
				'label' => __( 'first btn icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::ICONS,
			]
		);

		$repeater->add_control(
			'first-btn-link',
			[ 
				'label' => esc_html__( 'first btn link', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::URL,
				'options' => [ 'url', 'is_external', 'nofollow' ],
			]
		);

		$repeater->add_control(
			'sec-btn-title',
			[ 
				'label' => __( 'sec btn title', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);

		$repeater->add_control(
			'sec-btn-icon',
			[ 
				'label' => __( 'sec btn icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::ICONS,
			]
		);

		$repeater->add_control(
			'sec-btn-link',
			[ 
				'label' => esc_html__( 'sec btn link', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::URL,
				'options' => [ 'url', 'is_external', 'nofollow' ],
			]
		);

		$this->add_control(
			'contents',
			[ 
				'label' => __( 'contents', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [],
				'title_field' => '{{{ title }}}',
			]
		);

        $this->end_controls_section();

    }

	protected function register_style_section_1() {
		$this->start_controls_section(
			'panels_style_section',
			[ 
				'label' => esc_html__( 'panels', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'container',
			[ 
				'label' => esc_html__( 'container', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_container_style( 'product-tabs', '.product-tabs' );

		$this->add_control(
			'side-right',
			[ 
				'label' => esc_html__( 'side right', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_container_style( 'side-right', '.side-right' );

		$this->add_control(
			'items',
			[ 
				'label' => esc_html__( 'items', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_container_style( 'side-right-items', '.tab-btn-container' );

		$this->add_control(
			'side-left',
			[ 
				'label' => esc_html__( 'content', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_container_style( 'side-left', '.side-left' );

		$this->end_controls_section();
	}

	protected function register_style_section_2() {
		$this->start_controls_section(
			'titles_style_section',
			[ 
				'label' => esc_html__( 'title', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'top-icon-sep',
			[ 
				'label' => esc_html__( 'item icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);
		
		$this->register_text_style( 'top-icon', '.top-icon i', $align = false );

		$this->add_control(
			'top-title-sep',
			[ 
				'label' => esc_html__( 'top title', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'top-title', '.top-title', $align = false );


		$this->end_controls_section();
	}

	protected function register_style_section_3() {
		$this->start_controls_section(
			'items_style_section',
			[ 
				'label' => esc_html__( 'items', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->start_controls_tabs(
			'title_style_tabs'
		);

		$this->start_controls_tab(
			'title_style_normal_tab',
			[ 
				'label' => esc_html__( 'Normal', THEME_NAME ),
			]
		);

		$this->register_text_style( 'title_wrapper', '.tab-btn', $align = false );

		$this->add_control(
			'item-icon-normal',
			[ 
				'label' => esc_html__( 'item icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'item-icon-normal', '.tab-btn i', $align = false );

		$this->end_controls_tab();

		$this->start_controls_tab(
			'title_style_hover_tab',
			[ 
				'label' => esc_html__( 'Hover', THEME_NAME ),
			]
		);

		$this->register_text_style( 'title_wrapper_hover', '.tab-btn:hover', $align = false );

		$this->add_control(
			'item-icon-hover',
			[ 
				'label' => esc_html__( 'item icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'item-icon-hover', '.tab-btn:hover i', $align = false );

		$this->end_controls_tab();

		$this->start_controls_tab(
			'title_style_active_tab',
			[ 
				'label' => esc_html__( 'active', THEME_NAME ),
			]
		);

		$this->register_text_style( 'title_wrapper_active', '.tab-btn.active', $align = false );

		$this->add_control(
			'item-icon-active',
			[ 
				'label' => esc_html__( 'item icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'item-icon-active', '.tab-btn.active i', $align = false );

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();
	}

	protected function register_style_section_4() {
		$this->start_controls_section(
			'content_style_section',
			[ 
				'label' => esc_html__( 'content', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'item-content-icon-sep',
			[ 
				'label' => esc_html__( 'content icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'item-content-icon', '.content-icon', $align = false );

		$this->add_control(
			'item-title-sep',
			[ 
				'label' => esc_html__( 'title', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'item-content-title', '.content-title', $align = false );

		$this->add_control(
			'item-body-sep',
			[ 
				'label' => esc_html__( 'body', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'item-content-body', '.content-body' );


		$this->add_control(
			'item-first-btn-sep',
			[ 
				'label' => esc_html__( 'first btn', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'item-first-btn', '.first-btn-link', $align = false );

		$this->add_control(
			'item-first-btn-icon-sep',
			[ 
				'label' => esc_html__( 'first btn icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'item-first-btn-icon', '.first-btn-icon i', $align = false );

		$this->add_control(
			'item-sec-btn-sep',
			[ 
				'label' => esc_html__( 'sec btn', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'item-sec-btn', '.sec-btn-link', $align = false );

		$this->add_control(
			'item-sec-btn-icon-sep',
			[ 
				'label' => esc_html__( 'sec btn icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'item-sec-btn-icon', '.sec-btn-icon i', $align = false);

		$this->end_controls_section();
	}

	protected function register_controls() {

        $this->register_content_section_1();
		$this->register_style_section_1();
		$this->register_style_section_2();
		$this->register_style_section_3();
		$this->register_style_section_4();
	}

    protected function render(){
        $settings = $this->get_settings_for_display();
		
        if ( $settings['contents'] ) :
            echo '<div class="product-tabs">';
            echo '<div class="side-right">';
			echo '<div class="top-icon d-flex align-items-center justify-content-center">';
			\Elementor\Icons_Manager::render_icon( $settings['top-icon'], [ 'aria-hidden' => 'true' ] );
			echo ' </div>';
			echo '<div class="top-title">' . ( $settings['top-title'] ) . '</div>';

            echo '<div class="tab-btn-container tabs">';
			$index = 0;
			foreach ( $settings['contents'] as $item ) {
				$tab_id = 'tab' . ( $index + 1 );
				// Output tab button
				echo '<div class="tab-btn d-flex flex-row align-content-between';
				echo ( $index === 0 ) ? ' active' : '';
				echo '" data-category="' . $tab_id . '" onclick="show_widgets.call(this, \'' . $tab_id . '\')">';
				echo '<div class="title-icon d-flex align-items-center justify-content-center">';
						\Elementor\Icons_Manager::render_icon( $item['title-icon'], [ 'aria-hidden' => 'true' ] );
				echo ' </div>';
				echo esc_html( $item['title']);
				echo '</div>';
				$index += 1;
			}

            echo '</div>'; // Close tabs
            echo '</div>';
            echo '<div class="side-left">';

			$index = 0;
			foreach ( $settings['contents'] as $item ) {
				$tab_id = 'tab' . ( $index + 1 );
				echo '<div class="content"';
				echo ( $index === 0 ) ? ' style="display: block;"' : '';
				echo ' id="' . $tab_id . '">';

				echo '<div class="d-flex flex-row align-content-between">';
				echo '<div class="content-icon d-flex align-items-center justify-content-center">';
				\Elementor\Icons_Manager::render_icon( $item['content-icon'], [ 'aria-hidden' => 'true' ] );
				echo ' </div>';
				echo '<div class="content-title">';
				echo esc_html( $item['content-title'] );
				echo ' </div>';
				echo ' </div>';
				echo '<div class="content-body">';
				echo ( $item['content-body'] );
				echo ' </div>';

				echo '<div class="d-flex flex-row align-content-between">';
					if ( ! empty( $item['first-btn-link']['url'] ) ) {
						$this->add_link_attributes( 'first-btn-link', $item['first-btn-link'] );
						?>
						<a <?php $this->print_render_attribute_string( 'first-btn-link' ); ?>
						<?php
						echo 'class="first-btn-link d-flex flex-row justify-content-center align-content-between">';
						echo esc_html( $item['first-btn-title'] );
						echo '<div class="first-btn-icon d-flex align-items-center justify-content-center">';
							\Elementor\Icons_Manager::render_icon( $item['first-btn-icon'], [ 'aria-hidden' => 'true' ] );
						echo ' </div>';
						echo '</a>';
					}
					if ( ! empty( $item['sec-btn-link']['url'] ) ) {
						$this->add_link_attributes( 'sec-btn-link', $item['sec-btn-link'] );
						?>
						<a <?php $this->print_render_attribute_string( 'sec-btn-link' ); ?>
						<?php
						echo 'class="sec-btn-link d-flex flex-row justify-content-center align-content-between">';
						echo esc_html( $item['sec-btn-title'] );
						echo '<div class="sec-btn-icon d-flex align-items-center justify-content-center">';
							\Elementor\Icons_Manager::render_icon( $item['sec-btn-icon'], [ 'aria-hidden' => 'true' ] );
						echo ' </div>';
						echo '</a>';
					}

				echo ' </div>';



				echo '</div>'; // Closing .content
				$index += 1;
			}
			echo '</div>'; // Close side-left
			echo '</div>'; // Close testimonials
        endif;
        wp_reset_postdata();
    }

}