<?php


use handler\basic_element;
use handler\video;


if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_post_video_single extends \Elementor\Widget_Base {

    use basic_element;
	use video;


	public function get_name() {
        return 'ar_post_video_single';
    }

    public function get_title() {
        return esc_html__('post video', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_post_video_single';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }


	protected function register_controls() {
		$this->register_style_video_controls();

		$this->register_video_controls();
    }

    protected function render() {
		$post_kind = get_post_type();
		$selected_attribute_key = $post_kind . '_single_video_upload';
        $selected_attribute_value = '';

        if ($this->theme_is_edit_mode()) {
            $first_post_id = get_posts(array(
                'post_type'      => 'post',
                'posts_per_page' => 1,
                'orderby'        => 'ID',
                'order'          => 'ASC',
                'fields'         => 'ids',
            ));
            if (!empty($first_post_id)) {
                $selected_attribute_value = get_post_meta($first_post_id[0], $selected_attribute_key, true);
            }
        } else {
            if (!empty($selected_attribute_key)) {
                $selected_attribute_value = get_post_meta(get_the_ID(), $selected_attribute_key, true);
            }
        }

        echo '<div class="post-attribute">';
		$plyr_id = $this->get_id();
		$video = $selected_attribute_value;
		if ( has_post_thumbnail() ) {
			$post_thumbnail_id = get_post_thumbnail_id();
			$poster = wp_get_attachment_image_url( $post_thumbnail_id, 'full' );
		} else {
			$poster = NULL;

		}
		$this->render_video( $plyr_id, $video, $poster );
        echo '</div>';
    }
}