<?php



use handler\Group_Control_Query;
use handler\Post_skin_base;
use handler\swiper;
use handler\wavesurfer;
use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_post_video extends \Elementor\Widget_Base {


    use Group_Control_Query;
    use Post_skin_base;
    use swiper;
    use basic_element;
    use wavesurfer;

    public function get_name() {
        return 'ar_post_video';
    }

    public function get_title() {
        return esc_html__('Posts video', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_post_video';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function get_layout_source() {
        global $post;
        $post_id = get_the_ID();
        $current_page_id = $post_id;

        $posts = get_posts(array(
            'post_type'      => 'theme-blog',
            'posts_per_page' => -1, 
            'exclude'        => $current_page_id,
        ));

        $options = array();
        foreach ($posts as $post) {
            $options[$post_id] = $post->post_title;
        }

        return $options;
    }

    protected function register_content_section_1() {
        $this->start_controls_section(
            'section_layout',
            [
                'label' => esc_html__( 'Layout', THEME_NAME ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout',
            [
                'label'     => esc_html__( 'Layout', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'options'   => [
                    'grid'     => esc_html__( 'Grid', THEME_NAME ),
                    'carousel' => esc_html__( 'Carousel', THEME_NAME ),
                ],
                'default'   => 'grid',
            ]
        );


        $this->add_responsive_control(
            'columns',
            [
                'label'              => esc_html__( 'Columns', THEME_NAME ),
                'type'               => \Elementor\Controls_Manager::SELECT,
                'default'            => '3',
                'tablet_default'     => '2',
                'mobile_default'     => '1',
                'options'            => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
                'render_type'    => 'template',
                'selectors' => [
                    '{{WRAPPER}} .theme-posts-wrapper.layout-grid' => 'grid-template-columns: repeat({{SIZE}}, 1fr);',
                    '{{WRAPPER}} .theme-posts-wrapper.layout-masonry .post-item' => 'width: calc(100% / {{SIZE}});',
                    '{{WRAPPER}} .theme-posts-wrapper.layout-carousel .post-item' => 'width: calc(100% / {{SIZE}});',
                ],
            ]
        );

        $this->add_responsive_control(
            'column_gap',
            [
                'label'     => esc_html__( 'Column Gap', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SLIDER,
                'default'   => [
                    'size' => '20',
                ],
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'render_type'    => 'template',
                'selectors' => [
                    '{{WRAPPER}} .theme-posts-wrapper.layout-grid' => 'column-gap: {{SIZE}}{{UNIT}};',
                    'body:not(.rtl) {{WRAPPER}} .theme-posts-wrapper.layout-carousel .post-item' => 'margin-right: {{SIZE}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .theme-posts-wrapper.layout-carousel .post-item' => 'margin-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .theme-posts-wrapper.layout-masonry' => 'margin-left: calc({{SIZE}}{{UNIT}} * -.5); margin-right: calc({{SIZE}}{{UNIT}} * -.5);',
                    '{{WRAPPER}} .theme-posts-wrapper.layout-masonry .post-item' => 'padding-left: calc({{SIZE}}{{UNIT}} * .5); padding-right: calc({{SIZE}}{{UNIT}} * .5);',
                ],
            ]
        );

        $this->add_responsive_control(
            'row_gap',
            [
                'label'     => esc_html__( 'Row Gap', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SLIDER,
                'default'   => [
                    'size' => '20',
                ],
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .theme-posts-wrapper.layout-grid' => 'row-gap: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .theme-posts-wrapper.layout-masonry .post-item' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'layout!' => 'carousel',
                ],
            ]
        );

		$this->add_control(
			'audio_icon',
			[ 
				'label' => esc_html__( 'audio Icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::ICONS,
			]
		);

        $this->end_controls_section();

    }

    protected function register_style_section_1() {
        $this->start_controls_section(
            'post_price_style_section',
            [
                'label' => esc_html__( 'style', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

		$this->register_container_style( 'video-body', '.video-body');

		$this->add_control(
			'image_style_section',
			[ 
				'label' => esc_html__( 'image', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_image_style( 'video-image', '.video-body img', $align = false );

		$this->add_control(
			'title-container_style_section',
			[ 
				'label' => esc_html__( 'title container', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_container_style( 'title-container', '.title-container' );

		$this->add_control(
			'title_style_section',
			[ 
				'label' => esc_html__( 'title', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_text_style('video-title',  '.video-title', $align = false);

		$this->add_control(
			'icon',
			[ 
				'label' => esc_html__( 'icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'top-icon', '.video-body i', $align = false );

		$this->add_control(
			'time',
			[ 
				'label' => esc_html__( 'time', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_text_style('video-time',  '.video-time');

        $this->end_controls_section();

    } 

    protected function register_controls() {

        $this->register_query_builder_controls();
        $this->register_content_section_1();
        $this->register_style_section_1();
		$this->register_carousel_controls();
		$this->register_style_carousel_controls();
	}


    protected function render()
    {
        $settings = $this->get_settings_for_display();
		$element_id = $settings['_element_id'];
        $query = $this->get_query_result();
		if ( ! $query->found_posts ) {

            ?>
            <div class="nothing-show">
                <h2><?php esc_html_e('Nothing found!', THEME_NAME); ?></h2>
                <p><?php esc_html_e('It looks like nothing was found here!', THEME_NAME); ?></p>
            </div>
            <?php
            return;
        }

		?>
        <div class="theme-posts-container theme-post-widget">
            <?php
            $post_wrapper_cls = '';
                if( $settings['layout'] == 'grid' ) {
                    $post_wrapper_cls = 'theme-posts-wrapper';
                }
			?>
            <div class="<?php echo $post_wrapper_cls ?> layout-<?php echo $settings['layout'] ?>" >
                <?php $this->render_carousel_header(); ?>
                <script>
                    function formatTime(seconds) {
                        const minutes = Math.floor(seconds / 60);
                        const remainingSeconds = Math.floor(seconds % 60);
                        const formattedSeconds = remainingSeconds < 10 ? `0${remainingSeconds}` : remainingSeconds;
                        return `${minutes}:${formattedSeconds}`;
                    }

                    function getTotalVideoDuration(videoUrl, callback) {
                        const video = document.createElement('video');
                        
                        video.addEventListener('loadedmetadata', function() {
                            // Duration is in seconds
                            const duration = video.duration;
                            const formattedDuration = formatTime(duration);
                            callback(formattedDuration);
                        });

                        // In case of an error loading the video
                        video.addEventListener('error', function() {
                            console.error('Error loading video:', videoUrl);
                            callback(null);
                        });

                        // Set the video source and preload metadata
                        video.src = videoUrl;
                        video.preload = 'metadata';
                    }
                </script>

                <?php
                if ( $query->have_posts() ) :
                    
					while ( $query->have_posts() ) :
                        $query->the_post();
                        
                        $post_item_cls = 'post-item';
                        if( $settings['layout'] == 'carousel' ) {
                            $post_item_cls = ' swiper-slide';
                        }
                        $post_kind = get_post_type();
                        $video_file = get_post_meta(get_the_ID(), $post_kind . '_single_video_upload', true );
                        
						if($video_file){
                            $post_title = get_the_title( get_the_ID());
                            ?>
                            <div class="<?php echo esc_html( $post_item_cls ); ?>">
                                <div class="video-body">
                                    <?php
                                    if (has_post_thumbnail()) {
                                        $post_thumbnail_id = get_post_thumbnail_id();
                                        $post_thumbnail_url = wp_get_attachment_image_url($post_thumbnail_id, 'full');
                                        echo '<a href="' . esc_url(get_permalink()) . '">';
                                        echo '<img src="' . esc_url($post_thumbnail_url) . '" alt="' . esc_attr(get_the_title()) . '">';
                                        echo '</a>';
                                    } else {
                                        echo esc_html__('No featured image found.', THEME_NAME);
                                    }
                                    ?>
                                    <div class="title-container" style="position: relative;">
                                        <div class="post-title">
                                            <i aria-hidden="true" class="isax isax-play4"></i>
                                            <?php
                                            $post_id = get_the_ID();
                                            echo '<a class="video-title" href="' . esc_url( get_permalink( $post_id ) ) . '">' . esc_html( $post_title ) . '</a>';
                                        ?>
                                        </div>
                                        <div class="video-time" id="video-<?php echo get_the_ID() ?>"></div>
                                        <script>
                                            videoUrl = "<?php echo $video_file; ?>";
                                            getTotalVideoDuration(videoUrl, function(duration) {
                                                if (duration !== null) {
                                                    document.getElementById("video-<?php echo get_the_ID() ?>" ).innerHTML = duration + ' دقیقه ';
                                                }
                                            });
                                        </script>
                                    </div>
                                </div>
                            </div>
                            <?php
                        }
                    endwhile;
                endif;
                wp_reset_postdata();
                ?>
                <?php $this->render_carousel_footer(); ?>
            </div>
        </div>
        <?php
    }

}