<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_post_type_attr extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_post_type_attr';
    }

    public function get_title() {
        return esc_html__('post type attributes', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_post_type_attr';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function get_attributes() {
        $attributes = array();
        $post_types = theme_post_type();
        foreach ($post_types as $post_type ) {
            if(option_value($post_type['name'] . '-attribute') ){
                foreach (option_value($post_type['name'] . '-attribute') as $index => $item) {
                    $attributes[$post_type['name'] . '_' . $index] = esc_html($item . ' ' . $post_type['name']);
                }
            }
        }
        return $attributes;
    }

    protected function register_content_section_1() {
        $this->start_controls_section(
            'section_layout',
            [
                'label' => esc_html__( 'Layout', THEME_NAME ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'attr',
			[
				'label'   => esc_html__( 'Posts attribute', THEME_NAME ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'options' => $this->get_attributes(),
				'default' => 'post',
			]
		);

        $this->end_controls_section();

    }
    protected function register_style_section_1() {
        $this->start_controls_section(
            'product_style_section',
            [
                'label' => esc_html__( 'category', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('product_categories',  '.product-attribute');

        $this->end_controls_section();

    } 

    protected function register_controls() {

        $this->register_content_section_1();
        $this->register_style_section_1();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $selected_attribute_key = $settings['attr'];
        $selected_attribute_value = '';

        if ($this->theme_is_edit_mode()) {
            $selected_attribute_value = __('simple text', THEME_NAME);
        } elseif (!empty($selected_attribute_key)) {
            $selected_attribute_value = get_post_meta(get_the_ID(), $selected_attribute_key, true);
        }

        echo '<div class="product-attribute">';
        echo esc_html($selected_attribute_value);
        echo '</div>';
    }

}