<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_post_title extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_post_title';
    }

    public function get_title() {
        return esc_html__('post title', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_post_title';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }


    protected function register_style_section_1() {
        $this->start_controls_section(
            'post_style_section',
            [
                'label' => esc_html__( 'style', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('post_categories',  'a', $align=false);

        $this->end_controls_section();

    } 

    protected function register_controls() {

        $this->register_style_section_1();
    }

    protected function render() {
        if ($this->theme_is_edit_mode()) {
            echo '<div class="post-title">';
			echo '<a href="#">' . __( 'post name', THEME_NAME ) . '</a>';
            echo '</div>';
        } else {
            global $post;
            $post_id = get_the_ID();
            $post_title = get_the_title($post_id);

            echo '<div class="post-title">';
            echo '<a href="' . esc_url(get_permalink($post_id)) . '">' . esc_html($post_title) . '</a>';
            echo '</div>';
        }
    }


}