<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_post_comments extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_post_comments';
    }

    public function get_title() {
        return esc_html__('post comments', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_post_comments';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

	protected function register_style_section_0() {
		$this->start_controls_section(
			'comments_container_section',
			[ 
				'label' => esc_html__( 'comments container', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_container_style( 'comments-container', '.comments-container' );

		$this->end_controls_section();

	}


	protected function register_style_section_1() {
        $this->start_controls_section(
            'author_image_section',
            [
                'label' => esc_html__( 'author image', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_image_style('author_image',  '.comment-list .comment-author img');

        $this->end_controls_section();

    } 

    protected function register_style_section_2() {
        $this->start_controls_section(
            'author_title_section',
            [
                'label' => esc_html__( 'author name', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('author_title',  '.comment-list .comment-author .fn, .comment-list .comment-author a');

        $this->end_controls_section();

    } 

    protected function register_style_section_3() {
        $this->start_controls_section(
            'date_section',
            [
                'label' => esc_html__( 'date', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('date',  '.comment-metadata');

        $this->end_controls_section();
    }
    
    protected function register_style_section_4() {
        $this->start_controls_section(
            'body_section',
            [
                'label' => esc_html__( 'body', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('body',  '.comment-content');

        $this->end_controls_section();
    }

    protected function register_style_section_5() {
        $this->start_controls_section(
            'btn_section',
            [
                'label' => esc_html__( 'button', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('btn',  '.comment-reply-link');

        $this->end_controls_section();
    }

     protected function register_style_section_6() {
        $this->start_controls_section(
            'container_section',
            [
                'label' => esc_html__( 'container', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

		$this->register_container_style( 'comments-list', '.comment-list' );

		$this->add_control(
			'first-level-comment',
			[ 
				'label' => esc_html__( 'first level comment', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

        $this->register_container_style('container',  '.comment-body');

		$this->add_control(
			'children-comment',
			[ 
				'label' => esc_html__( 'children comment', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_container_style( 'children', 'ol.children' );

        $this->end_controls_section();
    }

	protected function register_style_section_7() {
		$this->start_controls_section(
			'add-comment_section',
			[ 
				'label' => esc_html__( 'add comment', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_text_style( 'add-comment', '.comment-reply-title' );

		$this->add_control(
			'heading-span',
			[ 
				'label' => esc_html__( 'title', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'add-comment-span', '.comment-reply-title span' );

		$this->end_controls_section();
	}

	protected function register_style_section_8() {
		$this->start_controls_section(
			'add-comment_body_section',
			[ 
				'label' => esc_html__( 'add comment body', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_container_style( 'custom-form-comment-body', '.custom-form' );

		$this->add_control(
			'form-body',
			[ 
				'label' => esc_html__( 'form body', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_container_style( 'add-comment-body', 'form' );

		$this->end_controls_section();
	}

	protected function register_style_section_9() {
		$this->start_controls_section(
			'add-comment_label_section',
			[ 
				'label' => esc_html__( 'add comment label', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_text_style( 'add-comment-label', 'label', $align = false );

		$this->end_controls_section();
	}

	protected function register_style_section_10() {
		$this->start_controls_section(
			'add-comment_input_section',
			[ 
				'label' => esc_html__( 'add comment input', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_text_style( 'add-comment-input', 'input', $align = false );

		$this->end_controls_section();
	}

	protected function register_style_section_11() {
		$this->start_controls_section(
			'add-comment_icon_section',
			[ 
				'label' => esc_html__( 'add comment icon', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_container_style( 'add-comment-icon', 'svg' );

		$this->end_controls_section();
	}

	protected function register_style_section_12() {
		$this->start_controls_section(
			'add-comment_score_section',
			[ 
				'label' => esc_html__( 'add comment score', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_text_style( 'add-comment-star', '.star-continaner', $align = false );

		$this->end_controls_section();
	}

	protected function register_style_section_13() {
		$this->start_controls_section(
			'add-comment_textarea_section',
			[ 
				'label' => esc_html__( 'add comment textarea', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_text_style( 'add-comment-textarea', 'textarea', $align = false );

		$this->end_controls_section();
	}

	protected function register_style_section_14() {
		$this->start_controls_section(
			'add-comment_submit_section',
			[ 
				'label' => esc_html__( 'submit', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_text_style( 'add-comment-submit', 'input[name="submit"][type="submit"].submit#submit', $align = false );

		$this->end_controls_section();
	}

	protected function register_controls() {

        $this->register_style_section_0();
		$this->register_style_section_1();
        $this->register_style_section_2();
        $this->register_style_section_3();
        $this->register_style_section_4();
        $this->register_style_section_5();
        $this->register_style_section_6();
		$this->register_style_section_7();
		$this->register_style_section_8();
		$this->register_style_section_9();
		$this->register_style_section_10();
		$this->register_style_section_11();
		$this->register_style_section_12();
		$this->register_style_section_13();
		$this->register_style_section_14();
    }

    protected function render() {
        if ($this->theme_is_edit_mode()) {
            // Display comments of the first post in edit mode
            $first_post = get_posts(array(
                'post_type'      => 'post',
                'posts_per_page' => 1,
                'orderby'        => 'ID',
                'order'          => 'ASC',
                'fields'         => 'ids',
            ));
            $first_post_id = $first_post[0];
            $comments_args = array(
                'post_id' => $first_post_id, // Specify the post ID of the first post
            );
            $comments = get_comments($comments_args);
            if ($comments) {
                echo '<div class="comments-container">';
                echo '<ol class="comment-list">';
                // Output each top-level comment
                wp_list_comments(array(
                    'style'      => 'ol',
                    'avatar_size' => 60,
                    'max_depth'  => 3, // Set the maximum depth of nested comments
                ), $comments);
                echo '</ol>';
                echo '</div>';
            }
			?>
			<div class="custom-form">
                        	<div id="respond" class="comment-respond">
		<h2 id="reply-title" class="comment-reply-title"><span>  reply</span>your  <small><a rel="nofollow" id="cancel-comment-reply-link" href="/2024/03/18/%d8%aa%d8%a8%d9%84%db%8c%d8%ba%d8%a7%d8%aa-%d9%85%db%8c%d8%af%d8%a7%d9%86%db%8c/#respond" style="display:none;">لغو پاسخ</a></small></h2><form action="http://shopex.test/wp-comments-post.php" method="post" id="commentform" class="comment-form"><p class="comment-notes"><span id="email-notes">نشانی ایمیل شما منتشر نخواهد شد.</span> <span class="required-field-message">بخش‌های موردنیاز علامت‌گذاری شده‌اند <span class="required">*</span></span></p><div class="comment-input-container full-width"><textarea id="comment" name="comment" rows="6" class="form-textarea" placeholder="متن شما" required=""></textarea></div><div class="top"><div class="comment-input-container half-width">
                     <label for="author">نام و نام خانوادگی</label>
                    <input class="form-author" id="author" name="author" type="text" size="30" maxlength="245" placeholder="نام *" value="" required="">
                    <svg width="16" height="20" viewBox="0 0 16 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M1 19C1 15.134 4.13401 12 8 12C11.866 12 15 15.134 15 19M12 5C12 7.20914 10.2091 9 8 9C5.79086 9 4 7.20914 4 5C4 2.79086 5.79086 1 8 1C10.2091 1 12 2.79086 12 5Z" stroke="#C9C9C9" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                    </svg>

                </div>
<div class="comment-input-container half-width">
                     <label for="email">پست الکترونیک</label>
                    <input class="form-email" id="email" name="email" type="email" size="30" maxlength="200" placeholder="پست الکترونیک *" value="" required="">
                    <svg width="21" height="16" viewBox="0 0 21 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M1.06921 4L6.59704 7.645C7.89485 8.49627 8.54375 8.9219 9.24486 9.0873C9.86447 9.23347 10.5103 9.23347 11.1299 9.0873C11.831 8.9219 12.4799 8.49627 13.7777 7.645L19.2543 4.04005M5.90432 15H14.4168C16.1195 15 16.9708 15 17.6211 14.673C18.1932 14.3854 18.6583 13.9265 18.9498 13.362C19.2811 12.7202 19.2811 11.8802 19.2811 10.2V5.8C19.2811 4.11984 19.2811 3.27976 18.9498 2.63803C18.6583 2.07354 18.1932 1.6146 17.6211 1.32698C16.9708 1 16.1195 1 14.4168 1H5.90433C4.20167 1 3.35034 1 2.70001 1.32698C2.12796 1.6146 1.66287 2.07354 1.3714 2.63803C1.04004 3.27976 1.04004 4.11984 1.04004 5.8V10.2C1.04004 11.8802 1.04004 12.7202 1.3714 13.362C1.66287 13.9265 2.12796 14.3854 2.70001 14.673C3.35034 15 4.20167 15 5.90432 15Z" stroke="#C9C9C9" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                    </svg>

                </div></div>
<p class="comment-form-cookies-consent"><input id="wp-comment-cookies-consent" name="wp-comment-cookies-consent" type="checkbox" value="yes"> <label for="wp-comment-cookies-consent">ذخیره نام، ایمیل و وبسایت من در مرورگر برای زمانی که دوباره دیدگاهی می‌نویسم.</label></p>
<p class="form-submit" style="display: none;"></p><div class="comment-submit full-width"><input name="submit" type="submit" id="submit" class="submit" value="ارسال دیدگاه"></div> <input type="hidden" name="comment_post_ID" value="538" id="comment_post_ID">
<input type="hidden" name="comment_parent" id="comment_parent" value="0">
<p></p></form>	</div><!-- #respond -->
	                    </div>
			<?php
			return;

        } else {
            ?>

            <?php
            $comments_args = array(
                'post_id' => get_the_ID(), // Specify the post ID of the current post
            );
            $comments = get_comments($comments_args);
            if ($comments) {
                echo '<div class="comments-container">';
                echo '<ol class="comment-list">';
                // Output each top-level comment
                wp_list_comments(array(
                    'style'      => 'ol',
                    'avatar_size' => 60,
                    'max_depth'  => 3, // Set the maximum depth of nested comments
                ), $comments);
                echo '</ol>';
                
            }
            if ( ! comments_open() ) : ?>
                    <p class="comments-closed"><?php esc_html_e( 'Comments are closed.', THEME_NAME ); ?></p>
                <?php endif; ?>
                <?php
				$commenter = wp_get_current_commenter();

				$req = get_option( 'require_name_email' );
				$aria_req = $req ? ' required' : '';
				$req_sign = $req ? ' *' : '';

				$fields = array(
					'author' => '<div class="top"><div class="comment-input-container half-width">
                     <label for="author">' . esc_attr__( 'first and last name', THEME_NAME ) . '</label>
                    <input class="form-author" id="author" name="author" type="text" size="30" maxlength="245" placeholder="' . esc_attr__( 'Name', THEME_NAME ) . $req_sign . '" value="' . esc_attr( $commenter['comment_author'] ) . '" ' . $aria_req . '>
                    <svg width="16" height="20" viewBox="0 0 16 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M1 19C1 15.134 4.13401 12 8 12C11.866 12 15 15.134 15 19M12 5C12 7.20914 10.2091 9 8 9C5.79086 9 4 7.20914 4 5C4 2.79086 5.79086 1 8 1C10.2091 1 12 2.79086 12 5Z" stroke="#C9C9C9" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>

                </div>',
					'email' => '<div class="comment-input-container half-width">
                     <label for="email">' . esc_attr__( 'Email', THEME_NAME ) . '</label>
                    <input class="form-email" id="email" name="email" type="email" size="30" maxlength="200" placeholder="' . esc_attr__( 'Email', THEME_NAME ) . $req_sign . '" value="' . esc_attr( $commenter['comment_author_email'] ) . '" ' . $aria_req . '>
                    <svg width="21" height="16" viewBox="0 0 21 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M1.06921 4L6.59704 7.645C7.89485 8.49627 8.54375 8.9219 9.24486 9.0873C9.86447 9.23347 10.5103 9.23347 11.1299 9.0873C11.831 8.9219 12.4799 8.49627 13.7777 7.645L19.2543 4.04005M5.90432 15H14.4168C16.1195 15 16.9708 15 17.6211 14.673C18.1932 14.3854 18.6583 13.9265 18.9498 13.362C19.2811 12.7202 19.2811 11.8802 19.2811 10.2V5.8C19.2811 4.11984 19.2811 3.27976 18.9498 2.63803C18.6583 2.07354 18.1932 1.6146 17.6211 1.32698C16.9708 1 16.1195 1 14.4168 1H5.90433C4.20167 1 3.35034 1 2.70001 1.32698C2.12796 1.6146 1.66287 2.07354 1.3714 2.63803C1.04004 3.27976 1.04004 4.11984 1.04004 5.8V10.2C1.04004 11.8802 1.04004 12.7202 1.3714 13.362C1.66287 13.9265 2.12796 14.3854 2.70001 14.673C3.35034 15 4.20167 15 5.90432 15Z" stroke="#C9C9C9" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>

                </div></div>',
				);

				$fields = apply_filters( 'comment_form_default_fields', $fields );

				$comments_args = array(
					'comment_field' => '<div class="comment-input-container full-width"><textarea id="comment" name="comment" rows="6" class="form-textarea" placeholder="' . esc_attr__( 'your text', THEME_NAME ) . '" required></textarea></div>',
					'fields' => $fields,
					'format' => 'xhtml',
					'class_form' => 'comment-form',
					'class_submit' => 'submit',
					'title_reply' => __( 'your ', THEME_NAME ),
					'title_reply_before' => '<h2 id="reply-title" class="comment-reply-title"><span> '.__(' reply', THEME_NAME) .'</span>',
					'title_reply_after' => '</h2>',
					'submit_button' => '<div class="comment-submit full-width"><input name="submit" type="submit" id="submit" class="submit" value="' . esc_attr__( 'Post Comment', THEME_NAME ) . '"></div>',
				);

                    
				?>
                    <div class="custom-form">
                        <?php comment_form( $comments_args ); ?>
                    </div>
                    <script>
                        document.addEventListener('DOMContentLoaded', function() {
                            var form = document.getElementById('commentform');
                            var loggedInAs = form.querySelector('.logged-in-as');
                            var formSubmit = form.querySelector('.form-submit');

                            if (!loggedInAs) {
                                formSubmit.style.display = 'none';
                            }
                            else{
                                form.style.display = 'block';
                            }
                        });
                    </script>
            <?php


        }
    }


}