<?php


use handler\basic_element;
use handler\video;


if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_post_audio extends \Elementor\Widget_Base {

    use basic_element;
	use video;


	public function get_name() {
        return 'ar_post_audio';
    }

    public function get_title() {
        return esc_html__('post audio', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_post_audio';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }
    protected function render() {
		$post_kind = get_post_type();
		$selected_attribute_key = $post_kind . '_single_audio_file';
        $selected_attribute_value = '';

        if ($this->theme_is_edit_mode()) {
            $first_post_id = get_posts(array(
                'post_type'      => 'post',
                'posts_per_page' => 1,
                'orderby'        => 'ID',
                'order'          => 'ASC',
                'fields'         => 'ids',
            ));
            if (!empty($first_post_id)) {
                $selected_attribute_value = get_post_meta($first_post_id[0], $selected_attribute_key, true);
            }
        } else {
            if (!empty($selected_attribute_key)) {
                $selected_attribute_value = get_post_meta(get_the_ID(), $selected_attribute_key, true);
            }
        }

        echo '<div class="post-attribute">';
		?>
			<audio class="plyr" controls>
				<source src="<?php echo esc_url( $selected_attribute_value ); ?>" type="audio/mpeg">
				Your browser does not support the audio element.
			</audio>
        <?php
        echo '</div>';
    }

}