<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_page_title extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_page_title';
    }

    public function get_title() {
        return esc_html__('page title', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_page_title';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_content_section_1(){
        $this->start_controls_section(
            'section_promo_content',
            [
                'label' => esc_html__('Content', THEME_NAME),
            ]
        );
        $this->add_control(
			'header_size',
			[
				'label' => __( 'HTML Tag', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
				],
				'default' => 'h1',
			]
		);
        $this->end_controls_section();
    }

    protected function register_style_section_1() {
        $this->start_controls_section(
            'product_price_style_section',
            [
                'label' => esc_html__( 'style', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('title',  '.title');

        $this->end_controls_section();

    } 

    protected function register_controls() {

        $this->register_content_section_1();
        $this->register_style_section_1();
    }

    protected function render(){
		$settings = $this->get_settings_for_display();
		echo sprintf( '<%1$s class="title">%2$s</%1$s>', $settings['header_size'],   wp_title( '', false ) );
	}
}