<?php

use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_offcanvas extends \Elementor\Widget_Base {

    use basic_element;

    public function get_name() {
        return 'ar_offcanvas';
    }

    public function get_title() {
        return esc_html__('Offcanvas', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_offcanvas';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_content_section_1() {
        $this->start_controls_section(
            'section_general',
            [
                'label' => esc_html__('General', THEME_NAME),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,

            ]
        );

        $this->add_control(
            'content_template',
            [
                'label' => esc_html__( 'Content Template', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => get_all_header_template(),
                'default' => '0',
            ]
        );

        $this->add_responsive_control(
            'icon_text_align', [
                'label' => esc_html__('Alignment', THEME_NAME),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'right' => [
                        'title' => esc_html__('Right', THEME_NAME),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', THEME_NAME),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'left' => [
                        'title' => esc_html__('Left', THEME_NAME),
                        'icon' => 'eicon-text-align-left',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .offcanvas-opener-wrapper' => 'text-align: {{VALUE}};'
                ],
            ]
        );

        $this->add_control(
            'content_position', [
                'label' => esc_html__('Position', THEME_NAME),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'right' => [
                        'title' => esc_html__('Right', THEME_NAME),
                        'icon' => 'eicon-h-align-right',
                    ],
                    'left' => [
                        'title' => esc_html__('Left', THEME_NAME),
                        'icon' => 'eicon-h-align-left',
                    ],
                ],
                'default' => 'left',
            ]
        );

        $this->add_control(
            'top_image',
            [
                'label' => esc_html__( 'Image', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'first_text',
            [
                'label'     => esc_html__( 'first text', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::TEXT,
            ]
        );


        $this->add_control(
            'sec_text',
            [
                'label'     => esc_html__( 'sec text', THEME_NAME ),
                'default' => esc_html__( ' Posts' , THEME_NAME ),
            ]
        );

        $this->add_control(
			'menu_open_icon',
			[
				'label' => esc_html__( 'menu open Icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::ICONS,
			]
		);

        $this->add_control(
			'menu_close_icon',
			[
				'label' => esc_html__( 'menu close Icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::ICONS,
			]
		);

        $this->end_controls_section();
    }

    protected function register_style_section_1() {
        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('Style', THEME_NAME),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'content_style_section',
            [
                'label' => esc_html__( 'Content', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::HEADING,
            ]
        );

        $this->add_responsive_control(
            'content_width',
            [
                'label' => esc_html__('Width', THEME_NAME),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1400,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 450,
                ],
                'selectors' => [
                    '{{WRAPPER}} .offcanvas-wrapper .offcanvas-container' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'content_bg',
                'label' => esc_html__('Background', THEME_NAME),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .offcanvas-container',
            ]
        );

        $this->add_responsive_control('content_padding',
        [
            'label' => esc_html__('Container Padding', THEME_NAME),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em', '%'],
            'selectors' => [
                '{{WRAPPER}} .offcanvas-container' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);
        
        $this->add_control(
            'image_top_bar_style_section',
            [
                'label' => esc_html__( 'top image', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );  
        $this->register_image_style('iamges',  '.top .content img');
        
        $this->add_control(
            'title_1_top_bar_style_section',
            [
                'label' => esc_html__( 'first text', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->register_text_style('first_text',  '.top .content .first_text', $align=false);

         $this->add_control(
            'title_2_top_bar_style_section',
            [
                'label' => esc_html__( 'seccond text', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->register_text_style('sec_text',  '.top .content .sec_text', $align=false);

        $this->add_control(
            'icon_style_section',
            [
                'label' => esc_html__( 'Icon', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );      

        $this->start_controls_tabs('icon_color_tabs');

        $this->start_controls_tab(
            'icon_color_tab_normal_state',
            [
                'label' => esc_html__('Normal', THEME_NAME),
            ]
        );

		$this->register_text_style( 'offcanvas-opener', '.offcanvas-opener i', $align = false );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'icon_color_tab_hover_state',
            [
                'label' => esc_html__('Hover', THEME_NAME),
            ]
        );

		$this->register_text_style( 'offcanvas-opener-hover', '.offcanvas-opener:hover i', $align = false );

        $this->end_controls_tab();

        $this->end_controls_tabs();
        
        $this->add_control(
            'close_icon_style_section',
            [
                'label' => esc_html__( 'close icon', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

		$this->register_text_style( 'offcanvas-closer', '.offcanvas-closer i', $align = false );

        $this->end_controls_section();
    }

    protected function register_controls() {

        $this->register_content_section_1();

        $this->register_style_section_1();
    }

    protected function render(){
        $settings = $this->get_settings_for_display();

        $offcanvas_position = ( isset($settings['content_position']) && $settings['content_position'] == 'left' )? 'position-left' : 'position-right';

        ?>
        <div class="theme-offcanvas">
            <div class="offcanvas-opener-wrapper">
                <span class="offcanvas-opener">
                    <div class="my-icon-wrapper">
                        <?php \Elementor\Icons_Manager::render_icon( $settings['menu_open_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                    </div>
                </span>
            </div>
            <div class="offcanvas-wrapper <?php echo esc_html($offcanvas_position); ?>">
                <div class="offcanvas-container">
                    <div class="offcanvas-container-inner">
                        <div class="top">
                            <div class="content">
                                <img src="<?php echo esc_url($settings['top_image']['url']); ?>">
                                <div class="texts">
                                    <span class="first_text"><?php echo esc_html($settings['first_text']); ?></span>
                                    <span class="sec_text"><?php echo esc_html($settings['sec_text']); ?></span>
                                </div>
                            </div>

                            <span class="offcanvas-closer">
                                <div class="my-icon-wrapper">
                                    <?php \Elementor\Icons_Manager::render_icon( $settings['menu_close_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                </div>
                            </span>
                        </div>
                        <div class="offcanvas-content">
                            <?php
                            $template_id = !empty($settings['content_template'])? $settings['content_template'] : 0;
                            if($template_id) {
                                echo show_template($template_id);
                            }
                            else { ?>
                                <div class="offcanvas-default">
                                    <div class="container">
                                        <nav class="theme-header-nav-wrapper header-vertical-nav">
                                            <?php
												wp_nav_menu( array(
													'theme_location' => 'mobile_menu',
													'link_before' => '<span>',
													'link_after' => '</span>',
													'fallback_cb' => false,
													'container' => false,
													'menu_class' => 'theme-header-nav',
												) );
												?>
                                        </nav>
                                    </div>
                                </div>
                            <?php } ?>
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }

}