<?php



if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

use handler\basic_element;

class ar_menu extends \Elementor\Widget_Base {

	use basic_element;

	public function get_name() {
        return 'ar_menu';
    }

    public function get_title() {
        return esc_html__('menu', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_menu';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    private function get_menus(){
        $menus   = wp_get_nav_menus();
        $options = [];

        if (empty($menus)) {
            return $options;
        }

        foreach ($menus as $menu) {
            $options[$menu->term_id] = $menu->name;
        }

        return $options;
    }

    protected function register_content_section_1() {
        $this->start_controls_section(
            'section_settings',
            [
                'label' => esc_html__('settings', THEME_NAME),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'menu',
            [
                'label'       => esc_html__('Select Menu', THEME_NAME),
                'description' => sprintf(esc_html__('Go to the %s Menu screen %s to manage your menus.', THEME_NAME), '<a href="' . admin_url('nav-menus.php') . '" target="_blank">', '</a>'),
                'type'        => \Elementor\Controls_Manager::SELECT,
                'label_block' => false,
                'options'     =>  $this->get_menus(),
                'default'     => array_keys( $this->get_menus())[0],
            ]
        );

        $this->add_control(
            'menu_type',
            [
                'label' => esc_html__( 'Menu Type', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'horizontal',
                'options' => [
                    'horizontal'  => esc_html__( 'Horizontal', THEME_NAME ),
                    'vertical' => esc_html__( 'Vertical', THEME_NAME ),
                ],
            ]
        );

        $this->add_responsive_control(
            'H_menu_align', [
                'label' => esc_html__('Alignment', THEME_NAME),
                'condition' => ['menu_type' => 'horizontal'],
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'flex-end' => [
                        'title' => esc_html__('End', THEME_NAME),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', THEME_NAME),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'flex-start' => [
                        'title' => esc_html__('Start', THEME_NAME),
                        'icon' => 'eicon-text-align-left',
                    ],
                    
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .theme-header-nav' => 'justify-content: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function register_style_section_1() {
        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('Style', THEME_NAME),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'menu_section',
            [
                'label' => esc_html__( 'main menu', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::HEADING,
            ]
        );

		$this->register_container_style( 'menu-item', '.menu-item' );

        $this->start_controls_tabs('menu_color_tabs');

        # Normal State Tab
        $this->start_controls_tab(
            'menu_color_tab_normal_state',
            [
                'label' => esc_html__('Normal', THEME_NAME),
            ]
        );

		$this->add_control(
			'first_icon_section',
			[ 
				'label' => esc_html__( 'first icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'first-menu-icon', '.first-menu-icon', $align = false );

        $this->add_control(
            'first_media_section',
            [
                'label' => esc_html__( 'first image', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->register_image_style('first-media',  '.first-media');

		$this->add_control(
			'title-container_section',
			[ 
				'label' => esc_html__( 'title container', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_container_style( 'title-container', '.title-container' );

		$this->add_control(
			'title-menu_section',
			[ 
				'label' => esc_html__( 'title', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'title_menu', '.theme-header-nav li.menu-item > a', $align = false );

		$this->add_control(
			'dropdown_icon_section',
			[ 
				'label' => esc_html__( 'dropdown icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'dropdown-icon', '.dropdown-icon', $align = false );

        $this->add_control(
            'second_media_section',
            [
                'label' => esc_html__( 'second image', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->register_image_style('second-media',  '.second-media');

		$this->add_control(
			'second_icon_section',
			[ 
				'label' => esc_html__( 'second icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'second-menu-icon', '.second-menu-icon', $align = false );

		$this->end_controls_tab();

        # Hover State Tab
        $this->start_controls_tab(
            'menu_color_tab_hover_state',
            [
                'label' => esc_html__('Hover', THEME_NAME),
            ]
        );

        $this->add_control(
            'menu_color_hover',
            [
                'label' => esc_html__('Item Color', THEME_NAME),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .theme-header-nav li.menu-item > a:hover, {{WRAPPER}} .theme-header-nav li.current-menu-item > a, {{WRAPPER}} .theme-header-nav li.current-menu-ancestor > a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .header-vertical-nav li.menu-item > a:hover, {{WRAPPER}} .header-vertical-nav li.current-menu-item > a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
			'first_icon_section_hover',
			[ 
				'label' => esc_html__( 'first icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'first-menu-icon_hover', 'li.menu-item:hover .first-menu-icon', $align = false );

		$this->add_control(
			'first_hover_media_section_hover',
			[ 
				'label' => esc_html__( 'first hover image', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_image_style( 'first-hover-media_hover', 'li.menu-item:hover .first-hover-media' );

		$this->add_control(
			'title-container_section_hover',
			[ 
				'label' => esc_html__( 'title container', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_container_style( 'title-container_hover', 'li.menu-item:hover .title-container' );

        $this->add_control(
			'title-menu_section_hover',
			[ 
				'label' => esc_html__( 'title', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'title_menu_hover', '.theme-header-nav li.menu-item:hover > a', $align = false );


		$this->add_control(
			'dropdown_icon_section_hover',
			[ 
				'label' => esc_html__( 'dropdown icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'dropdown-icon_hover', 'li.menu-item:hover .dropdown-icon', $align = false );

		$this->add_control(
			'second_hover_media_section_hover',
			[ 
				'label' => esc_html__( 'second hover image', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_image_style( 'second-hover-media_hover', 'li.menu-item:hover .second-hover-media' );


		$this->add_control(
			'second_icon_section_hover',
			[ 
				'label' => esc_html__( 'second icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'second-menu-icon_hover', 'li.menu-item:hover .second-menu-icon', $align = false );

        $this->add_control(
            'h_menu_hover_shape',
            [
                'label' => esc_html__( 'Hover Shape', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'condition' => ['menu_type' => 'horizontal'],
                'options' => [
                    'hover-style-1'  => esc_html__( 'Style 1', THEME_NAME ),
                    'hover-style-2'  => esc_html__( 'Style 2', THEME_NAME ),
                    'hover-style-3'  => esc_html__( 'Style 3', THEME_NAME ),
                    'hover-style-4'  => esc_html__( 'Style 4', THEME_NAME ),
                    'hover-style-5'  => esc_html__( 'Style 5', THEME_NAME ),
                ],
            ]
        );

        $this->add_control(
            'h_menu_hover_shape_color',
            [
                'label' => esc_html__('Hover Shape Color', THEME_NAME),
                'type' => \Elementor\Controls_Manager::COLOR,
                'condition' => ['menu_type' => 'horizontal'],
                'selectors' => [
                    '{{WRAPPER}} .theme-header-nav > li.menu-item > a::before' => 'background: {{VALUE}}',
                    '{{WRAPPER}} .theme-header-nav-wrapper.hover-style-4 > ul > li.menu-item > a:hover, {{WRAPPER}} .theme-header-nav-wrapper.hover-style-4 > ul > li.current-menu-item > a, {{WRAPPER}} .theme-header-nav-wrapper.hover-style-4 > ul > li.current-menu-ancestor > a' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
    }

	protected function register_style_section_2() {
		$this->start_controls_section(
			'section_submenu_style',
			[ 
				'label' => esc_html__( 'Submenu Style', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_container_style( 'sub-menu-container', '.sub-menu' );

		$this->add_control(
			'item_section_sub-menu',
			[ 
				'label' => esc_html__( 'items', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_container_style( 'sub-menu-menu-item', '.sub-menu .menu-item' );

		$this->start_controls_tabs( 'menu_color_sub-menu_tabs' );

		# Normal State Tab
		$this->start_controls_tab(
			'menu_color_tab_normal_state_sub-menu',
			[ 
				'label' => esc_html__( 'Normal', THEME_NAME ),
			]
		);

		$this->add_control(
			'first_icon_section_sub-menu',
			[ 
				'label' => esc_html__( 'first icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'first-menu-icon_sub-menu', 'li.menu-item.menu-item-has-children:hover .sub-menu .first-menu-icon', $align = false );

		$this->add_control(
			'first_media_section_sub-menu',
			[ 
				'label' => esc_html__( 'first image', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_image_style( 'first-media_sub-menu', 'li.menu-item.menu-item-has-children:hover .sub-menu .first-media' );

		$this->add_control(
			'title-container_section_sub-menu',
			[ 
				'label' => esc_html__( 'title container', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_container_style( 'title-container_sub-menu', 'li.menu-item.menu-item-has-children:hover .sub-menu .title-container' );

        $this->add_control(
			'title-container_section_sub-menu',
			[ 
				'label' => esc_html__( 'title', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'title_sub-menu', '.theme-header-nav .sub-menu li.menu-item a', $align = false );

		$this->add_control(
			'dropdown_icon_section_sub-menu',
			[ 
				'label' => esc_html__( 'dropdown icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'dropdown-icon_sub-menu', 'li.menu-item.menu-item-has-children:hover .sub-menu .dropdown-icon', $align = false );

		$this->add_control(
			'second_media_section_sub-menu',
			[ 
				'label' => esc_html__( 'second image', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_image_style( 'second-media_sub-menu', 'li.menu-item.menu-item-has-children:hover .sub-menu .second-media' );

		$this->add_control(
			'second_icon_section_sub-menu',
			[ 
				'label' => esc_html__( 'second icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'second-menu-icon_sub-menu', 'li.menu-item.menu-item-has-children:hover .sub-menu .second-menu-icon', $align = false );

		$this->end_controls_tab();

		# Hover State Tab
		$this->start_controls_tab(
			'menu_color_tab_hover_state_sub-menu',
			[ 
				'label' => esc_html__( 'Hover', THEME_NAME ),
			]
		);

		$this->add_control(
			'menu_color_hover_sub-menu',
			[ 
				'label' => esc_html__( 'Item Color', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [ 
					'{{WRAPPER}} .theme-header-nav li.menu-item > a:hover, {{WRAPPER}} .theme-header-nav li.current-menu-item > a, {{WRAPPER}} .theme-header-nav li.current-menu-ancestor > a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .header-vertical-nav li.menu-item > a:hover, {{WRAPPER}} .header-vertical-nav li.current-menu-item > a' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'first_icon_section_hover_sub-menu',
			[ 
				'label' => esc_html__( 'first icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'first-menu-icon_hover_sub-menu', 'li.menu-item.menu-item-has-children:hover .sub-menu li.menu-item:hover .first-menu-icon', $align = false );

		$this->add_control(
			'first_hover_media_section_hover_sub-menu',
			[ 
				'label' => esc_html__( 'first hover image', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_image_style( 'first-hover-media_hover_sub-menu', 'li.menu-item.menu-item-has-children:hover .sub-menu li.menu-item:hover .first-hover-media' );

		$this->add_control(
			'title-container_section_hover_sub-menu',
			[ 
				'label' => esc_html__( 'title container', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_container_style( 'title-container_hover_sub-menu', 'li.menu-item.menu-item-has-children:hover .sub-menu li.menu-item:hover .title-container' );

        $this->add_control(
			'title-container_section_hover_sub-menu',
			[ 
				'label' => esc_html__( 'title', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'title_hover_sub-menu', 'li.menu-item.menu-item-has-children:hover .sub-menu li.menu-item:hover a', $align = false );

		$this->add_control(
			'dropdown_icon_section_hover_sub-menu',
			[ 
				'label' => esc_html__( 'dropdown icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'dropdown-icon_hover_sub-menu', 'li.menu-item.menu-item-has-children:hover .sub-menu li.menu-item:hover .dropdown-icon', $align = false );

		$this->add_control(
			'second_hover_media_section_hover_sub-menu',
			[ 
				'label' => esc_html__( 'second hover image', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_image_style( 'second-hover-media_hover_sub-menu', 'li.menu-item.menu-item-has-children:hover .sub-menu li.menu-item:hover .second-hover-media' );


		$this->add_control(
			'second_icon_section_hover_sub-menu',
			[ 
				'label' => esc_html__( 'second icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'second-menu-icon_hover_sub-menu', 'li.menu-item.menu-item-has-children:hover .sub-menu li.menu-item:hover .second-menu-icon', $align = false );

		$this->add_control(
			'h_menu_hover_shape',
			[ 
				'label' => esc_html__( 'Hover Shape', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'condition' => [ 'menu_type' => 'horizontal' ],
				'options' => [ 
					'hover-style-1' => esc_html__( 'Style 1', THEME_NAME ),
					'hover-style-2' => esc_html__( 'Style 2', THEME_NAME ),
					'hover-style-3' => esc_html__( 'Style 3', THEME_NAME ),
					'hover-style-4' => esc_html__( 'Style 4', THEME_NAME ),
					'hover-style-5' => esc_html__( 'Style 5', THEME_NAME ),
				],
			]
		);

		$this->add_control(
			'h_menu_hover_shape_color',
			[ 
				'label' => esc_html__( 'Hover Shape Color', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [ 'menu_type' => 'horizontal' ],
				'selectors' => [ 
					'{{WRAPPER}} .theme-header-nav > li.menu-item > a::before' => 'background: {{VALUE}}',
					'{{WRAPPER}} .theme-header-nav-wrapper.hover-style-4 > ul > li.menu-item > a:hover, {{WRAPPER}} .theme-header-nav-wrapper.hover-style-4 > ul > li.current-menu-item > a, {{WRAPPER}} .theme-header-nav-wrapper.hover-style-4 > ul > li.current-menu-ancestor > a' => 'background: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();
	}

    protected function register_controls() {
        $this->register_content_section_1();

        $this->register_style_section_1();
		$this->register_style_section_2();
	}

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        
		if( !empty($settings['menu']) ) {
            
            $hover_shape = ! empty( $settings['h_menu_hover_shape'] ) ? $settings['h_menu_hover_shape'] : '';

            if( $settings['menu_type'] == 'vertical' ) { // Vertical Menu

                echo '<nav class="theme-header-nav-wrapper header-vertical-nav ' . $hover_shape . '">';
                wp_nav_menu( array(
                    'menu' => $settings['menu'],
                    'link_before' => '<span>',
                    'link_after'=>'</span>',
                    'fallback_cb' => false,
                    'container' => false,
					'menu_class' => 'theme-header-nav',
                ) );
                echo '</nav>';

            }
            else { // Horizontal Menu

                echo '<nav class="theme-header-nav-wrapper ' . $hover_shape . '">';
                wp_nav_menu( array(
                    'menu' => $settings['menu'],
                    'link_before' => '<span>',
                    'link_after'=>'</span>',
                    'fallback_cb' => false,
                    'container' => false,
                    'menu_class' => 'theme-header-nav',
                ) );
                echo '</nav>';

            }
        }
    }


}