<?php



use handler\basic_element;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class ar_mega_menu extends \Elementor\Widget_Base{
    
    use basic_element;
    public function get_name(){
        return 'ar_mega_menu';
    }

    public function get_title(){
        return esc_html__( 'mega menu', THEME_NAME );
    }

    public function get_icon(){
        return 'ar_mega_menu';
    }

    public function get_categories(){
        return ['core-elementor-elements'];
    }

    protected function register_mega_menu($tab){
        $this->start_controls_section(
            'mega_menu_tab_' . $tab,
            [
                'label' => esc_html__( 'content tab ', THEME_NAME ) . $tab,
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'mega_menu_icon_' . $tab,
            [
                'label' => esc_html__( 'icon ', THEME_NAME ) . $tab,
                'type' => \Elementor\Controls_Manager::ICONS,

            ]
        ); 

        $this->add_control(
            'mega_menu_title_tab_' . $tab,
            [
                'label' => esc_html__( 'tab title', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );

		$this->add_control(
			'kind' . $tab,
			[ 
				'label' => esc_html__( 'kind', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'content',
				'options' => [ 
					'content' => esc_html__( 'content', THEME_NAME ),
					'list' => esc_html__( 'list', THEME_NAME ),
				
				],
				'render_type' => 'template',
			]
		);

		$this->add_control(
			'content_template' . $tab,
			[ 
				'label' => esc_html__( 'Content Template', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => get_all_header_template(),
				'default' => '0',
				'condition' => [ 
					'kind'. $tab => 'content',
				],
			]
		);

        $this->add_control(
			'mega_menu_icon_2_' . $tab,
			[ 
				'label' => esc_html__( 'image', THEME_NAME ) . $tab,
				'type' => \Elementor\Controls_Manager::MEDIA,
				'dynamic' => [ 
					'active' => true,
				]
			]
		);

		for($i = 1; $i<=11; $i++){
            $this->add_control(
                'mega_menu_sep_' . $tab . '_' . $i,
                [
                    'label' => esc_html__( 'col ', THEME_NAME ) . $i,
                    'type' => \Elementor\Controls_Manager::HEADING,
                    'separator' => 'before',
					'condition' => [ 
						'kind' . $tab => 'list',
					],
                ]
            ); 

            $this->add_control(
                'mega_menu_active_' . $tab . '_' . $i,
                [
                    'label'     => esc_html__( 'anable col ', THEME_NAME ) . $i,
                    'type'      => \Elementor\Controls_Manager::SWITCHER,
                    'default'   => 'yes',
					'condition' => [ 
						'kind' . $tab => 'list',
					],
                ]
            );	

            $this->add_control(
                'mega_menu_title_col_' . $tab . '_' . $i,
                [
                    'label' => esc_html__( 'Title col ', THEME_NAME ) . $i,
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'condition' => [
                        'mega_menu_active_' . $tab . '_' . $i => 'yes',
						'kind' . $tab => 'list',
                    ],
                ]
            );

            $repeater = new \Elementor\Repeater(); 

            $repeater->add_control(
                'mega_menu_title_item_' . $tab . '_' . $i,
                [
                    'label' => esc_html__( 'Title', THEME_NAME ),
                    'type' => \Elementor\Controls_Manager::TEXT,
                ]
            );

            $repeater->add_control(
                'mega_menu_link_item_' . $tab . '_' . $i,
                [
                    'label' => esc_html__( 'Link', THEME_NAME ),
                    'type' => \Elementor\Controls_Manager::TEXT,
                ]
            );

            $this->add_control(
                'mega_menu_list_' . $tab . '_' . $i,
                [
                    'label' => esc_html__( 'List ' , THEME_NAME ) . $i,
                    'type' => \Elementor\Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                    'condition' => [
                        'mega_menu_active_' . $tab . '_' . $i => 'yes',
						'kind' . $tab => 'list',
                    ],
                ]
            );
        }
        $this->end_controls_section();
    }

    protected function register_content_section_1() {
        $this->start_controls_section(
            'tab_count_section',
            [
                'label' => esc_html__( 'tab count', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'tab_count',
            [
                'label' => esc_html__( 'tab count', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '5',
                'options' => [
                    '1'  => esc_html__( '1', THEME_NAME ),
                    '2' => esc_html__( '2', THEME_NAME ),
                    '3' => esc_html__( '3', THEME_NAME ),
                    '4' => esc_html__( '4', THEME_NAME ),
                    '6' => esc_html__( '6', THEME_NAME ),
                    '7' => esc_html__( '7', THEME_NAME ),
                    '8' => esc_html__( '8', THEME_NAME ),
                    '9' => esc_html__( '9', THEME_NAME ),
                    '10' => esc_html__( '10', THEME_NAME ),
                    '11' => esc_html__( '11', THEME_NAME ),
                ],
            ]
        );

        $this->end_controls_section();
        for($i = 1; $i<=11; $i++){
            $this->register_mega_menu($i);
        }
    }

    protected function register_style_section_1() {
        $this->start_controls_section(
            'mega-menu',
            [
                'label' => esc_html__('Style mega menu', THEME_NAME),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->register_container_style('mega-menu',  '.mega-menu');
         $this->end_controls_section();
    }

    protected function register_style_section_2() {
        $this->start_controls_section(
            'mega-menu-tabs',
            [
                'label' => esc_html__('Style mega menu tabs', THEME_NAME),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->register_container_style('mega-menu-tabs',  '.mega-menu-tabs');

        $this->start_controls_tabs( 'tabs-item' );

        // Tab 1: normal
        $this->start_controls_tab(
            'normal',
            [
                'label' => esc_html__( 'normal', THEME_NAME ),
            ]
        );

        $this->register_text_style('mega-menu-tabs-normal',  '.mega-menu-tab', $align=false);

        $this->add_control(
            'mega_menu_sep_first_icon_normal',
            [
                'label' => esc_html__( 'first icon', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        ); 
        $this->register_text_style('mega-menu-tabs-normal-first-icon',  '.mega-menu-tab .first-icon', $align=false);

		$this->add_control(
			'mega_menu_sep_last_icon_normal',
			[ 
				'label' => esc_html__( 'last icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->register_image_style( 'mega-menu-tabs-normal-last-icon', '.mega-menu-tab .last-icon', $align = false );

        $this->end_controls_tab();

        // Tab 2: hover
        $this->start_controls_tab(
            'hover',
            [
                'label' => esc_html__( 'hover', THEME_NAME ),
            ]
        );

        $this->register_text_style('mega-menu-tabs-hover',  '.mega-menu-tab:hover', $align=false);

        $this->add_control(
                'mega_menu_sep_first_icon_hover',
                [
                    'label' => esc_html__( 'first icon', THEME_NAME ),
                    'type' => \Elementor\Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            ); 
        $this->register_text_style('mega-menu-tabs-hover-first-icon',  '.mega-menu-tab:hover .first-icon', $align=false);

		$this->add_control(
			'mega_menu_sep_last_icon_hover',
			[ 
				'label' => esc_html__( 'last icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->register_image_style( 'mega-menu-tabs-hover-last-icon', '.mega-menu-tab:hover .last-icon', $align = false );

        $this->end_controls_tab();

        // Tab 2: active
        $this->start_controls_tab(
            'active',
            [
                'label' => esc_html__( 'active', THEME_NAME ),
            ]
        );

        $this->register_text_style('mega-menu-tabs-active',  '.mega-menu-tab.active', $align=false);

        $this->add_control(
                'mega_menu_sep_first_icon_active',
                [
                    'label' => esc_html__( 'first icon', THEME_NAME ),
                    'type' => \Elementor\Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            ); 
        $this->register_text_style('mega-menu-tabs-active-first-icon',  '.mega-menu-tab.active .first-icon', $align=false);

		$this->add_control(
			'mega_menu_sep_last_icon_active',
			[ 
				'label' => esc_html__( 'last icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->register_image_style( 'mega-menu-tabs-active-last-icon', '.mega-menu-tab.active .last-icon', $align = false );

        $this->end_controls_tab();


        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function register_style_section_3() {
        $this->start_controls_section(
            'mega-menu-container',
            [
                'label' => esc_html__('Style items', THEME_NAME),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->register_container_style('mega-menu-tab-contents',  '.mega-menu-tab-contents-item');

        $this->add_control(
            'mega_menu_sep_title',
            [
                'label' => esc_html__( 'title', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        ); 

        $this->register_text_style('mega-menu-tab-contents-title',  '.title');

        $this->add_control(
            'mega_menu_sep_items',
            [
                'label' => esc_html__( 'items', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        ); 

        $this->register_text_style('mega-menu-tab-contents-items',  'a', $align=false);

        $this->end_controls_section();
    }

    protected function register_controls(){

        $this->register_content_section_1();

        $this->register_style_section_1();  
        $this->register_style_section_2();  
        $this->register_style_section_3();  
    }
 


  protected function render(){
    $settings = $this->get_settings_for_display();
    $mega_menu_id = $this->get_id();
  
    ?>
    <div class="mega-menu" data-menu-id="<?php echo $mega_menu_id; ?>">
		<div class="mega-menu-tabs">
			<?php $tab_count = (int) $settings['tab_count']; ?>
			<?php for ( $tab = 1; $tab <= $tab_count; $tab++ ) { ?>
				<span class="d-flex flex-row justify-content-between mega-menu-tab <?php if ( $tab == 1 ) { ?>active<?php } ?>"
					data-target="mega-menu-<?php echo $mega_menu_id . '-' . $tab; ?>">
					<div class="d-flex align-items-center">
						<i class="first-icon <?php echo esc_attr( $settings[ 'mega_menu_icon_' . $tab ]['value'] ); ?>"></i>
						<?php echo esc_html( $settings[ 'mega_menu_title_tab_' . $tab ] ); ?>
					</div>
					<div class="last-icon d-flex align-items-center justify-content-center">
						<img src="<?php echo esc_url( $settings[ 'mega_menu_icon_2_' . $tab ]['url'] ); ?>">
					</div>
				</span>
			<?php } ?>
		</div>
		<div class="mega-menu-tab-contents">
			<?php for ( $tab = 1; $tab <= $tab_count; $tab++ ) { ?>
				<div class="mega-menu-tab-contents-item <?php if ( $tab == 1 ) { ?>active<?php } ?>"
					data-tab="mega-menu-<?php echo $mega_menu_id . '-' . $tab; ?>">
					<?php
					if ( $settings[ 'kind' . $tab ] == 'content' ) {
						$template = show_template( $settings[ 'content_template' . $tab ] );
						echo ( $template );
					} else {
						for ( $i = 1; $i <= 11; $i++ ) {
							if ( $settings[ 'mega_menu_active_' . $tab . '_' . $i ] == 'yes' ) {
								?>
								<div class="col-mega-menu">
									<div class="title">
										<?php echo esc_html( $settings[ 'mega_menu_title_col_' . $tab . '_' . $i ] ); ?>
									</div>
									<?php
									if ( $settings[ 'mega_menu_list_' . $tab . '_' . $i ] ) {
										foreach ( $settings[ 'mega_menu_list_' . $tab . '_' . $i ] as $item ) { ?>
											<div>
												<a href="<?php echo esc_url( $item[ 'mega_menu_link_item_' . $tab . '_' . $i ] ); ?>"
													class="d-block"><?php echo esc_html( $item[ 'mega_menu_title_item_' . $tab . '_' . $i ] ); ?></a>
											</div>
										<?php }
									} ?>
								</div>
							<?php }
						}
					} ?>
				</div>
			<?php } ?>
        </div>
    </div>
    <script> 
        document.querySelectorAll('.mega-menu').forEach(function(menu) {
        var menuId = menu.getAttribute('data-menu-id');
        var tabs = menu.querySelectorAll(".mega-menu-tabs span");

        if (tabs.length > 0) {
            tabs.forEach(function(tab) {
                tab.addEventListener("mouseover", function(ev) {
                    const el = ev.currentTarget,
                        target = el.dataset.target,
                        content = menu.querySelector(`[data-tab="${target}"]`);

                    if (content) {
                        // Remove 'active' class from all tabs and content items within this specific menu
                        tabs.forEach(function(tabItem) {
                            tabItem.classList.remove("active");
                        });
                        menu.querySelectorAll(".mega-menu-tab-contents-item").forEach(function(contentItem) {
                            contentItem.classList.remove("active");
                        });

                        // Add 'active' class to the current tab and corresponding content
                        el.classList.add("active");
                        content.classList.add("active");

                        // Handle the opacity transition effect
                        content.style.opacity = 0;
                        setTimeout(function() {
                            content.style.opacity = 1;
                            content.removeAttribute("style");
                        }, 50);
                    }
                });
            });
        }
    });


    </script>
    <?php
  }


}
