<?php

use handler\basic_element;

class ar_login extends \Elementor\Widget_Base {

    use basic_element;

    public function get_name() {
        return 'ar_login';
    }

    public function get_title() {
        return __('Login Widget', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_login';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }
    
    protected function register_content_section_1() {
        $this->start_controls_section(
            'login_form_labels_section',
            [
                'label' => __( 'Login Form Labels', THEME_NAME ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,

            ]
        );

        $this->add_control(
            'username_label',
            [
                'label' => __( 'Username Label', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Username', THEME_NAME ),
            ]
        );

        $this->add_control(
            'username_placeholder',
            [
                'label' => __( 'Username placeholder', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Username', THEME_NAME ),
            ]
        );

        $this->add_control(
            'password_label',
            [
                'label' => __( 'Password Label', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Password', THEME_NAME ),
            ]
        );

        $this->add_control(
            'password_placeholder',
            [
                'label' => __( 'Password placeholder', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Password', THEME_NAME ),
            ]
        );

        $this->add_control(
            'keep_password',
            [
                'label' => __( 'keep password', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Remember Me', THEME_NAME ),
            ]
        );

        $this->add_control(
            'reset_password',
            [
                'label' => __( 'reset password?', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'reset Password', THEME_NAME ),
            ]
        );

        $this->add_control(
            'not_register_text',
            [
                'label' => __( 'not registered text', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'didnt register?', THEME_NAME ),
            ]
        );

        $this->add_control(
            'register_text',
            [
                'label' => __( 'register text', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'register', THEME_NAME ),
            ]
        );

        $this->add_control(
			'register_link',
			[
				'label' => __( 'register link', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::URL,
				'options' => [ 'url', 'is_external', 'nofollow' ],
			]
		);

        $this->add_control(
            'login_text',
            [
                'label' => __( 'login text', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'login', THEME_NAME ),
            ]
        );

        $this->end_controls_section();
    }

    protected function register_style_section_1() {
        $this->start_controls_section(
            'login_form_style_section',
            [
                'label' => __( 'Login Form Styles', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('inputs',  '.login-form-container input');

        $this->add_control(
			'labels',
			[
				'label' => esc_html__( 'labels', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_text_style('labels',  '.login-form-container label', $align=false);
        
        $this->end_controls_section();
    }

    protected function register_style_section_2() {
        $this->start_controls_section(
            'other_form_style_section',
            [
                'label' => __( 'other text Styles', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
			'links',
			[
				'label' => esc_html__( 'links', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->register_text_style('login_link',  '.login-link', $align=false);
    
        $this->add_control(
			'texts',
			[
				'label' => esc_html__( 'texts', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_text_style('login_text',  '.login-text', $align=false);

        $this->add_control(
			'btn',
			[
				'label' => esc_html__( 'buttom', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_text_style('login_btn',  '.login-btn', $align=false);

        $this->add_control(
			'icons',
			[
				'label' => esc_html__( 'icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_text_style('isax',  '.isax', $align=false);

        $this->end_controls_section();
    }

    protected function register_controls() {

        $this->register_content_section_1();

        $this->register_style_section_1();       
        $this->register_style_section_2();       
    
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="login-form-container">
            <form action="<?php echo esc_url( site_url( 'wp-login.php', 'login_post' ) ); ?>" method="post">
                <div class="form-group">
                    <div class="input-group">
                        <label><?php echo esc_attr( $settings['username_label'] ); ?></label>
                        <div class="input-container">
                            <input type="text" class="form-control" name="log" id="user_login" placeholder="<?php echo esc_attr( $settings['username_placeholder'] ); ?>">
                            <span class="input-group-text">
                                <i class="isax isax-sms4"></i>
                            </span>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <div class="input-group">
                        <label><?php echo esc_attr( $settings['password_label'] ); ?></label>
                        <div class="input-container">
                            <input type="password" class="form-control" name="pwd" id="user_pass" placeholder="<?php echo esc_attr( $settings['password_placeholder'] ); ?>" autocomplete>
                            <span class="input-group-text toggle-password">
                                <i class="isax isax-eye"></i>
                            </span>
                        </div>
                    </div>
                </div>
                <div class="form-meta">
                    <?php if($settings['keep_password']){ ?>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="" id="remember_me">
                        <label class="form-check-label" for="remember_me" class="login-text">
                            <?php echo esc_attr( $settings['keep_password'] ); ?>
                        </label>
                    </div>
                    <?php }
                    if($settings['reset_password']){ ?>

                    <div class="form-reset">
                        <a class="login-link" href="../my-account/lost-password/"><?php echo esc_attr( $settings['reset_password'] ); ?></a>
                    </div>
                    <?php } ?>
                </div>

                <div class="form-register">
                    <?php if($settings['not_register_text']){ ?>
                        <p class="login-text" >
                            <?php echo esc_attr( $settings['not_register_text'] ); ?>
                        </p>
                    <?php }
                    if($settings['register_link']){ ?>
                        <a class="login-link" href="<?php echo esc_attr( $settings['register_link']['url'] ); ?>"><?php echo esc_attr( $settings['register_text'] ); ?></a>
                    <?php } ?>
                </div>

                <div class="form-group">
                    <input type="submit" class="btn btn-primary login-btn" value="<?php echo esc_attr( $settings['login_text'] ); ?>">
                </div>
            </form>
        </div>
        <script>
            document.addEventListener('DOMContentLoaded', function() {
            var togglePassword = document.querySelector('.toggle-password');
            var passwordInput = document.getElementById('user_pass');
            var passwordIcon = togglePassword.querySelector('i');
            togglePassword.addEventListener('click', function() {
                if (passwordInput.type === 'password') {
                    passwordInput.type = 'text';
                    passwordIcon.classList.remove('isax-eye');
                    passwordIcon.classList.add('isax-eye-slash4');
                } else {
                    passwordInput.type = 'password';
                    passwordIcon.classList.remove('isax-eye-slash4');
                    passwordIcon.classList.add('isax-eye');
                }
            });
        });
        </script>
        <?php
    }


}