<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_counter_down extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_counter_down';
    }

    public function get_title() {
        return esc_html__('counter down', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_counter_down';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_content_section_1() {
        $this->start_controls_section(
            'login_form_labels_section',
            [
                'label' => __( 'date', THEME_NAME ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,

            ]
        );

		$this->add_control(
			'event_date',
			[ 
				'label' => __( 'choose date', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::DATE_TIME,
			]
		);
        $this->end_controls_section();
    } 

    protected function register_style_section_1(){
		$this->start_controls_section(
			'cart_text',
			[ 
				'label' => esc_html__( 'direction', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'text_align', [ 
				'label' => esc_html__( 'Alignment', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [ 
					'column' => [ 
						'title' => esc_html__( 'column', THEME_NAME ),
					],
					'column-reverse' => [ 
						'title' => esc_html__( 'column reverse', THEME_NAME ),
					],
					'row' => [ 
						'title' => esc_html__( 'row', THEME_NAME ),
					],
					'row-reverse' => [ 
						'title' => esc_html__( 'row reverse', THEME_NAME ),
					],
				],
				'default' => '',
				'selectors' => [ 
					'{{WRAPPER}} .countdown-timer' => 'flex-direction: {{VALUE}};',
				],
			]
		);


		$this->end_controls_section();
    }

	protected function register_style_section_2() {
		$this->start_controls_section(
			'top-part',
			[ 
				'label' => esc_html__( 'card top', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_container_style( 'top-part', '.top-part' );

		$this->add_control(
			'top-part-text',
			[ 
				'label' => esc_html__( 'text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);


		$this->register_text_style( 'top-part-text', '.top-part' );


		$this->end_controls_section();
	}

	protected function register_style_section_3() {
		$this->start_controls_section(
			'card__bottom',
			[ 
				'label' => esc_html__( 'card bottom', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_container_style( 'bottom-part', '.bottom-part' );

		$this->add_control(
			'bottom-part-text',
			[ 
				'label' => esc_html__( 'text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);


		$this->register_text_style( 'bottom-part-text', '.bottom-part' );

		$this->end_controls_section();
	}

	protected function register_style_section_4() {
		$this->start_controls_section(
			'cart-days',
			[ 
				'label' => esc_html__( 'days', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_container_style( 'cart-day-top-part', '.countdown-days .top-part' );

		$this->add_control(
			'cart-day-top-part-text',
			[ 
				'label' => esc_html__( 'text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'cart-day-top-part-text', '.countdown-days .top-part' );

		$this->add_control(
			'cart-day-down-part',
			[ 
				'label' => esc_html__( 'down part', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_container_style( 'cart-day-bottom-part', '.countdown-days .bottom-part' );

		$this->add_control(
			'cart-day-down-part-text',
			[ 
				'label' => esc_html__( 'text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'cart-day-bottom-part-text', '.countdown-days .bottom-part' );

		$this->end_controls_section();
	}

	protected function register_style_section_5() {
		$this->start_controls_section(
			'cart-hours',
			[ 
				'label' => esc_html__( 'hours', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_container_style( 'cart-hours-top-part', '.countdown-hours .top-part' );

		$this->add_control(
			'cart-hours-top-part-text',
			[ 
				'label' => esc_html__( 'text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'cart-hours-top-part-text', '.countdown-hours .top-part' );

		$this->add_control(
			'cart-hours-down-part',
			[ 
				'label' => esc_html__( 'down part', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_container_style( 'cart-hours-bottom-part', '.countdown-hours .bottom-part' );

		$this->add_control(
			'cart-hours-down-part-text',
			[ 
				'label' => esc_html__( 'text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'cart-hours-bottom-part-text', '.countdown-hours .bottom-part' );

		$this->end_controls_section();
	}

	protected function register_style_section_6() {
		$this->start_controls_section(
			'cart-minutes',
			[ 
				'label' => esc_html__( 'minutes', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_container_style( 'cart-minutes-top-part', '.countdown-minutes .top-part' );

		$this->add_control(
			'cart-minutes-top-part-text',
			[ 
				'label' => esc_html__( 'text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'cart-minutes-top-part-text', '.countdown-minutes .top-part' );

		$this->add_control(
			'cart-minutes-down-part',
			[ 
				'label' => esc_html__( 'down part', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_container_style( 'cart-minutes-bottom-part', '.countdown-minutes .bottom-part' );

		$this->add_control(
			'cart-minutes-down-part-text',
			[ 
				'label' => esc_html__( 'text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'cart-minutes-bottom-part-text', '.countdown-minutes .bottom-part' );

		$this->end_controls_section();
	}

	protected function register_style_section_7() {
		$this->start_controls_section(
			'cart-seconds',
			[ 
				'label' => esc_html__( 'seconds', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_container_style( 'cart-seconds-top-part', '.countdown-seconds .top-part' );

		$this->add_control(
			'cart-seconds-top-part-text',
			[ 
				'label' => esc_html__( 'text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'cart-seconds-top-part-text', '.countdown-seconds .top-part' );

		$this->add_control(
			'cart-seconds-down-part',
			[ 
				'label' => esc_html__( 'down part', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_container_style( 'cart-seconds-bottom-part', '.countdown-seconds .bottom-part' );

		$this->add_control(
			'cart-seconds-down-part-text',
			[ 
				'label' => esc_html__( 'text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'cart-seconds-bottom-part-text', '.countdown-seconds .bottom-part' );

		$this->end_controls_section();
	}

    protected function register_controls() {

        $this->register_content_section_1();
		$this->register_style_section_1();
		$this->register_style_section_2();
		$this->register_style_section_3();
		$this->register_style_section_4();
		$this->register_style_section_5();
		$this->register_style_section_6();
		$this->register_style_section_7();
	}
    
    protected function render() {
        $settings = $this->get_settings_for_display();
		$id = $this->get_id();
        ?>
        <div class="countdown-wrapper" data-event-date="<?php echo esc_html( $settings['event_date'] ); ?>">
            <div class="countdown-timer d-flex justify-content-center align-items-center gap-3">
                <div class="countdown-column countdown-days d-flex flex-column justify-content-center align-items-center">
                    <div class="top-part" id="days"></div>
                    <div class="bottom-part"><?php echo __('Days', THEME_NAME);?></div>
                </div>
                <div class="countdown-column countdown-hours d-flex flex-column justify-content-center align-items-center">
                    <div class="top-part" id="hours"></div>
                    <div class="bottom-part"><?php echo __( 'Hours', THEME_NAME ); ?></div>
                </div>
                <div class="countdown-column countdown-minutes d-flex flex-column justify-content-center align-items-center">
                    <div class="top-part" id="minutes"></div>
                    <div class="bottom-part"><?php echo __( 'Minutes', THEME_NAME ); ?></div>
                </div>
                <div class="countdown-column countdown-seconds d-flex flex-column justify-content-center align-items-center">
                    <div class="top-part" id="seconds"></div>
                    <div class="bottom-part"><?php echo __( 'Seconds', THEME_NAME ); ?></div>
                </div>
            </div>
        </div>

        <script>

           jQuery(document).ready(function($) {
                // Function to initialize the countdown timer
                function initializeCountdown($element, targetDate) {
                    function updateTimer() {
                        var now = new Date().getTime();
                        var distance = targetDate - now;

                        // Time calculations for days, hours, minutes, and seconds
                        var days = Math.floor(distance / (1000 * 60 * 60 * 24));
                        var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                        var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                        var seconds = Math.floor((distance % (1000 * 60)) / 1000);

                        // Display the results in the relevant elements
                        $element.find('#days').text(days);
                        $element.find('#hours').text(hours);
                        $element.find('#minutes').text(minutes);
                        $element.find('#seconds').text(seconds);

                        // If the countdown is over, clear the interval and hide the timer
                        if (distance < 0) {
                            clearInterval(interval);
                            $element.find('.countdown-timer').text('Event Ended');
                        }
                    }

                    // Update the countdown every second
                    var interval = setInterval(updateTimer, 1000);
                    updateTimer();  // Trigger the first update immediately
                }

                // Iterate through each countdown wrapper and initialize the countdown timer
                $('.countdown-wrapper').each(function() {
                    var eventDateStr = $(this).data('event-date');
                    var targetDate = new Date(eventDateStr).getTime();
                    initializeCountdown($(this), targetDate);
                });

                // Switcher control to toggle visibility of each column
                $('.countdown-wrapper').each(function() {
                    var $countdown = $(this);
                    // Add the switcher controls (just for demonstration)
                    var showDays = true;
                    var showHours = true;
                    var showMinutes = true;
                    var showSeconds = true;

                    if (!showDays) {
                        $countdown.find('.countdown-days').hide();
                    }
                    if (!showHours) {
                        $countdown.find('.countdown-hours').hide();
                    }
                    if (!showMinutes) {
                        $countdown.find('.countdown-minutes').hide();
                    }
                    if (!showSeconds) {
                        $countdown.find('.countdown-seconds').hide();
                    }
                });
            });


        </script>
        <?php
    }

}