<?php
namespace shopex_icons;

if ( ! defined( 'ABSPATH' ) ) exit;

class shopex_icon_class {

	public static $_instance;

	public static function get_instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

	function __construct() {
		add_filter( 'elementor/icons_manager/additional_tabs', [ $this, 'shopex_icon' ] );
	}

	public function shopex_icon( $arg = array() ) {

		$icons = array(
			"c1",
			"c2",
			"c3",
			"c4",
			"c5",
			"c6",
			"c7",
			"c8",
		);

		$arg['shopex'] = [ 
			'name' => 'shopex icons',
			'label' => esc_html__( 'shopex icons', THEME_NAME ),
			'prefix' => 'shopex-',
			'displayPrefix' => '',
	        'url' => get_template_directory_uri() . '/assets/css/shopex.css',
			'icons' => $icons,
			'ver' => 1.0,
		];

		return $arg;
	}

}
shopex_icon_class::get_instance();