<?php
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

// Set Container Width
$site_width = absint(option_value('site-width')) ?: '1240';
$custom_css .= ":not(body.page-template-elementor_theme) > div.container { max-width: " . $site_width . "px !important; } \n";
$custom_css .= "body .elementor-section.elementor-section-boxed > .elementor-container { max-width: " . $site_width . "px; }\n";
$custom_css .= "body .e-con { --container-max-width: " . $site_width . "px ; }\n";
$custom_css .= "main.site-main { max-width: " . $site_width . "px; margin: 0 auto; }\n";
$custom_css .= "body.page-template-elementor_theme { max-width: " . $site_width . "px !important; margin: 0 auto;}\n";
$colors = theme_colors();
foreach ($colors as $color_key => $color_value) {
    if(option_value($color_key)) {
        $custom_css .= ":root { --$color_key: " . option_value($color_key) . ";}\n";
    }
}

$custom_fonts_dir = WP_CONTENT_DIR . '/uploads/redux/custom-fonts/custom/';
$font_dirs = glob( $custom_fonts_dir . '*', GLOB_ONLYDIR );

foreach ( $font_dirs as $font_dir ) {
	$font_name = basename( $font_dir );
	$uploads_dir = wp_upload_dir();
	$font_folder = $uploads_dir['basedir'] . '/redux/custom-fonts/custom/' . $font_name;
	$font_files = glob( $font_folder . '/*.{ttf,woff,woff2,otf}', GLOB_BRACE );

	if ( ! empty( $font_files ) ) {
		foreach ( $font_files as $font_file ) {
			$file_name = basename( $font_file );
			$file_ext = pathinfo( $font_file, PATHINFO_EXTENSION );
			$file_base_name = pathinfo( $file_name, PATHINFO_FILENAME );

			// Extract weight information from the filename
			if ( preg_match( '/(\d{3})/', $file_base_name, $matches ) ) {
				$font_weight = $matches[1];
			} else {
				$font_weight = '400'; // Default to normal weight if not found
			}

			$format = '';
			switch ( $file_ext ) {
				case 'ttf':
					$format = 'truetype';
					break;
				case 'woff':
					$format = 'woff';
					break;
				case 'woff2':
					$format = 'woff2';
					break;
				case 'otf':
					$format = 'opentype';
					break;
			}

			$font_relative_path = str_replace( ABSPATH, '/', $font_file );
			$font_url = home_url( $font_relative_path );

			$custom_css .= "@font-face {\n";
			$custom_css .= "font-family: '{$font_name}';\n";
			$custom_css .= "font-weight: {$font_weight};\n";
			$custom_css .= "src: url('{$font_url}') format('{$format}');\n";
			$custom_css .= "}\n";
		}
	}
}

$tags = theme_title_tag();
foreach ($tags as $tag => $tag_name) {
    if (option_value("typography-$tag_name", 'font-family')) {
        $custom_css .= "$tag {";
        $custom_css .= "font-family: " . option_value("typography-$tag_name", 'font-family') . ";\n";

        if (option_value("typography-$tag_name", 'font-weight')) {
            $custom_css .= "font-weight: " . option_value("typography-$tag_name", 'font-weight') . ";\n";
        }
        if (option_value("typography-$tag_name", 'font-style')) {
            $custom_css .= "font-style: " . option_value("typography-$tag_name", 'font-style') . ";\n";
        }
        if (option_value("typography-$tag_name", 'color')) {
            $custom_css .= "color: " . option_value("typography-$tag_name", 'color') . ";\n";
        }
        if (option_value("typography-$tag_name", 'font-size')) {
            $custom_css .= "font-size: " . option_value("typography-$tag_name", 'font-size') . "!important;\n";
        }
        if (option_value("typography-$tag_name", 'text-align')) {
            $custom_css .= "text-align: " . option_value("typography-$tag_name", 'text-align') . "!important;\n";
        }

        $custom_css .= "}\n";
    }
}

// Styling
if(option_value('body-bg')) {
    $custom_css .= 'body { background: ' . option_value('body-bg') . ';}\n';
}

if(option_value('link-color-hover')) {
    $custom_css .= 'a:hover, a:focus, a:active { color: ' . option_value('link-color-hover') . ';}\n';
}

if(option_value('single-progress-bar-color')) {
    $custom_css .= '.post-reading-progress-indicator span { background: ' . option_value('single-progress-bar-color') . ';}\n';
}

/* Footer Elements */
if(option_value('scroll-up-bg')) {
    $custom_css .= '#scroll-up { background: ' . option_value('scroll-up-bg') . ';}';
}

if(option_value('scroll-up-icon-color')) {
    $custom_css .= '#scroll-up i{ color: ' . option_value('scroll-up-icon-color') . ';}';
}

if(option_value('scroll-up-position') == 'left') {
    $custom_css .= '#scroll-up{ right: unset; left: '.option_value('scroll-up-margin').'px;}';
    $custom_css .= '#scroll-up.show{ bottom: '.option_value('scroll-up-margin').'px;}';
}

if(option_value('scroll-up-position') == 'right') {
    $custom_css .= '#scroll-up{ left: unset; right: '.option_value('scroll-up-margin').'px;}';
    $custom_css .= '#scroll-up.show{ bottom: '.option_value('scroll-up-margin').'px;}';
}

/* Blog Archive Title */
if(option_value('blog-archive-title-bg')) {
    $custom_css .= '.blog-archive-title { background: ' . option_value('blog-archive-title-bg') . ';}\n';
}

if(option_value('blog-archive-title-color')) {
    $custom_css .= '.blog-archive-title, .blog-archive-title .title { color: ' . option_value('blog-archive-title-color') . ';}\n';
}
if(option_value('theme-preloader-kind') == 'pre build'){
    switch(option_value('theme-preloader-pre-build')){
        case (1):
            $custom_css .='
                .loader {
                    width: 48px;
                    height: 48px;
                    border: 5px solid #FFF;
                    border-bottom-color: var(--theme-primary-color);
                    border-radius: 50%;
                    display: inline-block;
                    box-sizing: border-box;
                    animation: rotation 1s linear infinite;
                    }

                    @keyframes rotation {
                    0% {
                        transform: rotate(0deg);
                    }
                    100% {
                        transform: rotate(360deg);
                    }
                }  
            ';
            break;
        case (2):
            $custom_css .='.loader {
        width: 48px;
        height: 48px;
        border-radius: 50%;
        position: relative;
        animation: rotate 1s linear infinite
        }
        .loader::before {
        content: "";
        box-sizing: border-box;
        position: absolute;
        inset: 0px;
        border-radius: 50%;
        border: 5px solid var(--theme-primary-color);
        animation: prixClipFix 2s linear infinite ;
        }

        @keyframes rotate {
        100%   {transform: rotate(360deg)}
        }

        @keyframes prixClipFix {
            0%   {clip-path:polygon(50% 50%,0 0,0 0,0 0,0 0,0 0)}
            25%  {clip-path:polygon(50% 50%,0 0,100% 0,100% 0,100% 0,100% 0)}
            50%  {clip-path:polygon(50% 50%,0 0,100% 0,100% 100%,100% 100%,100% 100%)}
            75%  {clip-path:polygon(50% 50%,0 0,100% 0,100% 100%,0 100%,0 100%)}
            100% {clip-path:polygon(50% 50%,0 0,100% 0,100% 100%,0 100%,0 0)}
        }';
            break;
        case (3):
            $custom_css .='.loader {
        width: 48px;
        height: 48px;
        border-radius: 50%;
        position: relative;
        animation: rotate 1s linear infinite
        }
        .loader::before {
        content: "";
        box-sizing: border-box;
        position: absolute;
        inset: 0px;
        border-radius: 50%;
        border: 5px solid var(--theme-primary-color);
        animation: prixClipFix 2s linear infinite ;
        }

        @keyframes rotate {
        100%   {transform: rotate(360deg)}
        }

        @keyframes prixClipFix {
            0%   {clip-path:polygon(50% 50%,0 0,0 0,0 0,0 0,0 0)}
            25%  {clip-path:polygon(50% 50%,0 0,100% 0,100% 0,100% 0,100% 0)}
            50%  {clip-path:polygon(50% 50%,0 0,100% 0,100% 100%,100% 100%,100% 100%)}
            75%  {clip-path:polygon(50% 50%,0 0,100% 0,100% 100%,0 100%,0 100%)}
            100% {clip-path:polygon(50% 50%,0 0,100% 0,100% 100%,0 100%,0 0)}
        }';
            break;
        case (4):
            $custom_css .='.loader {
        width: 48px;
        height: 48px;
        border-radius: 50%;
        position: relative;
        animation: rotate 1s linear infinite
        }
        .loader::before {
        content: "";
        box-sizing: border-box;
        position: absolute;
        inset: 0px;
        border-radius: 50%;
        border: 5px solid var(--theme-primary-color);
        animation: prixClipFix 2s linear infinite ;
        }

        @keyframes rotate {
        100%   {transform: rotate(360deg)}
        }

        @keyframes prixClipFix {
            0%   {clip-path:polygon(50% 50%,0 0,0 0,0 0,0 0,0 0)}
            25%  {clip-path:polygon(50% 50%,0 0,100% 0,100% 0,100% 0,100% 0)}
            50%  {clip-path:polygon(50% 50%,0 0,100% 0,100% 100%,100% 100%,100% 100%)}
            75%  {clip-path:polygon(50% 50%,0 0,100% 0,100% 100%,0 100%,0 100%)}
            100% {clip-path:polygon(50% 50%,0 0,100% 0,100% 100%,0 100%,0 0)}
        }';
            break;
        case (5):
            $custom_css .='.loader {
            width: 48px;
            height: 48px;
            border-radius: 50%;
            position: relative;
            animation: rotate 1s linear infinite
        }
        .loader::before , .loader::after {
            content: "";
            box-sizing: border-box;
            position: absolute;
            inset: 0px;
            border-radius: 50%;
            border: 5px solid var(--theme-primary-color);
            animation: prixClipFix 2s linear infinite ;
        }
        .loader::after{
            border-color: var(--theme-primary-color);
            animation: prixClipFix 2s linear infinite , rotate 0.5s linear infinite reverse;
            inset: 6px;
        }

        @keyframes rotate {
            0%   {transform: rotate(0deg)}
            100%   {transform: rotate(360deg)}
        }

        @keyframes prixClipFix {
            0%   {clip-path:polygon(50% 50%,0 0,0 0,0 0,0 0,0 0)}
            25%  {clip-path:polygon(50% 50%,0 0,100% 0,100% 0,100% 0,100% 0)}
            50%  {clip-path:polygon(50% 50%,0 0,100% 0,100% 100%,100% 100%,100% 100%)}
            75%  {clip-path:polygon(50% 50%,0 0,100% 0,100% 100%,0 100%,0 100%)}
            100% {clip-path:polygon(50% 50%,0 0,100% 0,100% 100%,0 100%,0 0)}
        }';
            break;
        case (6):
            $custom_css .= '.loader {
                width: 48px;
                height: 48px;
                border: 3px solid #FFF;
                border-radius: 50%;
                display: inline-block;
                position: relative;
                box-sizing: border-box;
                animation: rotation 1s linear infinite;
            }
            .loader::after {
                content: "";  
                box-sizing: border-box;
                position: absolute;
                left: 50%;
                top: 50%;
                transform: translate(-50%, -50%);
                width: 40px;
                height: 40px;
                border-radius: 50%;
                border: 3px solid transparent;
                border-bottom-color: var(--theme-primary-color);
            }
            
            @keyframes rotation {
                0% {
                    transform: rotate(0deg);
                }
                100% {
                    transform: rotate(360deg);
                }
            }';
            break;

        case (7):
            $custom_css .='.loader {
                    width: 48px;
                    height: 48px;
                    border: 3px solid #FFF;
                    border-radius: 50%;
                    display: inline-block;
                    position: relative;
                    box-sizing: border-box;
                    animation: rotation 1s linear infinite;
                }
                .loader::after {
                    content: "";  
                    box-sizing: border-box;
                    position: absolute;
                    left: 50%;
                    top: 50%;
                    transform: translate(-50%, -50%);
                    width: 40px;
                    height: 40px;
                    border-radius: 50%;
                    border: 3px solid;
                    border-color: var(--theme-primary-color) transparent;
                }

                @keyframes rotation {
                    0% {
                        transform: rotate(0deg);
                    }
                    100% {
                        transform: rotate(360deg);
                    }
                } ';
            break;
        case (8):
            $custom_css .='.loader {
                    width: 48px;
                    height: 48px;
                    border: 2px solid #FFF;
                    border-radius: 50%;
                    display: inline-block;
                    position: relative;
                    box-sizing: border-box;
                    animation: rotation 1s linear infinite;
                }
                .loader::after,
                .loader::before {
                    content: "";  
                    box-sizing: border-box;
                    position: absolute;
                    left: 0;
                    top: 0;
                    background: var(--theme-primary-color);
                    width: 6px;
                    height: 6px;
                    transform: translate(150%, 150%);
                    border-radius: 50%;
                }
                .loader::before {
                    left: auto;
                    top: auto;
                    right: 0;
                    bottom: 0;
                    transform: translate(-150%, -150%);
                }

                @keyframes rotation {
                    0% {
                        transform: rotate(0deg);
                    }
                    100% {
                        transform: rotate(360deg);
                    }
                } ';
            break;
        case (9):
            $custom_css .='.loader {
                    width: 48px;
                    height: 48px;
                    border-radius: 50%;
                    display: inline-block;
                    position: relative;
                    border: 3px solid;
                    border-color: #FFF #FFF transparent;
                    box-sizing: border-box;
                    animation: rotation 1s linear infinite;
                }
                .loader::after {
                    content: "";  
                    box-sizing: border-box;
                    position: absolute;
                    left: 0;
                    right: 0;
                    top: 0;
                    bottom: 0;
                    margin: auto;
                    border: 3px solid;
                    border-color: transparent var(--theme-primary-color) var(--theme-primary-color);
                    width: 24px;
                    height: 24px;
                    border-radius: 50%;
                    animation: rotationBack 0.5s linear infinite;
                    transform-origin: center center;
                }

                @keyframes rotation {
                    0% {
                        transform: rotate(0deg);
                    }
                    100% {
                        transform: rotate(360deg);
                    }
                } 
                    
                @keyframes rotationBack {
                    0% {
                        transform: rotate(0deg);
                    }
                    100% {
                        transform: rotate(-360deg);
                    }
                }';
            break;
        case (10):
            $custom_css .='.loader {
                    width: 48px;
                    height: 48px;
                    border-radius: 50%;
                    display: inline-block;
                    position: relative;
                    border: 3px solid;
                    border-color: #FFF #FFF transparent transparent;
                    box-sizing: border-box;
                    animation: rotation 1s linear infinite;
                }
                .loader::after,
                .loader::before {
                    content: "";  
                    box-sizing: border-box;
                    position: absolute;
                    left: 0;
                    right: 0;
                    top: 0;
                    bottom: 0;
                    margin: auto;
                    border: 3px solid;
                    border-color: transparent transparent var(--theme-primary-color) var(--theme-primary-color);
                    width: 40px;
                    height: 40px;
                    border-radius: 50%;
                    box-sizing: border-box;
                    animation: rotationBack 0.5s linear infinite;
                    transform-origin: center center;
                }
                .loader::before {
                    width: 32px;
                    height: 32px;
                    border-color: #FFF #FFF transparent transparent;
                    animation: rotation 1.5s linear infinite;
                }
                    
                @keyframes rotation {
                    0% {
                        transform: rotate(0deg);
                    }
                    100% {
                        transform: rotate(360deg);
                    }
                } 
                @keyframes rotationBack {
                    0% {
                        transform: rotate(0deg);
                    }
                    100% {
                        transform: rotate(-360deg);
                    }
                }';
            break;
        case (11):
            $custom_css .='.loader {
                    width: 48px;
                    height: 48px;
                    border: 3px dotted #FFF;
                    border-style: solid solid dotted dotted;
                    border-radius: 50%;
                    display: inline-block;
                    position: relative;
                    box-sizing: border-box;
                    animation: rotation 2s linear infinite;
                }
                .loader::after {
                    content: "";  
                    box-sizing: border-box;
                    position: absolute;
                    left: 0;
                    right: 0;
                    top: 0;
                    bottom: 0;
                    margin: auto;
                    border: 3px dotted var(--theme-primary-color);
                    border-style: solid solid dotted;
                    width: 24px;
                    height: 24px;
                    border-radius: 50%;
                    animation: rotationBack 1s linear infinite;
                    transform-origin: center center;
                }
                    
                @keyframes rotation {
                    0% {
                        transform: rotate(0deg);
                    }
                    100% {
                        transform: rotate(360deg);
                    }
                } 
                @keyframes rotationBack {
                0% {
                    transform: rotate(0deg);
                }
                100% {
                    transform: rotate(-360deg);
                }
                } ';
            break;
        case (12):
            $custom_css .='.loader {
                width: 48px;
                height: 48px;
                border: 2px solid #FFF;
                border-radius: 50%;
                display: inline-block;
                position: relative;
                box-sizing: border-box;
                animation: rotation 1s linear infinite;
            }
            .loader::after {
                content: "";  
                box-sizing: border-box;
                position: absolute;
                left: 50%;
                top: 0;
                background: var(--theme-primary-color);
                width: 3px;
                height: 24px;
                transform: translateX(-50%);
            }
                
            @keyframes rotation {
                0% {
                    transform: rotate(0deg);
                }
                100% {
                    transform: rotate(360deg);
                }
            } ';
            break;
        case (13):
            $custom_css .='
                .loader {
                    width: 28px;
                    aspect-ratio: 1;
                    border-radius: 50%;
                    background: #F10C49;
                    animation: l2 1.5s infinite;
                }
                @keyframes l2 {
                    0%,
                    100%{transform:translate(-35px);box-shadow:  0     0 #F4DD51, 0     0 #E3AAD6}
                    40% {transform:translate( 35px);box-shadow: -15px  0 #F4DD51,-30px  0 #E3AAD6}
                    50% {transform:translate( 35px);box-shadow:  0     0 #F4DD51, 0     0 #E3AAD6}
                    90% {transform:translate(-35px);box-shadow:  15px  0 #F4DD51, 30px  0 #E3AAD6}
                }';
            break;
        case (14):
            $custom_css .='.loader {
                color:var(--theme-primary-color);
                font-size: 45px;
                text-indent: -9999em;
                overflow: hidden;
                width: 1em;
                height: 1em;
                border-radius: 50%;
                position: relative;
                transform: translateZ(0);
                animation: mltShdSpin 1.7s infinite ease, round 1.7s infinite ease;
            }

            @keyframes mltShdSpin {
                0% {
                    box-shadow: 0 -0.83em 0 -0.4em,
                    0 -0.83em 0 -0.42em, 0 -0.83em 0 -0.44em,
                    0 -0.83em 0 -0.46em, 0 -0.83em 0 -0.477em;
                }
                5%,
                95% {
                    box-shadow: 0 -0.83em 0 -0.4em, 
                    0 -0.83em 0 -0.42em, 0 -0.83em 0 -0.44em, 
                    0 -0.83em 0 -0.46em, 0 -0.83em 0 -0.477em;
                }
                10%,
                59% {
                    box-shadow: 0 -0.83em 0 -0.4em, 
                    -0.087em -0.825em 0 -0.42em, -0.173em -0.812em 0 -0.44em, 
                    -0.256em -0.789em 0 -0.46em, -0.297em -0.775em 0 -0.477em;
                }
                20% {
                    box-shadow: 0 -0.83em 0 -0.4em, -0.338em -0.758em 0 -0.42em,
                    -0.555em -0.617em 0 -0.44em, -0.671em -0.488em 0 -0.46em, 
                    -0.749em -0.34em 0 -0.477em;
                }
                38% {
                    box-shadow: 0 -0.83em 0 -0.4em, -0.377em -0.74em 0 -0.42em,
                    -0.645em -0.522em 0 -0.44em, -0.775em -0.297em 0 -0.46em, 
                    -0.82em -0.09em 0 -0.477em;
                }
                100% {
                    box-shadow: 0 -0.83em 0 -0.4em, 0 -0.83em 0 -0.42em, 
                    0 -0.83em 0 -0.44em, 0 -0.83em 0 -0.46em, 0 -0.83em 0 -0.477em;
                }
            }

            @keyframes round {
                0% { transform: rotate(0deg) }
                100% { transform: rotate(360deg) }
            }';
            break;
        case (15):
            $custom_css .='.loader {
                width: 48px;
                height: 48px;
                border-radius: 50%;
                display: inline-block;
                position: relative;
                background: linear-gradient(0deg, rgba(255, 61, 0, 0.2) 33%, var(--theme-primary-color) 100%);
                box-sizing: border-box;
                animation: rotation 1s linear infinite;
            }
            .loader::after {
                content: "";  
                box-sizing: border-box;
                position: absolute;
                left: 50%;
                top: 50%;
                transform: translate(-50%, -50%);
                width: 44px;
                height: 44px;
                border-radius: 50%;
                background: var(--theme-primary-color);
            }
            @keyframes rotation {
                0% { transform: rotate(0deg) }
                100% { transform: rotate(360deg)}
            } ';
            break;
        case (16):
            $custom_css .='.loader {
                transform: rotateZ(45deg);
                perspective: 1000px;
                border-radius: 50%;
                width: 48px;
                height: 48px;
                color: var(--theme-primary-color);
            }
            .loader:before,
            .loader:after {
                content: "";
                display: block;
                position: absolute;
                top: 0;
                left: 0;
                width: inherit;
                height: inherit;
                border-radius: 50%;
                transform: rotateX(70deg);
                animation: 1s spin linear infinite;
            }
            .loader:after {
                color: var(--theme-primary-color);
                transform: rotateY(70deg);
                animation-delay: .4s;
            }

        @keyframes rotate {
            0% {
            transform: translate(-50%, -50%) rotateZ(0deg);
            }
            100% {
            transform: translate(-50%, -50%) rotateZ(360deg);
            }
        }

        @keyframes rotateccw {
            0% {
            transform: translate(-50%, -50%) rotate(0deg);
            }
            100% {
            transform: translate(-50%, -50%) rotate(-360deg);
            }
        }

        @keyframes spin {
            0%,100% {
            box-shadow: .2em 0px 0 0px currentcolor;
            }
            12% {
            box-shadow: .2em .2em 0 0 currentcolor;
            }
            25% {
            box-shadow: 0 .2em 0 0px currentcolor;
            }
            37% {
            box-shadow: -.2em .2em 0 0 currentcolor;
            }
            50% {
            box-shadow: -.2em 0 0 0 currentcolor;
            }
            62% {
            box-shadow: -.2em -.2em 0 0 currentcolor;
            }
            75% {
            box-shadow: 0px -.2em 0 0 currentcolor;
            }
            87% {
            box-shadow: .2em -.2em 0 0 currentcolor;
            }
        }';
            break;
        case (17):
            $custom_css .='.loader {
                width: 48px;
                height: 48px;
                border-radius: 50%;
                display: inline-block;
                border-top: 4px solid #381e1e;
                border-right: 4px solid transparent;
                box-sizing: border-box;
                animation: rotation 1s linear infinite;
                }
                .loader::after {
                content: "";  
                box-sizing: border-box;
                position: absolute;
                left: 0;
                top: 0;
                width: 48px;
                height: 48px;
                border-radius: 50%;
                border-bottom: 4px solid var(--theme-primary-color);
                border-left: 4px solid transparent;
                }
                @keyframes rotation {
                0% {
                    transform: rotate(0deg);
                }
                100% {
                    transform: rotate(360deg);
                }
                } ';
            break;
        case (18):
            $custom_css .='.loader {
                width: 48px;
                height: 48px;
                border-radius: 50%;
                display: inline-block;
                border-top: 4px solid var(--theme-primary-color);
                border-right: 4px solid transparent;
                box-sizing: border-box;
                animation: rotation 1s linear infinite;
            }
            .loader::after {
                content: "";  
                box-sizing: border-box;
                position: absolute;
                left: 0;
                top: 0;
                width: 48px;
                height: 48px;
                border-radius: 50%;
                border-left: 4px solid var(--theme-primary-color);
                border-bottom: 4px solid transparent;
                animation: rotation 0.5s linear infinite reverse;
            }
            @keyframes rotation {
                0% {
                    transform: rotate(0deg);
                }
                100% {
                    transform: rotate(360deg);
                }
            } ';
            break;
        case (19):
            $custom_css .='.loader {
                width: 48px;
                height: 48px;
                border-radius: 50%;
                display: inline-block;
                position: relative;
                border: 10px solid;
                border-color: rgb(123 123 123 / 15%) rgb(109 109 109 / 25%) rgba(255, 255, 255, 0.35) rgb(118 118 118 / 50%);
                box-sizing: border-box;
                animation: rotation 1s linear infinite;
            }

            @keyframes rotation {
                0% {
                    transform: rotate(0deg);
                }
                100% {
                    transform: rotate(360deg);
                }
            } ';
            break;
        case (20):
            $custom_css .='.loader {
                width: 48px;
                height: 48px;
                border:10px solid #FFF;
                border-radius: 50%;
                position: relative;
                transform:rotate(45deg);
                box-sizing: border-box;
            }
            .loader::before {
                content: "";
                position: absolute;
                box-sizing: border-box;
                inset:-10px;
                border-radius: 50%;
                border:10px solid var(--theme-primary-color);
                animation: prixClipFix 2s infinite linear;
            }

            @keyframes prixClipFix {
                0%   {clip-path:polygon(50% 50%,0 0,0 0,0 0,0 0,0 0)}
                25%  {clip-path:polygon(50% 50%,0 0,100% 0,100% 0,100% 0,100% 0)}
                50%  {clip-path:polygon(50% 50%,0 0,100% 0,100% 100%,100% 100%,100% 100%)}
                75%  {clip-path:polygon(50% 50%,0 0,100% 0,100% 100%,0 100%,0 100%)}
                100% {clip-path:polygon(50% 50%,0 0,100% 0,100% 100%,0 100%,0 0)}
            }';
            break;
        case (21):
            $custom_css .='.loader {
                width: 70px;
                height: 35px;
                position: relative;
                overflow: hidden;
            }
            .loader:before {
                content: "";
                width: 70px;
                height: 70px;
                position: absolute;
                left: 0;
                top: 0;
                border: 5px solid #9e9e9e;
                border-color: #9e9e9e #9e9e9e #9e9e9e00 #9e9e9e;
                border-radius: 50%;
                box-sizing: border-box;
                animation: rotate 3s ease-in-out infinite;
                transform: rotate(-200deg);
            }
            @keyframes rotate {
                0% {
                border-width: 10px;
                }
                25% {
                border-width: 3px;
                }
                50% {
                transform: rotate(115deg);
                border-width: 10px;
                }
                75% {
                border-width: 3px;
                }
                100% {
                border-width: 10px;
                }
            }';
            break;
        case (22):
            $custom_css .='.loader {
                position: relative;
                margin: auto;
                box-sizing: border-box;
                width: 120px;
                height: 120px;
                border-radius: 50%;
                border: 4px solid rgba(255, 255, 255, 0.1);
                transform-origin: 50% 50%;
                transform: perspective(200px) rotateX(66deg);
                animation: spinner-wiggle 1.2s infinite;
            }
            .loader:before,
            .loader:after {
                content: "";
                position: absolute;
                inset: -4px;
                border-radius: 50%;
                box-sizing: border-box;
                border: 4px solid #0000;
                animation: spinner-spin 1.2s cubic-bezier(0.6, 0.2, 0, 0.8) infinite,
                spinner-fade 1.2s linear infinite;
            }
            .loader:before {
                border-top-color: #fff;
            }
            .loader:after {
                border-top-color: var(--theme-primary-color);
                animation-delay: 0.4s;
            }

            @keyframes spinner-spin {
                100% { transform: rotate(360deg)}
            }
            @keyframes spinner-fade {
                25%, 75% { opacity: 0.1}
                50% { opacity: 1 }
            } ';
            break;
        case (23):
            $custom_css .='
                .loader {
                    width: 60px;
                    aspect-ratio: 2;
                    --_g: no-repeat radial-gradient(circle closest-side,var(--theme-primary-color) 90%,#0000);
                    background: 
                        var(--_g) 0%   50%,
                        var(--_g) 50%  50%,
                        var(--_g) 100% 50%;
                    background-size: calc(100%/3) 50%;
                    animation: l3 1s infinite linear;
                    }
                @keyframes l3 {
                    20%{background-position:0%   0%, 50%  50%,100%  50%}
                    40%{background-position:0% 100%, 50%   0%,100%  50%}
                    60%{background-position:0%  50%, 50% 100%,100%   0%}
                    80%{background-position:0%  50%, 50%  50%,100% 100%}
                }';
            break;
        case (24):
            $custom_css .='
            .loader {
                --s: 64px;
                width: var(--s);
                aspect-ratio: 2;
                --_g: var(--theme-primary-color) 90%,#0000;
                background: 
                    radial-gradient(farthest-side at bottom,var(--_g)) 0    calc(50% - var(--s)/16),
                    radial-gradient(farthest-side at top   ,var(--_g)) 0    calc(50% + var(--s)/16),
                    radial-gradient(farthest-side at bottom,var(--_g)) 50%  calc(50% - var(--s)/16),
                    radial-gradient(farthest-side at top   ,var(--_g)) 50%  calc(50% + var(--s)/16),
                    radial-gradient(farthest-side at bottom,var(--_g)) 100% calc(50% - var(--s)/16),
                    radial-gradient(farthest-side at top   ,var(--_g)) 100% calc(50% + var(--s)/16);
                background-size: 25% 25%;
                background-repeat: no-repeat;
            animation: l13 1s infinite linear;
                }
                @keyframes l13 {
                    16.67% {background-position:0 0,0 100%,50% calc(50% - var(--s)/8),50% calc(50% + var(--s)/16),100% calc(50% - var(--s)/16),100% calc(50% + var(--s)/16)}
                    33.33% {background-position:0 0,0 100%,50% 0,50% 100%,100% calc(50% - var(--s)/16),100% calc(50% + var(--s)/16)}
                    50%    {background-position:0 0,0 100%,50% 0,50% 100%,100% 0,100% 100%}
                    66.67% {background-position:0 calc(50% - var(--s)/16),0 calc(50% + var(--s)/16),50% 0,50% 100%,100% 0,100% 100%}
                    83.33% {background-position:0 calc(50% - var(--s)/16),0 calc(50% + var(--s)/16),50% calc(50% - var(--s)/16),50% calc(50% + var(--s)/16),100% 0,100% 100%}
            }';
            break;
        case (25):
            $custom_css .='
                .loader {
                    height: 15px;
                    aspect-ratio: 5;
                    display: grid;
                    --_g: no-repeat radial-gradient(farthest-side,var(--theme-primary-color) 94%,#0000);
                }
                .loader:before,
                .loader:after {
                    content: "";
                    grid-area: 1/1;
                    background:
                        var(--_g) left,
                        var(--_g) right;
                    background-size: 20% 100%;
                    animation: l32 1s infinite; 
                }
                .loader:after { 
                    background:
                        var(--_g) calc(1*100%/3),
                        var(--_g) calc(2*100%/3);
                    background-size: 20% 100%;
                    animation-direction: reverse;
                }
                @keyframes l32 {
                    80%,100% {transform:rotate(.5turn)}
                }';
            break;
        case (26):
            $custom_css .='
                .loader {
                    height: 15px;
                    aspect-ratio: 5;
                    -webkit-mask: linear-gradient(90deg, #0000, var(--theme-primary-color) 20% 80%, #0000);
                    background: radial-gradient(closest-side at 37.5% 50%, var(--theme-primary-color) 94%, #0000) 0 / calc(80% / 3) 100%;
                    animation: l48 .75s infinite linear;
                }
                @keyframes l48 {
                    100% {background-position: 36.36%}
                    }';
            break;
        case (27):
            $custom_css .='
                .loader {
                    border: 2px solid;
                    border-color: transparent var(--theme-primary-color);
                    width: 48px;
                    height: 48px;
                    border-radius: 50%;
                    display: inline-block;
                    position: relative;
                    box-sizing: border-box;
                    animation: rotation 2s linear infinite;
                }
                .loader::after {
                    content: "";  
                    box-sizing: border-box;
                    position: absolute;
                    left: 50%;
                    top: 50%;
                    border: 24px solid;
                    border-color: transparent rgba(255, 255, 255, 0.15);
                    border-radius: 50%;
                    transform: translate(-50%, -50%);
                }

                @keyframes rotation {
                    0% {
                        transform: rotate(0deg);
                    }
                    100% {
                        transform: rotate(360deg);
                    }
                } ';
            break;
        case (28):
            $custom_css .='
                .loader {
                    width: 32px;
                    height: 32px;
                    position: relative;
                    border-radius: 50%;
                    color: var(--theme-primary-color);
                    animation: fill 1s ease-in infinite alternate;
                }
                .loader::before , .loader::after {
                    content: "";
                    position: absolute;
                    height: 100%;
                    width: 100%;
                    border-radius: 50%;
                    left: 48px;
                    top: 0;
                    animation: fill 0.9s ease-in infinite alternate;
                }

                .loader::after {
                    left: auto;
                    right: 48px;
                    animation-duration: 1.1s;
                }

                @keyframes fill {
                    0% {  box-shadow: 0 0 0 2px inset }
                    100%{ box-shadow: 0 0 0 10px inset }
                    }';
            break;
        case (29):
            $custom_css .='
                .loader {
                    width: 16px;
                    height: 16px;
                    border-radius: 50%;
                    background-color: var(--theme-primary-color);
                    box-shadow: 32px 0 var(--theme-primary-color), -32px 0 var(--theme-primary-color);
                    position: relative;
                    animation: flash 0.5s ease-out infinite alternate;
                }

                @keyframes flash {
                    0% {
                        background-color: #FFF2;
                        box-shadow: 32px 0 #FFF2, -32px 0 var(--theme-primary-color);
                    }
                    50% {
                        background-color: var(--theme-primary-color);
                        box-shadow: 32px 0 #FFF2, -32px 0 #FFF2;
                    }
                    100% {
                        background-color: #FFF2;
                        box-shadow: 32px 0 var(--theme-primary-color), -32px 0 #FFF2;
                    }
                }';
            break;
        case (30):
            $custom_css .='
                .loader {
                    position: relative;
                    width: 64px;
                    height: 64px;
                    background-color: rgba(0, 0, 0, 0.5);
                    transform: rotate(45deg);
                    overflow: hidden;
                }
                .loader:after{
                    content: "";
                    position: absolute;
                    inset: 8px;
                    margin: auto;
                    background: var(--theme-primary-color);
                }
                .loader:before{
                    content: "";
                    position: absolute;
                    inset: -15px;
                    margin: auto;
                    background: var(--theme-primary-color);
                    animation: diamondLoader 2s linear infinite;
                }
                @keyframes diamondLoader {
                    0%  ,10% {
                    transform: translate(-64px , -64px) rotate(-45deg)
                    }
                    90% , 100% {
                    transform: translate(0px , 0px) rotate(-45deg)
                    }
                }';
            break;
        case (31):
            $custom_css .='
                .loader {
                    position: relative;
                    width:  48px;
                    height: 48px;
                    background: var(--theme-primary-color);
                    transform: rotateX(65deg) rotate(45deg);
                    // remove bellows command for perspective change
                    //transform: perspective(200px) rotateX(65deg) rotate(45deg); 
                    color: #fff;
                    animation: layers1 1s linear infinite alternate;
                }
                .loader:after {
                    content: "";
                    position: absolute;
                    inset: 0;
                    background: rgba(255, 255, 255, 0.7);
                    animation: layerTr 1s linear infinite alternate;
                }

                @keyframes layers1 {
                    0% { box-shadow: 0px 0px 0 0px  }
                90% , 100% { box-shadow: 20px 20px 0 -4px  }
                }
                @keyframes layerTr {
                    0% { transform:  translate(0, 0) scale(1) }
                    100% {  transform: translate(-25px, -25px) scale(1) }
                }';
            break;
        case (32):
            $custom_css .='
                .loader {
                    width: 80px;
                    aspect-ratio: 1.154;
                    background: repeating-conic-gradient(from -30deg,#027B7F 0 60deg,#FFA588 0 120deg,#BF1E62 0 180deg); 
                    animation: l13 1.5s infinite alternate;
                }
                @keyframes l13 {
                    0%,
                    10%  {clip-path: polygon(50% 50%,25% 100%,25% 100%,25% 100%,25% 100%,75% 100%,75% 100%,75% 100%)}
                    33%,
                    43%  {clip-path: polygon(50% 50%,0   50% ,0   50% ,0   50% ,25% 100%,75% 100%,100% 50%,100% 50%)}
                    66%,
                    76%  {clip-path: polygon(50% 50%,25% 0   ,25% 0   ,0   50% ,25% 100%,75% 100%,100% 50%,75%  0  )}
                    95%,
                    100% {clip-path: polygon(50% 50%,75% 0   ,25% 0   ,0   50% ,25% 100%,75% 100%,100% 50%,75%  0  )}
                }';
            break;
        case (33):
            $custom_css .='
                .loader {
                    width: 0;
                    height: 4.8px;
                    display: inline-block;
                    position: relative;
                    background: var(--theme-primary-color);
                    box-shadow: 0 0 10px var(--theme-primary-color);
                    box-sizing: border-box;
                    animation: animFw 8s linear infinite;
                }
                .loader::after,
                .loader::before {
                    content: "";
                    width: 10px;
                    height: 1px;
                    background: var(--theme-primary-color);
                    position: absolute;
                    top: 9px;
                    right: -2px;
                    opacity: 0;
                    transform: rotate(-45deg) translateX(0px);
                    box-sizing: border-box;
                    animation: coli1 0.3s linear infinite;
                }
                .loader::before {
                    top: -4px;
                    transform: rotate(45deg);
                    animation: coli2 0.3s linear infinite;
                }

                @keyframes animFw {
                    0% {
                width: 0;
                }
                    100% {
                width: 100%;
                }
                }

                @keyframes coli1 {
                    0% {
                        transform: rotate(-45deg) translateX(0px);
                        opacity: 0.7;
                    }
                    100% {
                        transform: rotate(-45deg) translateX(-45px);
                        opacity: 0;
                    }
                }

                @keyframes coli2 {
                    0% {
                        transform: rotate(45deg) translateX(0px);
                        opacity: 1;
                    }
                    100% {
                        transform: rotate(45deg) translateX(-45px);
                        opacity: 0.7;
                    }
                }';
            break;
        case (34):
            $custom_css .='
                .loader {
                    width: 100%;
                    height: 4.8px;
                    display: inline-block;
                    background: var(--theme-primary-color);
                    position: relative;
                    overflow: hidden;
                }
                .loader::after {
                    content: "";  
                    width: 0%;
                    height: 4.8px;
                    background-color: #FFF;
                    background-image: linear-gradient(45deg, rgba(0, 0, 0, 0.25) 25%, transparent 25%, transparent 50%, rgba(0, 0, 0, 0.25) 50%, rgba(0, 0, 0, 0.25) 75%, transparent 75%, transparent);
                    background-size: 15px 15px;
                    position: absolute;
                    top: 0;
                    left: 0;
                    box-sizing: border-box;
                    animation: animFw 6s ease-in infinite;
                }

                @keyframes animFw {
                    0% {
                        width: 0;
                    }
                    100% {
                        width: 100%;
                    }
                }';
            break;
        case (35):
            $custom_css .='
                .loader {
                    width: 96px;
                    height: 16px;
                    display: inline-block;
                    background-color: var(--theme-primary-color);
                    border: 1px solid var(--theme-primary-color);
                    border-radius: 4px;
                    background-image: linear-gradient(45deg, rgba(0, 0, 0, 0.25) 25%, transparent 25%, transparent 50%, rgba(0, 0, 0, 0.25) 50%, rgba(0, 0, 0, 0.25) 75%, transparent 75%, transparent);
                    font-size: 30px;
                    background-size: 1em 1em;
                    box-sizing: border-box;
                    animation: barStripe 1s linear infinite;
                }

                @keyframes barStripe {
                    0% {
                        background-position: 1em 0;
                    }
                    100% {
                        background-position: 0 0;
                    }
                }';
            break;
        case (36):
            $custom_css .='
                .loader{
                    width: 200px;
                    height: 40px;
                    background-color: #0004;
                    position: relative;
                    border-radius: 50px;
                    box-shadow: inset 0 0 0 2px rgba(0, 0, 0, 0.05);
                }
                .loader:after {
                    border-radius: 50px;
                    content: "";
                    position: absolute;
                    background-color: #fff;
                    left: 2px;
                    top: 2px;
                    bottom: 2px;
                    right: 360px;
                    animation: slide 2s linear infinite;
                    box-shadow: 0 1px 2px rgba(0, 0, 0, 0.2);
                }

                @keyframes slide {
                    0% {
                        right: 150px;
                        left: 2px;
                    }
                    5% {
                        left: 2px;
                    }
                    50% {
                        right: 2px;
                        left: 150px;
                    }
                    55% {
                        right: 2px;
                    }
                    100% {
                        right: 150px;
                        left: 2px;
                    }
                }';
            break;
        case (37):
            $custom_css .='
                .loader {
                    position: relative;
                    width: 40px;
                    height: 60px;
                    animation: heartBeat 1.2s infinite cubic-bezier(0.215, 0.61, 0.355, 1);
                }

                .loader:before,
                .loader:after {
                    content: "";
                    background: var(--theme-primary-color) ;
                    width: 40px;
                    height: 60px;
                    border-radius: 50px 50px 0 0;
                    position: absolute;
                    left: 0;
                    bottom: 0;
                    transform: rotate(45deg);
                    transform-origin: 50% 68%;
                    box-shadow: 5px 4px 5px #0004 inset;
                }
                .loader:after {
                    transform: rotate(-45deg);
                }
                @keyframes heartBeat {
                    0% { transform: scale(0.95) }
                    5% { transform: scale(1.1) }
                    39% { transform: scale(0.85) }
                    45% { transform: scale(1) }
                    60% { transform: scale(0.95) }
                    100% { transform: scale(0.9) }
                }';
            break;
        case (38):
            $custom_css .='
                .loader {
                    position: relative;
                    width: 120px;
                    height: 90px;
                    margin: 0 auto;
                }
                .loader:before {
                    content: "";
                    position: absolute;
                    bottom: 30px;
                    left: 50px;
                    height: 30px;
                    width: 30px;
                    border-radius: 50%;
                    background: var(--theme-primary-color);
                    animation: loading-bounce 0.5s ease-in-out infinite alternate;
                }
                .loader:after {
                    content: "";
                    position: absolute;
                    right: 0;
                    top: 0;
                    height: 7px;
                    width: 45px;
                    border-radius: 4px;
                    box-shadow: 0 5px 0 #fff, -35px 50px 0 #fff, -70px 95px 0 #fff;
                    animation: loading-step 1s ease-in-out infinite;
                }

                @keyframes loading-bounce {
                    0% { transform: scale(1, 0.7)}
                    40% { transform: scale(0.8, 1.2)}
                    60% { transform: scale(1, 1)}
                    100% { bottom: 140px }
                }
                @keyframes loading-step {
                    0% {
                        box-shadow: 0 10px 0 rgba(0,0,0,0),
                                    0 10px 0 #fff,
                                    -35px 50px 0 #fff,
                                    -70px 90px 0 #fff;
                    }
                    100% {
                        box-shadow: 0 10px 0 #fff,
                                    -35px 50px 0 #fff,
                                    -70px 90px 0 #fff,
                                    -70px 90px 0 rgba(0,0,0,0);
                    }
                } ';
            break;
        case (39):
            $custom_css .='
                .loader {
                    width: 48px;
                    height: 48px;
                    background: var(--theme-primary-color);
                    display: block;
                    margin: 20px auto;
                    position: relative;
                    box-sizing: border-box;
                    animation: rotationBack 1s ease-in-out infinite reverse;
                }
                .loader::before {
                    content: "";  
                    box-sizing: border-box;
                    left: 0;
                    top: 0;
                    transform: rotate(45deg);
                    position: absolute;
                    width: 48px;
                    height: 48px;
                    background: var(--theme-primary-color);
                    box-shadow: 0 0 5px rgba(0, 0, 0, 0.15);
                }
                .loader::after {
                    content: "";  
                    box-sizing: border-box;
                    width: 32px;
                    height: 32px;
                    border-radius: 50%;
                    position: absolute;
                    left: 50%;
                    top: 50%;
                    background: #FFF;
                    transform: translate(-50%, -50%);
                    box-shadow: 0 0 5px rgba(0, 0, 0, 0.15);
                }
                @keyframes rotationBack {
                    0% {
                        transform: rotate(0deg);
                    }
                    100% {
                        transform: rotate(-360deg);
                    }
                }';
            break;
        case (40):
            $custom_css .='
                .loader {
                    width: 32px;
                    height: 90px;
                    display: block;
                    margin: 20px auto;
                    position: relative;
                    border-radius: 50% 50% 0 0;
                    border-bottom: 10px solid var(--theme-primary-color);
                    background-color: #d8c2c2;
                    background-image: radial-gradient(ellipse at center, #FFF 34%, var(--theme-primary-color) 35%, var(--theme-primary-color) 54%, #d8c2c2 55%), linear-gradient(var(--theme-primary-color) 10px, transparent 0);
                    background-size: 28px 28px;
                    background-position: center 20px , center 2px;
                    background-repeat: no-repeat;
                    box-sizing: border-box;
                    animation: animloaderBack 1s linear infinite alternate;
                }
                .loader::before {
                    content: "";  
                    box-sizing: border-box;
                    position: absolute;
                    left: 50%;
                    transform: translateX(-50%);
                    width: 64px;
                    height: 44px;
                    border-radius: 50%;
                    box-shadow: 0px 15px var(--theme-primary-color) inset;
                    top: 67px;
                }
                .loader::after {
                    content: "";  
                    position: absolute;
                    left: 50%;
                    transform: translateX(-50%) rotate(45deg);
                    width: 34px;
                    height: 34px;
                    top: 112%;
                    background: radial-gradient(ellipse at center, #ffdf00 8%, rgba(249, 62, 0, 0.6) 24%, rgba(0, 0, 0, 0) 100%);
                    border-radius: 50% 50% 0;
                    background-repeat: no-repeat;
                    background-position: -44px -44px;
                    background-size: 100px 100px;
                    box-shadow: 4px 4px 12px 0px rgba(255, 61, 0, 0.5);
                    box-sizing: border-box;
                    animation: animloader 1s linear infinite alternate;
                }

                @keyframes animloaderBack {
                    0%, 30%, 70% {
                        transform: translateY(0px);
                    }
                    20%, 40%, 100% {
                        transform: translateY(-5px);
                    }
                }

                @keyframes animloader {
                    0% {
                        box-shadow: 4px 4px 12px 2px rgba(255, 61, 0, 0.75);
                        width: 34px;
                        height: 34px;
                        background-position: -44px -44px;
                        background-size: 100px 100px;
                    }
                    100% {
                        box-shadow: 2px 2px 8px 0px rgba(255, 61, 0, 0.5);
                        width: 30px;
                        height: 28px;
                        background-position: -36px -36px;
                        background-size: 80px 80px;
                    }
                }';
            break;
        case (41):
            $custom_css .='
                .loader {
                    width: 200px;
                    height: 140px;
                    background: #979794;
                    box-sizing: border-box;
                    position: relative;
                    border-radius:8px;
                    perspective: 1000px;
                }

                .loader:before{
                    content: "";
                    position: absolute;
                    left: 10px;
                    right: 10px;
                    top: 10px;
                    bottom: 10px;
                    border-radius:8px;
                    background: #f5f5f5  no-repeat;
                    background-size: 60px 10px;
                    background-image: 	linear-gradient(#ddd 100px, transparent 0) ,
                                linear-gradient(#ddd 100px, transparent 0), 
                                linear-gradient(#ddd 100px, transparent 0), 
                                linear-gradient(#ddd 100px, transparent 0), 
                                linear-gradient(#ddd 100px, transparent 0), 
                                linear-gradient(#ddd 100px, transparent 0);
                    
                    background-position: 15px 30px , 15px 60px , 15px 90px, 
                                105px 30px , 105px 60px , 105px 90px;
                    box-shadow: 0 0 10px rgba(0,0,0,0.25);
                    }
                .loader:after {
                    content: "";
                    position: absolute;
                    width: calc(50% - 10px);
                    right: 10px;
                    top: 10px;
                    bottom: 10px;
                    border-radius: 8px;
                    background: #fff no-repeat;
                    background-size: 60px 10px;
                    background-image: linear-gradient(#ddd 100px, transparent 0), 
                            linear-gradient(#ddd 100px, transparent 0), 
                            linear-gradient(#ddd 100px, transparent 0);
                    background-position: 50% 30px ,50% 60px , 50%  90px;
                    transform: rotateY(0deg );
                    transform-origin: left center;
                    animation: paging 1s linear infinite;
                }


                @keyframes paging {
                    to {
                        transform: rotateY( -180deg );
                    }
                }';
            break;
        case (42):
            $custom_css .='
                .loader {
                    margin: auto;
                    width: 100px;
                    height: 30px;
                    overflow: hidden;
                    position: relative;
                    background: rgba(0, 0, 0, 0.3);
                    border-radius: 5px;
                    box-shadow: 0px 35px 0 -5px #aaa, 0 -5px 0 0px #ddd, 0 -25px 0 -5px #fff,
                        -25px -30px 0 0px #ddd, -25px 30px 0 0px #ddd, 25px -30px 0 0px #ddd,
                        25px 30px 0 0px #ddd, 20px 10px 0 5px #ddd, 20px -10px 0 5px #ddd,
                        -20px -10px 0 5px #ddd, -20px 10px 0 5px #ddd;
                }
                .loader:after,
                .loader:before {
                    content: "";
                    border-radius: 100%;
                    width: 35px;
                    height: 35px;
                    display: block;
                    position: absolute;
                    border: 4px dashed #fff;
                    bottom: -4px;
                    transform: rotate(0deg);
                    box-sizing: border-box;
                    animation: tape 4s linear infinite;
                }
                .loader:before {
                    right: 0;
                    box-shadow: 0 0 0 4px #fff, 0 0 0 34px #000;
                }
                .loader:after {
                    left: 0;
                    box-shadow: 0 0 0 4px #fff, 0 0 0 65px #000;
                }

                @keyframes tape {
                    0% {
                        transform: rotate(0deg) scale(0.4);
                    }
                    100% {
                        transform: rotate(-360deg) scale(0.4);
                    }
                }';
            break;
        case (43):
            $custom_css .='
                .loader {
                    width: 45px;
                    aspect-ratio: 1;
                    --c:no-repeat linear-gradient(var(--theme-primary-color) 0 0);
                    background: 
                        var(--c) 0    0,
                        var(--c) 0    100%, 
                        var(--c) 50%  50%,   
                        var(--c) 100% 0, 
                        var(--c) 100% 100%;
                    animation: l13 1s infinite alternate;
                }

                @keyframes l13 {
                    0%,10%   {background-size:20% 100%}
                    50%      {background-size:20%  20%}
                    90%,100% {background-size:100% 20%}
                }';
            break;
        case (44):
            $custom_css .='
                .loader {
                    height: 45px;    
                    aspect-ratio: 1.4;
                    --c:no-repeat repeating-linear-gradient(90deg,var(--theme-primary-color) 0 20%,#0000 0 40%);
                    background: var(--c),var(--c),var(--c),var(--c);
                    background-size: 72% 26%;
                    animation: l28 1s infinite;
                }
                @keyframes l28 {
                    0%,
                    20%  {background-position:50% calc(0*100%/3),50%  calc(1*100%/3),50%  calc(2*100%/3),50% calc(3*100%/3)}
                    40%  {background-position:50% calc(0*100%/3),100% calc(1*100%/3),0    calc(2*100%/3),50% calc(3*100%/3)}
                    60%  {background-position:50% calc(0*100%/3),0    calc(1*100%/3),100% calc(2*100%/3),50% calc(3*100%/3)}
                    80%,
                    100% {background-position:50% calc(0*100%/3),50%  calc(1*100%/3),50%  calc(2*100%/3),50% calc(3*100%/3)}
                }';
            break;
        case (45):
            $custom_css .='
                .loader {
                    width: 40px;
                    aspect-ratio: 1;
                    --c:no-repeat linear-gradient(var(--theme-primary-color) 0 0);
                    background: 
                        var(--c) 0    0,
                        var(--c) 0    100%, 
                        var(--c) 50%  0,  
                        var(--c) 50%  100%, 
                        var(--c) 100% 0, 
                        var(--c) 100% 100%;
                    background-size: 8px 50%;
                    animation: l8-0 2s infinite;
                    position: relative;
                    overflow: hidden;
                }
                .loader:before {
                    content: "";
                    position: absolute;
                    width: 8px;
                    height: 8px;
                    border-radius: 50%;
                    background: var(--theme-primary-color);
                    top: calc(50% - 4px);
                    left: -8px;
                    animation: inherit;
                    animation-name: l8-1;
                }
                @keyframes l8-0 {
                    16.67% {background-size:8px 30%, 8px 30%, 8px 50%, 8px 50%, 8px 50%, 8px 50%}
                    33.33% {background-size:8px 30%, 8px 30%, 8px 30%, 8px 30%, 8px 50%, 8px 50%}
                    50%    {background-size:8px 30%, 8px 30%, 8px 30%, 8px 30%, 8px 50%, 8px 50%}
                    66.67% {background-size:8px 50%, 8px 50%, 8px 30%, 8px 30%, 8px 50%, 8px 50%}
                    83.33% {background-size:8px 50%, 8px 50%, 8px 50%, 8px 50%, 8px 50%, 8px 50%}
                }
                @keyframes l8-1 {
                    20%      {left:0px}
                    40%,100% {left:calc(50% - 4px)}
                }';
            break;
        case (46):
            $custom_css .='
                .loader {
                    width: 40px;
                    aspect-ratio: 1;
                    --c: linear-gradient(var(--theme-primary-color) 0 0);
                    --m: radial-gradient(farthest-side,var(--theme-primary-color) 92%,#0000);
                    background: 
                        var(--c),var(--m),
                        var(--c),var(--m), 
                        var(--c),var(--m);
                    background-size: 8px 12px,8px 8px;
                    background-repeat: no-repeat;
                    animation: l17 1s infinite linear;
                }
                @keyframes l17 {
                    0%,5% {background-position: 0 50%             ,0 0               ,50% 50%             ,50% 0               ,100% 50%             ,100% 0}
                    12.5% {background-position: 0 50%             ,0 calc(50% - 10px),50% 50%             ,50% 0               ,100% 50%             ,100% 0}
                    25%   {background-position: 0 calc(50% + 10px),0 50%             ,50% 50%             ,50% 0               ,100% 50%             ,100% 0}
                    37.5% {background-position: 0 calc(50% + 10px),0 50%             ,50% 50%             ,50% calc(50% - 10px),100% 50%             ,100% 0}
                    50%   {background-position: 0 50%             ,0 0               ,50% calc(50% + 10px),50% 50%             ,100% 50%             ,100% 0}
                    62.5% {background-position: 0 50%             ,0 0               ,50% calc(50% + 10px),50% 50%             ,100% 50%             ,100% calc(50% - 10px)}
                    75%   {background-position: 0 50%             ,0 0               ,50% 50%             ,50% 0               ,100% calc(50% + 10px),100% 50%}
                    87.5% {background-position: 0 50%             ,0 0               ,50% 50%             ,50% 0               ,100% calc(50% + 10px),100% 50%}
                    95%,
                    100%  {background-position: 0 50%             ,0 0               ,50% 50%             ,50% 0               ,100% 50%             ,100% 0}
                }';
            break;
        case (47):
            $custom_css .='
                .loader {
                    width: 50px;
                    padding: 8px;
                    aspect-ratio: 1;
                    border-radius: 50%;
                    background: var(--theme-primary-color);
                    --_m: 
                        conic-gradient(#0000 10%,#000),
                        linear-gradient(#000 0 0) content-box;
                    -webkit-mask: var(--_m);
                            mask: var(--_m);
                    -webkit-mask-composite: source-out;
                            mask-composite: subtract;
                    animation: l3 1s infinite linear;
                }
                @keyframes l3 {to{transform: rotate(1turn)}}';
            break;
        case (48):
            $custom_css .='
                .loader {
                    width: 50px;
                    aspect-ratio: 1;
                    display: grid;
                }
                .loader::before,
                .loader::after {    
                    content:"";
                    grid-area: 1/1;
                    --c:no-repeat radial-gradient(farthest-side,#25b09b 92%,#0000);
                    background: 
                        var(--c) 50%  0, 
                        var(--c) 50%  100%, 
                        var(--c) 100% 50%, 
                        var(--c) 0    50%;
                    background-size: 12px 12px;
                    animation: l12 1s infinite;
                }
                .loader::before {
                    margin: 4px;
                    filter: hue-rotate(45deg);
                    background-size: 8px 8px;
                    animation-timing-function: linear
                }

                @keyframes l12 { 
                    100%{transform: rotate(.5turn)}
                    }';
            break;
        case (49):
            $custom_css .='
                .loader {
                    width: 50px;
                    aspect-ratio: 1;
                    display: grid;
                    border-radius: 50%;
                    background: conic-gradient(#25b09b 25%,#f03355 0 50%,#514b82 0 75%,#ffa516 0);
                    animation: l22 2s infinite linear;
                }
                .loader::before,
                .loader::after {
                    content: "";
                    grid-area: 1/1;
                    margin: 15%;
                    border-radius: 50%;
                    background: inherit;
                    animation: inherit;
                }
                .loader::after {
                    margin: 25%;
                    animation-duration: 3s;
                }
                @keyframes l22 {
                    100% {transform: rotate(1turn)}
                }';
            break;
        case (50):
            $custom_css .='
                .loader {
                    width: 40px;
                    height: 40px;
                    color: #f03355;
                    background:
                        conic-gradient(from  -45deg at top    20px left 50% ,#0000 ,currentColor 1deg 90deg,#0000 91deg),
                        conic-gradient(from   45deg at right  20px top  50% ,#0000 ,currentColor 1deg 90deg,#0000 91deg),
                        conic-gradient(from  135deg at bottom 20px left 50% ,#0000 ,currentColor 1deg 90deg,#0000 91deg),
                        conic-gradient(from -135deg at left   20px top  50% ,#0000 ,currentColor 1deg 90deg,#0000 91deg);
                    animation: l4 1.5s infinite cubic-bezier(0.3,1,0,1);
                }
                @keyframes l4 {
                    50%  {width:60px;height: 60px;transform: rotate(180deg)}
                    100% {transform: rotate(360deg)}
                }';
            break;
        case (51):
            $custom_css .='
                .loader {
                    width: 40px;
                    height: 20px;
                    background: orange;
                    position: relative;
                    animation: l9-0 1.5s infinite linear;
                }
                .loader:before,
                .loader:after {
                    content:"";
                    position: absolute;
                    background: inherit; 
                    bottom: 100%;
                    width: 50%;
                    height: 100%;
                    animation: inherit;
                    animation-name: l9-1;
                }
                .loader:before {
                    left: 0;
                    transform-origin: bottom left;
                    --s:-1;
                }
                .loader:after {
                    right: 0;
                    transform-origin: bottom right;
                }
                @keyframes l9-0 {
                    0%,10%   {transform:translateY(0%)    scaleY(1)}
                    49.99%   {transform:translateY(-50%)  scaleY(1)}
                    50%      {transform:translateY(-50%)  scaleY(-1)}
                    90%,100% {transform:translateY(-100%) scaleY(-1)}
                }
                @keyframes l9-1 {
                    10%,90% {transform: rotate(0deg)}
                    50%     {transform: rotate(calc(var(--s,1)*180deg))}
                }';
            break;
        case (52):
            $custom_css .='
                .loader {
                    width: 40px;
                    aspect-ratio: 1;
                    color: #f03355;
                    position: relative;
                    background: radial-gradient(10px,currentColor 94%,#0000);
                }
                .loader:before {
                    content: "";
                    position: absolute;
                    inset: 0;
                    border-radius: 50%;
                    background:
                        radial-gradient(9px at bottom right,#0000 94%,currentColor) top    left,
                        radial-gradient(9px at bottom left ,#0000 94%,currentColor) top    right,
                        radial-gradient(9px at top    right,#0000 94%,currentColor) bottom left,
                        radial-gradient(9px at top    left ,#0000 94%,currentColor) bottom right;
                    background-size: 20px 20px;
                    background-repeat: no-repeat;
                    animation: l18 1.5s infinite cubic-bezier(0.3,1,0,1);
                }
                @keyframes l18 {
                    33%  {inset:-10px;transform: rotate(0deg)}
                    66%  {inset:-10px;transform: rotate(90deg)}
                    100% {inset:0    ;transform: rotate(90deg)}
                    }';
            break;
        case (53):
            $custom_css .='
                .loader {
                    --c:no-repeat linear-gradient(var(--theme-primary-color) 0 0);
                    background: 
                        var(--c),var(--c),var(--c),
                        var(--c),var(--c),var(--c),
                        var(--c),var(--c),var(--c);
                    background-size: 16px 16px;
                    animation: 
                        l32-1 1s infinite,
                        l32-2 1s infinite;
                }
                @keyframes l32-1 {
                    0%,100% {width:45px;height: 45px}
                    35%,65% {width:65px;height: 65px}
                }
                @keyframes l32-2 {
                    0%,40%  {background-position: 0 0,0 50%, 0 100%,50% 100%,100% 100%,100% 50%,100% 0,50% 0,  50% 50% }
                    60%,100%{background-position: 0 50%, 0 100%,50% 100%,100% 100%,100% 50%,100% 0,50% 0,0 0,  50% 50% }
                }';
            break;
        case (54):
            $custom_css .='
                .loader {
                    width: 50px;
                    aspect-ratio: 1;
                    display: grid;
                }
                .loader:before,
                .loader:after {
                    content: "";
                    grid-area: 1/1;
                    border-radius: 50%;
                    background: var(--theme-primary-color);
                    -webkit-mask:repeating-linear-gradient(#000 0 5px,#0000 0 10px);
                    animation: l35 1.5s infinite;
                }
                .loader:after {
                    -webkit-mask:repeating-linear-gradient(#0000 0 5px,#000 0 10px);
                    --s:-1;
                    }
                @keyframes l35 {
                    0%,
                    10% {transform: translate(0) rotate(0)}
                    35% {transform: translate(calc(var(--s,1)*50%)) rotate(0)}
                    66% {transform: translate(calc(var(--s,1)*50%)) rotate(calc(var(--s,1)*180deg))}
                    90%,
                    100% {transform: translate(0) rotate(calc(var(--s,1)*180deg))}
                }';
            break;
        case (55):
            $custom_css .='
                .loader {
                    width: 60px;
                    height: 50px;
                    --m:no-repeat linear-gradient(90deg,var(--theme-primary-color) 70%,#0000 0);
                    -webkit-mask: 
                        var(--m) calc(0*100%/4) 100%/calc(100%/5) calc(1*100%/5),
                        var(--m) calc(1*100%/4) 100%/calc(100%/5) calc(2*100%/5),
                        var(--m) calc(2*100%/4) 100%/calc(100%/5) calc(3*100%/5),
                        var(--m) calc(3*100%/4) 100%/calc(100%/5) calc(4*100%/5),
                        var(--m) calc(4*100%/4) 100%/calc(100%/5) calc(5*100%/5);
                    background: linear-gradient(#514b82 0 0) left/0% 100% no-repeat #ddd;
                    animation: l14 2s infinite steps(6);
                }
                @keyframes l14 {
                    100% {background-size: 120% 100%}
                }';
            break;
        case (56):
            $custom_css .='
                .loader {
                    width: 60px;
                    aspect-ratio: 1;
                    border-radius: 50%;
                    animation: l11 2s infinite;
                }
                @keyframes l11 {
                    0%   {background: conic-gradient(var(--theme-primary-color) 0     ,#0000 0)}
                    12.5%{background: conic-gradient(var(--theme-primary-color) 45deg ,#0000 46deg)}
                    25%  {background: conic-gradient(var(--theme-primary-color) 90deg ,#0000 91deg)}
                    37.5%{background: conic-gradient(var(--theme-primary-color) 135deg,#0000 136deg)}
                    50%  {background: conic-gradient(var(--theme-primary-color) 180deg,#0000 181deg)}
                    62.5%{background: conic-gradient(var(--theme-primary-color) 225deg,#0000 226deg)}
                    75%  {background: conic-gradient(var(--theme-primary-color) 270deg,#0000 271deg)}
                    87.5%{background: conic-gradient(var(--theme-primary-color) 315deg,#0000 316deg)}
                    100% {background: conic-gradient(var(--theme-primary-color) 360deg,#0000 360deg)}
                }';
            break;
        case (57):
            $custom_css .='
                .loader {
                    width: 20px;
                    aspect-ratio: 1;
                    border-radius: 50%;
                    position: relative;
                    transform-origin: 50% -200%;
                    background: radial-gradient(at 30% 30%,#0000,#000a) var(--theme-primary-color);
                    animation: l8 1s cubic-bezier(.5,-200,.5,200) infinite;
                }
                .loader:before {
                    content: "";
                    position: absolute;
                    inset: -200% 8px 100%;
                    background: #ddd; 
                }
                @keyframes l8 { 
                    100% {transform:rotate(1deg)} 
                }';
            break;
        case (58):
            $custom_css .='
                .loader {
                    width: 100px;
                    height: 60px;
                    display: flex;
                    animation: l12-0 2s infinite linear;
                }
                .loader::before,
                .loader::after  {
                    content:"";
                    flex:4;
                    background: 
                        radial-gradient(at 50% 20%,#0000,#000a) bottom left/20px 20px repeat-x,
                        linear-gradient(var(--theme-primary-color) 0 0) bottom/100% 20px no-repeat
                        #ddd;
                    -webkit-mask:
                        repeating-linear-gradient(90deg,#000 0 4px,#0000 0 20px) 8px 0,
                        radial-gradient(farthest-side,#000 90%,#0000) left bottom/20px 20px repeat-x;
                }
                .loader::after {
                    flex: 1;
                    transform-origin: top;
                    animation: l12-1 1s cubic-bezier(0,20,1,20) infinite;
                }
                @keyframes l12-0 { 
                    0%,49.9% {transform: scaleX(1)}
                    50%,100% {transform: scaleX(-1)}
                    }
                @keyframes l12-1 { 
                    100% {transform: rotate(-2deg)}
                    }';
            break;
        case (59):
            $custom_css .='
                .loader {
                    height: 80px;
                    width: 20px;
                    color: #514b82;
                    background:
                        radial-gradient(farthest-side,var(--theme-primary-color) 94%,#0000 ) top/8px 8px,
                        linear-gradient(var(--theme-primary-color) 0 0) top/4px 70%,
                        conic-gradient(from -30deg at bottom,#0000,var(--theme-primary-color) 2deg 58deg,#0000 60deg) bottom            /100% 20px,
                        conic-gradient(from 150deg at top   ,#0000,var(--theme-primary-color) 2deg 58deg,#0000 60deg) bottom 20px left 0/100% 20px;
                    background-repeat: no-repeat;
                    transform-origin: 50% 4px;
                    animation: l15 2s infinite cubic-bezier(0.5,300,0.5,-300);
                }
                @keyframes l15 { 
                    100% {transform: rotate(0.5deg)}
                }';
            break;
        case (60):
            $custom_css .='
                .loader {
                    width: 90px;
                    height: 12px;
                    --c:var(--theme-primary-color) 50%,#0000 0;
                    background: 
                        linear-gradient( 90deg,var(--c)) 0 0,
                        linear-gradient(-90deg,var(--c)) 0 0;
                    background-size: 20px 100%;
                    background-repeat: repeat-x;
                    animation: l10 1s infinite linear;
                }
                @keyframes l10 {
                        100% {background-position: -20px 0,20px 0}
                }';
            break;
        case (61):
            $custom_css .='
                .loader {
                    width: 60px;
                    aspect-ratio: 1;
                    color: var(--theme-primary-color);
                    background:
                        linear-gradient(currentColor 0 0) 100%  0,
                        linear-gradient(currentColor 0 0) 0  100%;
                    background-size: 50.1% 50.1%;
                    background-repeat: no-repeat;
                    animation:  l7-0 1s infinite steps(1);
                }
                .loader::before,
                .loader::after {
                    content:"";
                    position: absolute;
                    inset: 0 50% 50% 0;
                    background: currentColor;
                    transform: scale(var(--s,1)) perspective(150px) rotateY(0deg);
                    transform-origin: bottom right; 
                    animation: l7-1 .5s infinite linear alternate;
                }
                    .loader::after {
                    --s:-1,-1;
                }
                @keyframes l7-0 {
                    0%  {transform: scaleX(1)  rotate(0deg)}
                    50% {transform: scaleX(-1) rotate(-90deg)}
                }
                @keyframes l7-1 {
                    49.99% {transform:scale(var(--s,1)) perspective(150px) rotateX(-90deg) ;filter:grayscale(0)}
                    50%    {transform:scale(var(--s,1)) perspective(150px) rotateX(-90deg) ;filter:grayscale(0.8)}
                    100%   {transform:scale(var(--s,1)) perspective(150px) rotateX(-180deg);filter:grayscale(0.8)}
                }';
            break;
        case (62):
            $custom_css .='
                .loader {
                    width: 60px;
                    aspect-ratio: 1;
                    display: flex;
                    animation: l13-0 4s infinite linear .5s;
                }
                .loader::before,
                .loader::after {
                    content:"";
                    flex:1;
                    background: var(--theme-primary-color);
                    clip-path: polygon(50% 0,100% 0,100% 100%,50% 100%,0 75%,0 25%);
                    animation: l13-1 1s infinite linear;
                }
                .loader::after {
                    transform: scale(-1);
                    animation: none;
                }
                @keyframes l13-0 {
                    0%   ,12.49% {transform: rotate(0deg)}
                    12.5%,37.49% {transform: rotate(90deg)}
                    37.5%,62.49% {transform: rotate(180deg)}
                    62.5%,87.49% {transform: rotate(270deg)}
                    87.5%,100%   {transform: rotate(360deg)}
                    }
                @keyframes l13-1 {
                    0%,
                    5%   {transform:translate(0px)   perspective(150px) rotateY(0deg) }
                    33%  {transform:translate(-10px) perspective(150px) rotateX(0deg) }
                    66%  {transform:translate(-10px) perspective(150px) rotateX(-180deg)}
                    95%,
                    100%{transform: translate(0px)   perspective(150px) rotateX(-180deg)}
                }';
            break;
        case (63):
            $custom_css .='
                .loader {
                    width: 60px;
                    height: 60px;
                    display: flex;
                    color: var(--theme-primary-color);
                    --c:#0000 calc(100% - 20px),currentColor calc(100% - 19px) 98%,#0000;
                    background:
                        radial-gradient(farthest-side at left,var(--c)) right /50% 100%,
                        radial-gradient(farthest-side at top ,var(--c)) bottom/100% 50%;
                    background-repeat: no-repeat;
                    animation: l18-0 2s infinite linear .25s;
                }
                .loader::before{
                    content:"";
                    width:50%;
                    height: 50%;
                    background:radial-gradient(farthest-side at bottom right,var(--c));
                    animation: l18-1 .5s infinite linear;
                }
                @keyframes l18-0 {
                    0%   ,12.49% {transform: rotate(0deg)}
                    12.5%,37.49% {transform: rotate(90deg)}
                    37.5%,62.49% {transform: rotate(180deg)}
                    62.5%,87.49% {transform: rotate(270deg)}
                    87.5%,100%   {transform: rotate(360deg)}
                }
                @keyframes l18-1 {
                    0%      {transform: perspective(150px) rotateY(0)      rotate(0)} 
                    50%     {transform: perspective(150px) rotateY(180deg) rotate(0)} 
                    80%,100%{transform: perspective(150px) rotateY(180deg) rotate(90deg)}
                }';
            break;
        case (64):
            $custom_css .='
                .loader {
                    width: 50px;
                    height: 50px;
                    display: flex;
                    color: var(--theme-primary-color);
                    background:
                        linear-gradient(currentColor 0 0) right  /51% 100%,
                        linear-gradient(currentColor 0 0) bottom /100% 51%;
                    background-repeat: no-repeat;
                    animation: l17-0 2s infinite linear .25s;
                }
                .loader::before{
                    content:"";
                    width: 50%;
                    height: 50%;
                    background: currentColor;
                    transform-origin: 10% 10%;
                    animation: l17-1 .5s infinite linear;
                }
                @keyframes l17-0 {
                    0%   ,12.49% {transform: rotate(0deg)}
                    12.5%,37.49% {transform: rotate(90deg)}
                    37.5%,62.49% {transform: rotate(180deg)}
                    62.5%,87.49% {transform: rotate(270deg)}
                    87.5%,100%   {transform: rotate(360deg)}
                    }
                @keyframes l17-1 {
                    0%      {transform: perspective(80px) rotate3d(-1,1,0, 0)}
                    80%,100%{transform: perspective(80px) rotate3d(-1,1,0,-360deg)}
                }';
            break;
        case (65):
            $custom_css .='
                .loader {
                    width: 32px;
                    height: 64px;
                    background: 
                        radial-gradient(farthest-side at bottom,#F10C49 90%,#0000),
                        radial-gradient(farthest-side at top   ,#F10C49 90%,#0000),
                        radial-gradient(farthest-side at bottom,#f4dd51 90%,#0000),
                        radial-gradient(farthest-side at top   ,#f4dd51 90%,#0000),
                        radial-gradient(farthest-side at bottom,#e3aad6 90%,#0000),
                        radial-gradient(farthest-side at top   ,#e3aad6 90%,#0000);
                    background-size: 100% 25%;
                    background-repeat: no-repeat;
                    animation: l15 2s infinite;
                }
                @keyframes l15{
                    0%     {background-position:0 calc(1*100%/3),0 calc(2*100%/3),0 calc(1*100%/3),0 calc(2*100%/3),0 calc(1*100%/3),0 calc(2*100%/3)}
                    16.67% {background-position:0 calc(0*100%/3),0 calc(3*100%/3),0 calc(1*100%/3),0 calc(2*100%/3),0 calc(1*100%/3),0 calc(2*100%/3)}
                    33.33% {background-position:0 calc(0*100%/3),0 calc(3*100%/3),0 calc(0*100%/3),0 calc(3*100%/3),0 calc(1*100%/3),0 calc(2*100%/3)}
                    50%    {background-position:0 calc(0*100%/3),0 calc(3*100%/3),0 calc(0*100%/3),0 calc(3*100%/3),0 calc(0*100%/3),0 calc(3*100%/3)}
                    66.67% {background-position:0 calc(1*100%/3),0 calc(2*100%/3),0 calc(0*100%/3),0 calc(3*100%/3),0 calc(0*100%/3),0 calc(3*100%/3)}
                    83.33% {background-position:0 calc(1*100%/3),0 calc(2*100%/3),0 calc(1*100%/3),0 calc(2*100%/3),0 calc(0*100%/3),0 calc(3*100%/3)}
                    100%   {background-position:0 calc(1*100%/3),0 calc(2*100%/3),0 calc(1*100%/3),0 calc(2*100%/3),0 calc(1*100%/3),0 calc(2*100%/3)}
                }';
            break;
        case (66):
            $custom_css .='
                .loader {
                    width: 20px;
                    aspect-ratio: 1;
                    border-radius: 50%;
                    background: var(--theme-primary-color);
                    box-shadow: 0 0 0 0 var(--theme-primary-color);
                    animation: l2 1.5s infinite linear;
                    position: relative;
                }
                .loader:before,
                .loader:after {
                    content: "";
                    position: absolute;
                    inset: 0;
                    border-radius: inherit;
                    box-shadow: 0 0 0 0 #0004;
                    animation: inherit;
                    animation-delay: -0.5s;
                }
                .loader:after {
                    animation-delay: -1s;
                }
                @keyframes l2 {
                        100% {box-shadow: 0 0 0 40px #0000}
                }';
            break;
        case (67):
            $custom_css .='
                .loader {
                    display: inline-flex;
                    gap: 5px;
                    animation: l2-0 1s infinite linear;
                }
                .loader:before,
                .loader:after {
                    content: "";
                    width: 35px;
                    aspect-ratio: 1;
                    box-shadow: 0 0 0 3px inset var(--theme-primary-color);
                    animation: l2-1 1s infinite linear both;
                }
                .loader:after {
                    animation-direction:reverse;
                }
                @keyframes l2-0{
                    0% {transform:rotate(0deg)}
                    80%,
                    100%{transform:rotate(180deg)}
                }
                @keyframes l2-1{
                    0%,
                    20%  {border-radius:0}
                    80%,
                    100% {border-radius:50%}
                }';
            break;
        case (68):
            $custom_css .='
                .loader {
                    width: 40px;
                    aspect-ratio: 1;
                    background:
                        linear-gradient( 45deg,#0000 50%,var(--theme-primary-color) 0),
                        linear-gradient(-45deg,#0000 50%,#FF00AA 0),
                        var(--theme-primary-color);
                    background-size: 200% 200%;
                    background-repeat: no-repeat;
                    animation: l2 1.5s infinite; 
                }
                @keyframes l2 {
                    0%   {background-position: bottom left,bottom right}
                    30%,
                    50%  {background-position: bottom left,top left}
                    80%,
                    100% {background-position: top right  ,top left}
                }';
            break;
        case (69):
            $custom_css .='
                .loader {
                    display: inline-flex;
                    border: 2px solid var(--theme-primary-color);
                    --c:no-repeat linear-gradient(var(--theme-primary-color) 0 0) 50%;
                    font-family: "Iranyekanweblightfanum", Sans-serif;
                    background:
                        var(--c) calc(50% - 5px)/5px 5px,
                        var(--c) calc(50% + 5px)/5px 5px;
                }
                .loader::before,
                .loader::after {
                    content: "12 00 23 40 31 45 60 17 45 32 29 42 50 08 14 07 46 11 03 55";
                    font-size: 30px;
                    font-weight: bold;
                    line-height: 1em;
                    height: 1em;
                    width: 2ch;
                    color: #0000;
                    text-shadow: 0 0 0 var(--theme-primary-color);
                    overflow: hidden;
                    margin: 5px 10px; 
                    animation: l3 1s steps(20) infinite;
                }
                .loader::before {
                    animation-duration: 1.5s;
                }
                @keyframes l3 {
                    100% {text-shadow: 0 -20em 0 var(--theme-primary-color)}
                }';
            break;
        case (70):
            $custom_css .='
                .loader {
                width: 40px;
                aspect-ratio: 1;
                border:2px solid;
                box-sizing: border-box;
                color: var(--theme-primary-color);
                background: 
                    radial-gradient(circle 3px, currentColor 95%,#0000),
                    linear-gradient(      currentColor 50%,#0000 0) 50%/3px 80% no-repeat,
                    linear-gradient(90deg,currentColor 50%,#0000 0) 50%/60% 3px no-repeat;
                position: relative;
                }
                .loader:before {
                content: "";
                position: absolute;
                height: 50px;
                inset: 100% 10% auto;
                background:
                    radial-gradient(circle closest-side at 50% calc(100% - 10px), currentColor 94%,#0000),
                    linear-gradient(currentColor 0 0) top/3px 80% no-repeat;
                transform-origin: top;
                animation: l2 2s infinite cubic-bezier(0.5,200,0.5,-200);
                }
                @keyframes l2 {
                100% {transform: rotate(0.4deg)}
                }';
            break;
        
    }
}
