<?php
$post_types = theme_post_type();
foreach ($post_types as $post_type ) {
    if(option_value($post_type['name'] . '-attribute') ){
        $cmb = new_cmb2_box( array(
            'id'            => $post_type['name'] . '-attribute',
            'title'         => $post_type['title'] . esc_html__(' attribute', THEME_NAME),
            'object_types'  => [$post_type['name']],
            'context'       => 'normal',
            'priority'      => 'high',
            'show_names'    => true,
        ) );
        foreach (option_value($post_type['name'] . '-attribute') as $index => $item) {
            $cmb->add_field( array(
                    'name'             => esc_html__($item , THEME_NAME),
                    'id'               => $post_type['name'] . '_' . $index,
                    'type'             => 'text',
                )
            );
        } 
    }
}