<?php

class FontController{

    /**
     * Initialize the existing methods and actions.
     */
    public static function init()
    {
        $option_name = 'theme_settings';

		add_filter( "redux/$option_name/field/typography/typekit_fonts", [ self::class, 'set_redux_theme_fonts' ], 10, 1 );
    }

    public static function set_redux_theme_fonts($fonts): array
    {
        $fonts['theme Font'] = self::add_theme_fonts();
        return $fonts;
    }

    public static function add_theme_fonts(): array
    {
        $result = [];
        $theme_font_option_key_prefix = 'theme-font-';
		$theme_fonts_dir = THEME_DIR . '/assets/fonts/webfonts/';
		$font_dirs = glob( $theme_fonts_dir . '*', GLOB_ONLYDIR );
        foreach ( $font_dirs as $font_name) {
			$font_name = basename( $font_name );
            $font_option = $theme_font_option_key_prefix . $font_name;
            $result[$font_name] = $font_name;
        }
        return $result;
    }


	public function register_font_css(): void {
		$theme_fonts_dir = THEME_DIR . '/assets/fonts/webfonts/';
		$font_dirs = glob( $theme_fonts_dir . '*', GLOB_ONLYDIR );
		foreach ( $font_dirs as $font_dir ) {
			$font_name = basename( $font_dir );
			$font_style_patch = glob( $font_dir . '/*.{css}', GLOB_BRACE );
			wp_enqueue_style( 'theme-' . $font_name, $font_style_patch, array(), null );
		}
	}
}
