<?php
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


$custom_css = '';

if ( option_value( "typography-elementor", 'font-family' ) ) {
	// Get the font folder for the current font family
	$uploads_dir = wp_upload_dir();
	$font_folder = $uploads_dir['basedir'] . '/redux/custom-fonts/custom/' . option_value( "typography-admin", 'font-family' );
	$font_files = glob( $font_folder . '/*.{ttf,woff,otf}', GLOB_BRACE );

	// If font files exist
	if ( ! empty( $font_files ) ) {
		$font_name = basename( $font_folder );
		foreach ( $font_files as $font_file ) {
			$file_name = basename( $font_file );
			$file_ext = pathinfo( $font_file, PATHINFO_EXTENSION );
			$file_base_name = pathinfo( $file_name, PATHINFO_FILENAME );

			// Extract weight information from the filename
			if ( preg_match( '/(\d{3})/', $file_base_name, $matches ) ) {
				$font_weight = $matches[1];
			} else {
				$font_weight = '400'; // Default to normal weight if not found
			}

			$format = '';
			switch ( $file_ext ) {
				case 'ttf':
					$format = 'truetype';
					break;
				case 'woff':
					$format = 'woff';
					break;
				case 'woff2':
					$format = 'woff2';
					break;
				case 'otf':
					$format = 'opentype';
					break;
			}

			$font_relative_path = str_replace( ABSPATH, '/', $font_file );
			$font_url = home_url( $font_relative_path );

			$custom_css .= "@font-face {\n";
			$custom_css .= "font-family: '{$font_name}';\n";
			$custom_css .= "font-weight: {$font_weight};\n";
			$custom_css .= "src: url('{$font_url}') format('{$format}');\n";
			$custom_css .= "}\n";
		}
	}

	$tags = theme_title_tag();

	// Loop through each tag
	foreach ( $tags as $tag ) {
		// Apply styles for the current tag
		$custom_css .= "$tag {";
		$custom_css .= "font-family: " . option_value( "typography-admin", 'font-family' ) . " !important;";

		if ( option_value( "typography-admin", 'font-weight' ) ) {
			$custom_css .= "font-weight: " . option_value( "typography-admin", 'font-weight' ) . "!important;";
		}
		if ( option_value( "typography-admin", 'font-style' ) ) {
			$custom_css .= "font-style: " . option_value( "typography-admin", 'font-style' ) . "!important;";
		}
		if ( option_value( "typography-admin", 'color' ) ) {
			$custom_css .= "color: " . option_value( "typography-admin", 'color' ) . "!important;";
		}

		$custom_css .= "}\n";
	}
}
$custom_css .= '.elementor-loading-title{letter-spacing:0px !important;;font-size: 20px !important;;}';